/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class BaseButtonCompiler<S extends N2oAbstractButton, B extends AbstractButton>
implements BaseSourceCompiler<B, S, CompileContext<?, ?>> {
    protected void initItem(AbstractButton button, N2oAbstractButton source, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        button.setId(source.getId());
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        if (source.getType() != null && source.getType() == LabelType.icon) {
            button.setIcon(source.getIcon());
        } else if (source.getType() != null && source.getType() == LabelType.text) {
            button.setLabel(source.getLabel());
        } else {
            button.setIcon(source.getIcon());
            button.setLabel(source.getLabel());
        }
        button.setClassName(source.getCssClass());
        button.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        this.initColor(source, button, p);
        this.initHint(source, button, p);
    }

    private void initHint(N2oAbstractButton source, AbstractButton button, CompileProcessor p) {
        String hint = LabelType.icon.equals((Object)source.getType()) ? (String)p.cast((Object)source.getDescription(), (Object)source.getLabel(), new Object[0]) : source.getDescription();
        if (hint != null) {
            button.setHint(hint.trim());
            if (source.getTooltipPosition() != null) {
                button.setHintPosition(source.getTooltipPosition());
            } else {
                button.setHintPosition(source instanceof N2oButton ? (String)p.resolve(Placeholders.property((String)"n2o.api.button.tooltip_position"), String.class) : (String)p.resolve(Placeholders.property((String)"n2o.api.menuitem.tooltip_position"), String.class));
            }
        }
    }

    private void initColor(N2oAbstractButton source, AbstractButton button, CompileProcessor p) {
        if (source.getColor() == null) {
            N2oCell cell;
            ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
            if (componentScope != null && (cell = componentScope.unwrap(N2oCell.class)) != null) {
                button.setColor((String)p.resolve(Placeholders.property((String)"n2o.api.cell.toolbar.button-color"), String.class));
            }
        } else {
            button.setColor(source.getColor());
        }
    }
}

