/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.reader.ElementReaderFactory;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class SelectiveUtil {
    public static <N extends SourceMetadata> N readByPath(String id, String path, NamespaceReaderFactory readerFactory) {
        SourceMetadata n2o = (SourceMetadata)SelectiveUtil.readByPath(path, readerFactory);
        n2o.setId(id);
        return (N)n2o;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <N> N readByPath(String uri, NamespaceReaderFactory readerFactory) {
        try (InputStream inputStream = FileSystemUtil.getContentAsStream(uri);){
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(inputStream);
            Element root = doc.getRootElement();
            Object object = readerFactory.produce(root).read(root);
            return (N)object;
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <N> N read(String source, ElementReaderFactory readerFactory) {
        try (StringReader stringReader = new StringReader(source);){
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)stringReader);
            Element root = doc.getRootElement();
            Object object = readerFactory.produce(root).read(root);
            return (N)object;
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException(e);
        }
    }
}

