/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.aware.WidgetIdAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.action.AbstractAction;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractOpenPageCompiler<D extends AbstractAction, S extends N2oAbstractPageAction>
extends AbstractActionCompiler<D, S> {
    protected List<N2oPreFilter> initPreFilters(N2oAbstractPageAction source, String masterIdParam, CompileProcessor p) {
        ArrayList<N2oPreFilter> preFilters = new ArrayList<N2oPreFilter>();
        ReduxModel model = ReduxModel.RESOLVE;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String widgetId = widgetScope == null ? null : widgetScope.getWidgetId();
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null) {
            WidgetIdAware widgetIdAware;
            ModelAware modelAware = componentScope.unwrap(ModelAware.class);
            if (modelAware != null && modelAware.getModel() != null) {
                model = modelAware.getModel();
            }
            if ((widgetIdAware = componentScope.unwrap(WidgetIdAware.class)) != null && widgetIdAware.getWidgetId() != null) {
                widgetId = widgetIdAware.getWidgetId();
            }
        }
        if (source.getDetailFieldId() != null) {
            N2oPreFilter filter = new N2oPreFilter();
            filter.setFieldId((String)p.cast((Object)source.getDetailFieldId(), (Object)"id", new Object[0]));
            filter.setType(FilterType.eq);
            filter.setValueAttr(Placeholders.ref((String)((String)p.cast((Object)source.getMasterFieldId(), (Object)"id", new Object[0]))));
            filter.setRefWidgetId(widgetId);
            if ((source.getMasterFieldId() == null || source.getMasterFieldId().equals("id")) && ReduxModel.RESOLVE.equals((Object)model)) {
                filter.setParam((String)p.cast((Object)source.getMasterParam(), (Object)masterIdParam, new Object[]{filter.getFieldId()}));
            } else {
                filter.setParam(filter.getFieldId());
            }
            filter.setRefModel(ReduxModel.RESOLVE);
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            if (pageScope != null) {
                filter.setRefPageId(pageScope.getPageId());
            }
            preFilters.add(filter);
        }
        if (source.getPreFilters() != null) {
            for (N2oPreFilter preFilter : source.getPreFilters()) {
                N2oPreFilter filter = new N2oPreFilter();
                filter.setFieldId(preFilter.getFieldId());
                filter.setParam((String)p.cast((Object)preFilter.getParam(), (Object)filter.getFieldId(), new Object[0]));
                filter.setType(preFilter.getType());
                filter.setValueAttr(preFilter.getValueAttr());
                filter.setValuesAttr(preFilter.getValuesAttr());
                filter.setRefWidgetId((String)p.cast((Object)preFilter.getRefWidgetId(), (Object)widgetId, new Object[0]));
                filter.setRefModel((ReduxModel)p.cast((Object)preFilter.getRefModel(), (Object)model, new Object[0]));
                PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                if (pageScope != null) {
                    filter.setRefPageId(pageScope.getPageId());
                }
                preFilters.add(filter);
            }
        }
        return preFilters;
    }

    protected abstract PageContext constructContext(String var1, String var2);

    protected PageContext initPageContext(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p) {
        String pageId = source.getPageId();
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String route = (String)p.cast((Object)(routeScope != null ? routeScope.getUrl() : null), (Object)context.getRoute((BindProcessor)((N2oCompileProcessor)p)), new Object[]{""});
        StrictMap pathMapping = new StrictMap();
        StrictMap queryMapping = new StrictMap();
        if (routeScope != null) {
            pathMapping.putAll(routeScope.getPathMapping());
            queryMapping.putAll(routeScope.getQueryMapping());
        }
        String currentClientWidgetId = null;
        String currentWidgetQueryId = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            currentClientWidgetId = widgetScope.getClientWidgetId();
            currentWidgetQueryId = widgetScope.getQueryId();
        }
        ModelLink actionModelLink = null;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null) {
            ModelAware modelAware = componentScope.unwrap(ModelAware.class);
            ReduxModel actionDataModel = ReduxModel.RESOLVE;
            if (modelAware != null && modelAware.getModel() != null) {
                actionDataModel = modelAware.getModel();
            }
            WidgetIdAware widgetIdAware = componentScope.unwrap(WidgetIdAware.class);
            String actionDataModelClientWidgetId = null;
            actionDataModelClientWidgetId = widgetIdAware != null && widgetIdAware.getWidgetId() != null ? pageScope.getGlobalWidgetId(widgetIdAware.getWidgetId()) : currentClientWidgetId;
            if (actionDataModel != null && actionDataModelClientWidgetId != null) {
                actionModelLink = currentClientWidgetId != null && currentClientWidgetId.equals(actionDataModelClientWidgetId) && ReduxModel.RESOLVE.equals((Object)actionDataModel) ? Redux.linkQuery(actionDataModelClientWidgetId, "id", currentWidgetQueryId) : new ModelLink(actionDataModel, actionDataModelClientWidgetId, "id");
            }
        }
        if (actionModelLink == null) {
            throw new N2oException("widget-id for action " + source.getId() + " not specified");
        }
        if (currentClientWidgetId == null) {
            currentClientWidgetId = actionModelLink.getWidgetId();
        }
        String actionRoute = this.initActionRoute(source, actionModelLink);
        String masterIdParam = this.initMasterLink(actionRoute, (Map<String, ModelLink>)pathMapping, actionModelLink);
        route = RouteUtil.normalize(route + actionRoute);
        String parentRoute = RouteUtil.absolute("../", route);
        PageContext pageContext = this.constructContext(pageId, route);
        pageContext.setPageName(source.getPageName());
        pageContext.setBreadcrumbs((List)p.getScope(BreadcrumbList.class));
        pageContext.setSubmitOperationId(source.getSubmitOperationId());
        pageContext.setSubmitLabel(source.getSubmitLabel());
        pageContext.setSubmitModel(source.getSubmitModel());
        pageContext.setResultWidgetId(source.getResultContainerId());
        pageContext.setUpload(source.getUpload());
        pageContext.setParentWidgetId(currentClientWidgetId);
        pageContext.setParentModelLink(actionModelLink);
        pageContext.setParentRoute(RouteUtil.addQueryParams(parentRoute, queryMapping.keySet()));
        pageContext.setCloseOnSuccessSubmit((Boolean)p.cast((Object)source.getCloseAfterSubmit(), (Object)true, new Object[0]));
        pageContext.setRefreshOnSuccessSubmit((Boolean)p.cast((Object)source.getRefreshAfterSubmit(), (Object)true, new Object[0]));
        if (source.getRefreshWidgetId() != null) {
            pageContext.setRefreshClientWidgetId(pageScope.getGlobalWidgetId(source.getRefreshWidgetId()));
        }
        pageContext.setRefreshOnClose((Boolean)p.cast((Object)source.getRefreshOnClose(), (Object)false, new Object[0]));
        pageContext.setUnsavedDataPromptOnClose(source.getUnsavedDataPromptOnClose());
        if (source.getSubmitOperationId() != null && source.getRedirectUrlAfterSubmit() == null && source.getFocusAfterSubmit() != null && source.getFocusAfterSubmit().booleanValue()) {
            pageContext.setRedirectUrlOnSuccessSubmit(routeScope != null ? RouteUtil.normalize(routeScope.getUrl() + RouteUtil.normalize(Placeholders.colon((String)"id"))) : null);
            pageContext.setRedirectTargetOnSuccessSubmit(Target.application);
        } else if (source.getRedirectUrlAfterSubmit() != null) {
            pageContext.setRedirectUrlOnSuccessSubmit(source.getRedirectUrlAfterSubmit());
            pageContext.setRedirectTargetOnSuccessSubmit((Target)p.cast((Object)source.getRedirectTargetAfterSubmit(), (Object)(RouteUtil.isApplicationUrl(source.getRedirectUrlAfterSubmit()) ? Target.application : Target.self), new Object[0]));
        }
        List<N2oPreFilter> preFilters = this.initPreFilters((N2oAbstractPageAction)source, masterIdParam, p);
        pageContext.setPreFilters(preFilters);
        pageContext.setPathRouteMapping((Map<String, ModelLink>)pathMapping);
        queryMapping.putAll(this.initPreFilterParams(preFilters, (Map<String, ModelLink>)pathMapping, (Map<String, ModelLink>)queryMapping));
        pageContext.setQueryRouteMapping((Map<String, ModelLink>)queryMapping);
        this.initPageRoute(compiled, route, (Map<String, ModelLink>)pathMapping, (Map<String, ModelLink>)queryMapping);
        this.initOtherPageRoute(p, context, route);
        p.addRoute((CompileContext)pageContext);
        return pageContext;
    }

    private String initMasterLink(String actionRoute, Map<String, ModelLink> pathMapping, ModelLink actionModelLink) {
        List<String> actionRouteParams = RouteUtil.getParams(actionRoute);
        String masterIdParam = null;
        if (!actionRouteParams.isEmpty()) {
            if (actionModelLink == null) {
                throw new N2oException("Action route contains params " + actionRoute + ", but parent widget not found");
            }
            if (actionRouteParams.size() > 1) {
                throw new N2oException("Action route can not contain more then one param: " + actionRoute);
            }
            masterIdParam = actionRouteParams.get(0);
            pathMapping.put(masterIdParam, actionModelLink);
        }
        return masterIdParam;
    }

    private String initActionRoute(S source, ModelLink actionModelLink) {
        String actionRoute = source.getRoute();
        if (actionRoute == null) {
            actionRoute = RouteUtil.normalize(source.getId());
            if (actionModelLink != null && ReduxModel.RESOLVE.equals((Object)actionModelLink.getModel())) {
                String masterIdParam = source.getMasterParam() != null ? source.getMasterParam() : actionModelLink.getWidgetId() + "_id";
                actionRoute = RouteUtil.normalize(Placeholders.colon((String)masterIdParam)) + actionRoute;
            }
        }
        return actionRoute;
    }

    protected abstract void initPageRoute(D var1, String var2, Map<String, ModelLink> var3, Map<String, ModelLink> var4);

    private void initOtherPageRoute(CompileProcessor p, CompileContext<?, ?> context, String route) {
        if (context instanceof ModalPageContext) {
            return;
        }
        PageRoutes pageRoutes = (PageRoutes)p.getScope(PageRoutes.class);
        if (pageRoutes != null) {
            PageRoutes.Route pageRoute = new PageRoutes.Route(route);
            pageRoute.setIsOtherPage(Boolean.valueOf(true));
            pageRoutes.addRoute(pageRoute);
        }
    }

    private Map<String, ModelLink> initPreFilterParams(List<N2oPreFilter> preFilters, Map<String, ModelLink> pathParams, Map<String, ModelLink> queryParams) {
        if (preFilters == null) {
            return null;
        }
        HashMap<String, ModelLink> res = new HashMap<String, ModelLink>();
        HashSet<String> params = new HashSet<String>();
        params.addAll(pathParams.keySet());
        params.addAll(queryParams.keySet());
        preFilters.stream().filter(f -> f.getParam() != null && !params.contains(f.getParam())).forEach(f -> res.put(f.getParam(), Redux.linkFilter(f)));
        return res;
    }
}

