/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.header;

import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.header.CompiledHeader;
import net.n2oapp.framework.api.metadata.header.N2oSimpleHeader;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.context.HeaderContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import org.springframework.stereotype.Component;

@Component
public class SimpleHeaderCompiler
implements BaseSourceCompiler<CompiledHeader, N2oSimpleHeader, HeaderContext>,
SourceClassAware {
    public CompiledHeader compile(N2oSimpleHeader source, HeaderContext context, CompileProcessor p) {
        CompiledHeader header = new CompiledHeader();
        header.setSrc(source.getSrc());
        header.setBrand((String)p.cast((Object)source.getProjectName(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.ui.project.name"), String.class)), new Object[]{"N<sub>2</sub>O"}));
        header.setBrandImage(source.getProjectImageSrc());
        header.setColor((String)p.cast((Object)source.getColor(), (Object)"default", new Object[0]));
        header.setFixed((Boolean)p.resolve(Placeholders.property((String)"n2o.api.default.header.fixed"), Boolean.class));
        header.setCollapsed((Boolean)p.resolve(Placeholders.property((String)"n2o.api.default.header.collapsed"), Boolean.class));
        header.setClassName(source.getCssClass());
        header.setSearch(Boolean.valueOf(false));
        this.initWelcomePage(source, p);
        header.setItems(source.getMenu() != null ? (SimpleMenu)p.compile((Object)source.getMenu(), (CompileContext)context, new Object[0]) : new SimpleMenu());
        header.setExtraItems(source.getExtraMenu() != null ? (SimpleMenu)p.compile((Object)source.getExtraMenu(), (CompileContext)context, new Object[0]) : new SimpleMenu());
        return header;
    }

    private void initWelcomePage(N2oSimpleHeader source, CompileProcessor p) {
        String welcomePageId = source.getMenu() != null && source.getMenu().getWelcomePageId() != null ? source.getMenu().getWelcomePageId() : (source.getHomePageId() != null ? source.getHomePageId() : (String)p.resolve(Placeholders.property((String)"n2o.ui.homepage.id"), String.class));
        PageContext context = new PageContext(welcomePageId, "/");
        p.addRoute((CompileContext)context);
    }

    public Class<N2oSimpleHeader> getSourceClass() {
        return N2oSimpleHeader.class;
    }
}

