/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.persister.widget;

import java.util.List;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oDynamicSwitch;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.config.persister.util.PersisterJdomUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class DynamicSwitchPersister {
    public static <T extends NamespaceUriAware> Element persist(N2oDynamicSwitch<T> entity, Namespace namespace, NamespacePersisterFactory<T, NamespacePersister<T>> persisterFactory) {
        if ((entity.getCases() == null || entity.getCases().isEmpty()) && entity.getDefaultCase() == null) {
            return null;
        }
        Element switchElement = new Element("switch", namespace);
        PersisterJdomUtil.setAttribute(switchElement, "value-field-id", entity.getValueFieldId());
        if (entity.getCases() != null) {
            List cases = entity.getCases().entrySet().stream().map(c -> {
                Element caseElement = new Element("case", namespace);
                caseElement.addContent((Content)persisterFactory.produce((NamespaceUriAware)c.getValue()).persist((Object)((NamespaceUriAware)c.getValue()), namespace));
                PersisterJdomUtil.setAttribute(caseElement, "value", (String)c.getKey());
                return caseElement;
            }).collect(Collectors.toList());
            switchElement.addContent(cases);
        }
        if (entity.getDefaultCase() != null) {
            Element defaultValue = new Element("default", namespace);
            defaultValue.addContent((Content)persisterFactory.produce((NamespaceUriAware)entity.getDefaultCase()).persist((Object)((NamespaceUriAware)entity.getDefaultCase()), namespace));
            switchElement.addContent((Content)defaultValue);
        }
        return switchElement;
    }
}

