/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.fieldset;

import java.util.List;
import net.n2oapp.framework.api.metadata.aware.CssClassAware;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldSet;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetRow;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oSetFieldSet;
import net.n2oapp.framework.api.metadata.reader.AbstractFactoredReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.config.reader.fieldset.FieldSetReaderUtil;
import net.n2oapp.framework.config.reader.tools.CssClassAwareReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.stereotype.Component;

@Component
public class FieldSetXmlReaderV2
extends AbstractFactoredReader<N2oFieldSet>
implements NamespaceReader<N2oFieldSet> {
    public N2oFieldSet read(Element element, Namespace namespace) {
        N2oSetFieldSet n2oFieldSet = new N2oSetFieldSet();
        String refId = ReaderJdomUtil.getAttributeString(element, "ref-id");
        if (refId != null) {
            n2oFieldSet.setRefId(refId);
        }
        n2oFieldSet.setLabel(ReaderJdomUtil.getAttributeString(element, "label"));
        FieldSetReaderUtil.getType(element, "header", (N2oFieldSet)n2oFieldSet);
        n2oFieldSet.setDependencyCondition(ReaderJdomUtil.getAttributeString(element, "dependency-condition"));
        n2oFieldSet.setFieldLabelLocation(ReaderJdomUtil.getAttributeEnum(element, "field-label-location", N2oFieldSet.FieldLabelLocation.class));
        n2oFieldSet.setCssClass(ReaderJdomUtil.getAttributeString(element, "css-class"));
        n2oFieldSet.setStyle(ReaderJdomUtil.getAttributeString(element, "style"));
        if (refId != null) {
            return n2oFieldSet;
        }
        List children = element.getChildren();
        n2oFieldSet.setItems(new NamespaceUriAware[children.size()]);
        int i = 0;
        for (Element child : children) {
            if (child.getNamespace().equals((Object)namespace) && child.getName().equals("row")) {
                N2oFieldsetRow row = new N2oFieldsetRow();
                row.setItems(new NamespaceUriAware[child.getChildren().size()]);
                int j = 0;
                for (Object field : child.getChildren()) {
                    row.getItems()[j] = (N2oField)this.readerFactory.produce((Element)field).read((Element)field);
                    ++j;
                }
                n2oFieldSet.getItems()[i] = row;
            } else {
                n2oFieldSet.getItems()[i] = (N2oField)this.readerFactory.produce(child).read(child);
            }
            ++i;
        }
        CssClassAwareReader.getInstance().read((CssClassAware)n2oFieldSet, element);
        return n2oFieldSet;
    }

    public Class<N2oFieldSet> getElementClass() {
        return N2oFieldSet.class;
    }

    public String getNamespaceUri() {
        return "http://n2oapp.net/framework/config/schema/fieldset-2.0";
    }

    public String getElementName() {
        return "field-set";
    }
}

