/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.n2oapp.context.StaticSpringContext;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.global.aware.IdAware;
import net.n2oapp.framework.api.metadata.reader.ElementReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.util.JdomTextProcessing;
import net.n2oapp.framework.config.reader.util.N2oJdomTextProcessing;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

@Deprecated
public class ReaderJdomUtil {
    private static JdomTextProcessing jdomTextProcessing = new N2oJdomTextProcessing();

    public ReaderJdomUtil() {
        jdomTextProcessing = (JdomTextProcessing)StaticSpringContext.getBean(N2oJdomTextProcessing.class);
    }

    public static void clearTextProcessing() {
        jdomTextProcessing = null;
    }

    public static String getAttributeString(Element element, String attribute) {
        if (element == null) {
            return null;
        }
        Attribute attr = element.getAttribute(attribute);
        if (attr != null) {
            return ReaderJdomUtil.getText(attr);
        }
        return null;
    }

    public static String getAttributeString(Element element, String attribute, String defaultValue) {
        String res = ReaderJdomUtil.getAttributeString(element, attribute);
        if (res == null) {
            res = defaultValue;
        }
        return res;
    }

    public static Integer getAttributeInteger(Element element, String attribute) {
        if (element == null) {
            return null;
        }
        if (element.getAttribute(attribute) != null) {
            try {
                return Integer.valueOf(ReaderJdomUtil.getText(element.getAttribute(attribute)).trim());
            }
            catch (NumberFormatException e) {
                throw new MetadataReaderException(e);
            }
        }
        return null;
    }

    public static Boolean getAttributeBoolean(Element element, String attribute) {
        if (element == null) {
            return null;
        }
        if (element.getAttribute(attribute) != null) {
            return Boolean.valueOf(ReaderJdomUtil.getText(element.getAttribute(attribute)));
        }
        return null;
    }

    public static Boolean getAttributeBoolean(Element element, String attribute, String reserveAttribute) {
        Boolean res = ReaderJdomUtil.getAttributeBoolean(element, attribute);
        if (res != null) {
            return res;
        }
        return ReaderJdomUtil.getAttributeBoolean(element, reserveAttribute);
    }

    public static <T extends Enum<T>> T getElementEnum(Element parentElement, String elementName, Class<T> enumClass) {
        return ReaderJdomUtil.stringToEnum(ReaderJdomUtil.getElementString(parentElement, elementName), enumClass);
    }

    public static <T extends Enum<T>> T getAttributeEnum(Element element, String attribute, Class<T> enumClass) {
        if (element.getAttribute(attribute) != null) {
            String value = ReaderJdomUtil.getText(element.getAttribute(attribute));
            return ReaderJdomUtil.stringToEnum(value, enumClass);
        }
        return null;
    }

    public static <T extends Enum<T>> T getElementAttributeEnum(Element parentElement, String elementName, String attributeName, Class<T> enumClass) {
        Element child = parentElement.getChild(elementName, parentElement.getNamespace());
        if (child != null) {
            return ReaderJdomUtil.getAttributeEnum(child, attributeName, enumClass);
        }
        return null;
    }

    public static String getElementAttributeString(Element parentElement, String elementName, String attributeName) {
        Element child = parentElement.getChild(elementName, parentElement.getNamespace());
        if (child != null) {
            return ReaderJdomUtil.getAttributeString(child, attributeName);
        }
        return null;
    }

    public static Integer getElementAttributeInteger(Element parentElement, String elementName, String attributeName) {
        Element child = parentElement.getChild(elementName, parentElement.getNamespace());
        if (child != null) {
            return ReaderJdomUtil.getAttributeInteger(child, attributeName);
        }
        return null;
    }

    public static Boolean getElementAttributeBoolean(Element parentElement, String elementName, String attributeName) {
        Element child = parentElement.getChild(elementName, parentElement.getNamespace());
        if (child != null) {
            return ReaderJdomUtil.getAttributeBoolean(child, attributeName);
        }
        return null;
    }

    private static <T extends Enum<T>> T stringToEnum(String value, Class<T> enumClass) {
        if (value == null) {
            return null;
        }
        Enum res = null;
        boolean idAware = IdAware.class.isAssignableFrom(enumClass);
        if (idAware) {
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                IdAware idEnum = (IdAware)enumValue;
                if (!idEnum.getId().equalsIgnoreCase(value)) continue;
                res = enumValue;
            }
        } else {
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(value)) continue;
                res = enumValue;
            }
        }
        return (T)res;
    }

    public static Boolean getElementBoolean(Element element, String elementName) {
        Element child = element.getChild(elementName, element.getNamespace());
        if (child != null) {
            return Boolean.valueOf(ReaderJdomUtil.getText(child));
        }
        return null;
    }

    public static String getElementString(Element element, String elementName) {
        Element child = element.getChild(elementName, element.getNamespace());
        if (child != null) {
            String text = ReaderJdomUtil.getText(child);
            return text.isEmpty() ? null : text;
        }
        return null;
    }

    public static Integer getElementInteger(Element element, String elementName) {
        String value = ReaderJdomUtil.getElementString(element, elementName);
        return value != null ? Integer.valueOf(value) : null;
    }

    public static List<String> getElementsStringList(Element parentElement, String elementName) {
        if (parentElement == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        List elements = parentElement.getChildren();
        if (elements == null) {
            return null;
        }
        for (Element element : elements) {
            if (!element.getName().equals(elementName)) continue;
            result.add(ReaderJdomUtil.getText(element));
        }
        return result;
    }

    public static String[] getElementsStringArray(Element parentElement, String elementName) {
        if (parentElement == null) {
            return null;
        }
        String[] result = new String[parentElement.getChildren().size()];
        List elements = parentElement.getChildren();
        if (elements == null) {
            return null;
        }
        int i = 0;
        for (Element element : elements) {
            if (!element.getName().equals(elementName)) continue;
            result[i] = ReaderJdomUtil.getText(element);
            ++i;
        }
        return result;
    }

    public static <T> T getChild(Element element, String elementName, ElementReader<T> reader) {
        if (element == null) {
            return null;
        }
        Element child = element.getChild(elementName, element.getNamespace());
        if (child == null) {
            return null;
        }
        return (T)reader.read(child);
    }

    public static <T> T getChild(Element element, String sequenceName, String elementName, ElementReader<T> reader) {
        if (element == null) {
            return null;
        }
        Element child = element.getChild(sequenceName, element.getNamespace());
        if (child == null) {
            return null;
        }
        if ((child = child.getChild(elementName, element.getNamespace())) == null) {
            return null;
        }
        return (T)reader.read(child);
    }

    public static List<Element> getChildrenElements(Element element, String sequenceName, String elementName) {
        Element child = element;
        if (sequenceName != null) {
            child = element.getChild(sequenceName, element.getNamespace());
        }
        if (child == null) {
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        List sequences = child.getChildren();
        if (sequences == null) {
            return null;
        }
        for (Element seqElement : sequences) {
            if (elementName != null && !seqElement.getName().equals(elementName)) continue;
            result.add(seqElement);
        }
        return result;
    }

    public static <T extends NamespaceUriAware> List<T> getChildrenAsList(Element element, String sequenceName, NamespaceReaderFactory readerFactory, String defaultReaderNamespaceUri) {
        List<Element> elements = ReaderJdomUtil.getChildrenElements(element, sequenceName, null);
        if (elements == null) {
            return null;
        }
        ArrayList<NamespaceUriAware> result = new ArrayList<NamespaceUriAware>();
        for (Element e : elements) {
            if (e.getNamespace().getURI().equals(element.getNamespace().getURI())) {
                NamespaceUriAware child = (NamespaceUriAware)readerFactory.produce(e, element.getNamespace(), Namespace.getNamespace((String)defaultReaderNamespaceUri)).read(e);
                child.setNamespaceUri(element.getNamespaceURI());
                result.add(child);
                continue;
            }
            result.add((NamespaceUriAware)readerFactory.produce(e).read(e));
        }
        return result;
    }

    public static <T> List<T> getChildrenAsList(Element element, String sequenceName, String elementName, ElementReader<T> reader) {
        List<Element> elements = ReaderJdomUtil.getChildrenElements(element, sequenceName, elementName);
        if (elements == null) {
            return null;
        }
        return elements.stream().map(arg_0 -> reader.read(arg_0)).collect(Collectors.toList());
    }

    public static <T extends NamespaceUriAware> T[] getChildren(Element element, String sequenceName, NamespaceReaderFactory readerFactory, String defaultNamespaceUri, Class<T> elementClass) {
        List<T> result = ReaderJdomUtil.getChildrenAsList(element, sequenceName, readerFactory, defaultNamespaceUri);
        if (result == null) {
            return null;
        }
        NamespaceUriAware[] resultArray = (NamespaceUriAware[])Array.newInstance(elementClass, result.size());
        for (int k = 0; k < resultArray.length; ++k) {
            resultArray[k] = (NamespaceUriAware)result.get(k);
        }
        return resultArray;
    }

    public static <T> T[] getChildren(Element element, String sequenceName, String elementName, TypedElementReader<T> reader) {
        List<T> result = ReaderJdomUtil.getChildrenAsList(element, sequenceName, elementName, reader);
        if (result == null) {
            return null;
        }
        Object[] resultArray = (Object[])Array.newInstance(reader.getElementClass(), result.size());
        for (int k = 0; k < resultArray.length; ++k) {
            resultArray[k] = result.get(k);
        }
        return resultArray;
    }

    public static <T> T[] getChildren(Element element, String sequenceName, final String elementName, final ElementReader<T> reader, final Class<T> type) {
        return ReaderJdomUtil.getChildren(element, sequenceName, elementName, new TypedElementReader<T>(){

            public String getElementName() {
                return elementName;
            }

            public Class<T> getElementClass() {
                return type;
            }

            public T read(Element element) {
                return reader.read(element);
            }
        });
    }

    public static <T> List<T> getChildrenAsList(Element element, ElementReader<T> reader) {
        return ReaderJdomUtil.getChildrenAsList(element, null, null, reader);
    }

    public static String getText(Attribute attr) {
        return ReaderJdomUtil.processText(attr.getValue());
    }

    private static String processText(String res) {
        if (res == null) {
            return null;
        }
        return jdomTextProcessing != null ? jdomTextProcessing.process(res) : res;
    }

    public static String getElementText(Element child) {
        String res = ReaderJdomUtil.getText(child);
        return res.isEmpty() ? null : res;
    }

    public static String getText(Element child) {
        return ReaderJdomUtil.processText(child.getValue());
    }

    public static boolean isElementExists(Element field, String name) {
        return field != null && field.getChild(name, field.getNamespace()) != null;
    }

    @Deprecated
    public static String getElementString(Element element, Namespace namespace, String elementName) {
        return ReaderJdomUtil.getElementString(element, elementName);
    }

    @Deprecated
    public static String getElementString(Element element, String elementName, Namespace namespace) {
        return ReaderJdomUtil.getElementString(element, elementName);
    }

    @Deprecated
    public static <T> T getChild(Element element, Namespace namespace, String elementName, TypedElementReader<T> reader) {
        return ReaderJdomUtil.getChild(element, elementName, reader);
    }

    @Deprecated
    public static <T> T[] getChilds(Element element, Namespace namespace, String sequenceName, String elementName, TypedElementReader<T> reader) {
        return ReaderJdomUtil.getChildren(element, sequenceName, elementName, reader);
    }

    @Deprecated
    public static Element[] getChilds(Element element, Namespace namespace, String sequenceName, final String elementName) {
        return ReaderJdomUtil.getChilds(element, namespace, sequenceName, elementName, new TypedElementReader<Element>(){

            public String getElementName() {
                return elementName;
            }

            public Element read(Element element) {
                return element;
            }

            public Class<Element> getElementClass() {
                return Element.class;
            }
        });
    }

    @Deprecated
    public static <T> T[] getChilds(Element element, Namespace namespace, String elementName, TypedElementReader<T> reader) {
        if (element == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        List sequences = element.getChildren();
        for (Element seqElement : sequences) {
            if ((elementName != null || seqElement.getNamespace().equals((Object)namespace)) && !seqElement.getName().equals(elementName)) continue;
            result.add(reader.read(seqElement));
        }
        Object[] resultArray = (Object[])Array.newInstance(reader.getElementClass(), result.size());
        for (int k = 0; k < resultArray.length; ++k) {
            resultArray[k] = result.get(k);
        }
        return resultArray;
    }
}

