/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.route;

import java.util.Map;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.meta.Page;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.register.route.MetadataRouter;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.api.register.route.RouteRegister;
import net.n2oapp.framework.config.register.route.RouteNotFoundException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class N2oRouter
implements MetadataRouter {
    public static final String ROOT_ROUTE = "/";
    private RouteRegister register;
    private ReadCompileTerminalPipeline<?> pipeline;
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public N2oRouter(RouteRegister register, ReadCompileTerminalPipeline<?> pipeline) {
        this.register = register;
        this.pipeline = pipeline;
    }

    public <D extends Compiled> CompileContext<D, ?> get(String url, Class<D> compiledClass) {
        CompileContext<D, ?> result = this.findRoute(url = url != null ? url : ROOT_ROUTE, compiledClass);
        if (result != null) {
            return result;
        }
        this.tryToFindShallow(url, compiledClass);
        result = this.findRoute(url, compiledClass);
        if (result != null) {
            return result;
        }
        this.tryToFindDeep(url);
        result = this.findRoute(url, compiledClass);
        if (result != null) {
            return result;
        }
        throw new RouteNotFoundException(url);
    }

    private <D extends Compiled> CompileContext<D, ?> findRoute(String url, Class<D> compiledClass) {
        for (Map.Entry routeEntry : this.register) {
            if (!this.matchInfo((RouteInfoKey)routeEntry.getKey(), url) || !compiledClass.isAssignableFrom(((CompileContext)routeEntry.getValue()).getCompiledClass())) continue;
            return (CompileContext)routeEntry.getValue();
        }
        return null;
    }

    private boolean matchInfo(RouteInfoKey info, String urlMatching) {
        return this.pathMatcher.match(info.getUrlMatching(), urlMatching);
    }

    private <D extends Compiled> void tryToFindShallow(String url, Class<D> compiledClass) {
        if (Page.class == compiledClass) {
            return;
        }
        CompileContext<Page, ?> result = this.findRoute(url, Page.class);
        if (result != null) {
            this.pipeline.get(result);
        }
    }

    private void tryToFindDeep(String url) {
        if (url.length() > 1) {
            int idx = url.lastIndexOf(ROOT_ROUTE);
            String subUrl = idx > 0 ? url.substring(0, idx) : ROOT_ROUTE;
            CompileContext<Page, ?> result = this.findRoute(subUrl, Page.class);
            if (result == null) {
                this.tryToFindDeep(subUrl);
                result = this.findRoute(subUrl, Page.class);
            }
            if (result != null) {
                this.pipeline.get(result);
            }
        }
    }
}

