/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.test;

import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.header.N2oHeader;
import net.n2oapp.framework.config.metadata.compile.context.HeaderContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.context.WidgetContext;
import net.n2oapp.framework.config.selective.CompileInfo;
import net.n2oapp.framework.config.test.FrontendFileSystemResource;
import net.n2oapp.framework.config.test.JsonChecker;
import net.n2oapp.framework.config.test.JsonMetadataTester;
import net.n2oapp.framework.config.test.N2oTestBase;
import org.springframework.core.io.Resource;

public abstract class JsonMetadataTestBase
extends N2oTestBase {
    protected JsonMetadataTester tester;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.tester = new JsonMetadataTester(this.builder);
    }

    public JsonChecker check(String xmlUri, String jsonUri) {
        return this.check(xmlUri, (Resource)new FrontendFileSystemResource(jsonUri));
    }

    public JsonChecker check(String xmlUri, Resource json) {
        CompileInfo info = new CompileInfo(xmlUri);
        this.builder.sources(info);
        return new JsonChecker(this.getContext(info), json, this.tester);
    }

    public JsonChecker check(String jsonUri) {
        return new JsonChecker((Resource)new FrontendFileSystemResource(jsonUri), this.tester);
    }

    public JsonChecker check(Resource json) {
        return new JsonChecker(json, this.tester);
    }

    public JsonChecker check() {
        return new JsonChecker(this.tester);
    }

    private CompileContext<?, ?> getContext(CompileInfo info) {
        if (N2oPage.class.isAssignableFrom(info.getBaseSourceClass())) {
            return new PageContext(info.getId());
        }
        if (N2oWidget.class.isAssignableFrom(info.getBaseSourceClass())) {
            return new WidgetContext(info.getId());
        }
        if (N2oHeader.class.isAssignableFrom(info.getBaseSourceClass())) {
            return new HeaderContext(info.getId());
        }
        throw new IllegalArgumentException("Unsupported class [" + info.getBaseSourceClass() + "]. Please use assertEquals(context)");
    }
}

