/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.test;

import java.util.Properties;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.compile.pipeline.N2oEnvironment;
import net.n2oapp.framework.config.metadata.pack.N2oOperationsPack;
import net.n2oapp.framework.config.metadata.pack.N2oSourceTypesPack;
import net.n2oapp.framework.config.selective.CompileInfo;
import net.n2oapp.framework.config.selective.SelectiveMetadataLoader;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import net.n2oapp.framework.config.selective.reader.ReaderFactoryByMap;
import net.n2oapp.framework.config.test.SimplePropertyResolver;
import net.n2oapp.properties.OverrideProperties;
import net.n2oapp.properties.reader.PropertiesReader;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;

public abstract class N2oTestBase {
    protected N2oApplicationBuilder builder;

    public void setUp() throws Exception {
        N2oEnvironment environment = new N2oEnvironment();
        environment.setNamespacePersisterFactory(new PersisterFactoryByMap());
        environment.setNamespaceReaderFactory(new ReaderFactoryByMap());
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"n2o_messages", "messages"});
        messageSource.setDefaultEncoding("UTF-8");
        environment.setMessageSource(new MessageSourceAccessor((MessageSource)messageSource));
        OverrideProperties properties = PropertiesReader.getPropertiesFromClasspath((String)"META-INF/n2o.properties");
        environment.setSystemProperties(new SimplePropertyResolver((Properties)properties));
        this.builder = new N2oApplicationBuilder(environment);
        this.configure(this.builder);
        CompileInfo.setSourceTypes(this.builder.getEnvironment().getSourceTypeRegister());
    }

    protected void configure(N2oApplicationBuilder builder) {
        builder.packs(new N2oSourceTypesPack(), new N2oOperationsPack());
        builder.loaders(new SelectiveMetadataLoader(builder.getEnvironment().getNamespaceReaderFactory()));
    }
}

