/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.test;

import java.util.Properties;
import net.n2oapp.framework.api.StringUtils;
import org.springframework.core.env.PropertyResolver;

public class SimplePropertyResolver
implements PropertyResolver {
    private Properties properties;

    public SimplePropertyResolver(Properties properties) {
        this.properties = properties;
    }

    public boolean containsProperty(String key) {
        return this.properties.contains(key);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> targetType) {
        Object value = this.properties.get(key);
        return (T)value;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        Object value = this.properties.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        String value = this.properties.getProperty(key);
        if (value == null) {
            throw new IllegalStateException("Property " + key + " not found");
        }
        return value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        Object value = this.properties.get(key);
        if (value == null) {
            throw new IllegalStateException("Property " + key + " not found");
        }
        return (T)value;
    }

    public String resolvePlaceholders(String text) {
        return StringUtils.resolveProperties((String)text, this::getProperty);
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return StringUtils.resolveProperties((String)text, this::getRequiredProperty);
    }

    public Object setProperty(String key, Object value) {
        return this.properties.put(key, value);
    }
}

