/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.admin.properties;

import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.CollectionPageService;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.FilteredCollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.config.admin.properties.PropertiesCriteria;
import net.n2oapp.properties.io.PropertiesInfoCollector;
import net.n2oapp.properties.web.WebApplicationProperties;
import org.springframework.stereotype.Component;

@Component
public class PropertiesService
implements CollectionPageService<PropertiesCriteria, DataSet> {
    private WebApplicationProperties n2oProperties;
    private PropertiesInfoCollector collector;

    public PropertiesService(Properties n2oProperties, PropertiesInfoCollector collector) {
        this.n2oProperties = (WebApplicationProperties)n2oProperties;
        this.collector = collector;
    }

    public CollectionPage<DataSet> getCollectionPage(PropertiesCriteria criteria) {
        if (criteria.getId() != null) {
            String propertyName = criteria.getId();
            WebApplicationProperties.PropertyValue value = this.n2oProperties.getFullPropertyValue(propertyName);
            PropertiesInfoCollector.PropertyInfo info = this.collector.getInfo(this.collector.getGroup(criteria.getId()), criteria.getId());
            DataSet res = new DataSet("id", (Object)propertyName).add("value", (Object)this.checkForEmpty(this.secure(propertyName, value.getValue()))).add("defaultValue", (Object)this.checkForEmpty(this.secure(propertyName, value.getDefaultValue()))).add("buildValue", (Object)this.checkForEmpty(this.secure(propertyName, value.getBuildValue()))).add("envValue", (Object)this.secure(propertyName, value.getEnvValue())).add("hasEnvValue", (Object)(value.getEnvValue() != null ? 1 : 0)).add("servletValue", (Object)this.secure(propertyName, value.getServletValue())).add("hasServletValue", (Object)(value.getServletValue() != null ? 1 : 0)).add("group", (Object)this.checkGroup(info.group)).add("name", (Object)info.name).add("description", (Object)info.description);
            return new FilteredCollectionPage(Collections.singletonList(res), (Criteria)criteria);
        }
        return new FilteredCollectionPage(this.n2oProperties.stringPropertyNames().stream().filter(name -> criteria.getPropertiesName() == null || name.toLowerCase().startsWith(criteria.getPropertiesName().toLowerCase())).sorted(Comparator.naturalOrder()).map(p -> new DataSet("id", p).add("value", (Object)this.checkForEmpty(this.secure((String)p, this.n2oProperties.getProperty(p)))).add("group", (Object)this.collector.getGroup(p))).collect(Collectors.toList()), (Criteria)criteria);
    }

    private String checkForEmpty(String value) {
        if (value == null) {
            return "<value not exists>";
        }
        if (value.isEmpty()) {
            return "<empty>";
        }
        return value;
    }

    private String secure(String propertyName, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (propertyName.contains("password") || propertyName.contains("passphrase")) {
            return "*****";
        }
        return value;
    }

    private String checkGroup(String value) {
        if (value == null || value.equalsIgnoreCase("common")) {
            return null;
        }
        return value;
    }

    public void update(String key, String envValue, String servletValue, Boolean hasEnv, Boolean hasServ) {
        WebApplicationProperties.PropertyValue val = this.n2oProperties.getFullPropertyValue(key);
        if (!(val.getEnvValue() == null || hasEnv != null && hasEnv.booleanValue())) {
            this.n2oProperties.getEnvProperties().removeProperty((Object)key);
        } else if ((val.getEnvValue() != null || hasEnv != null && hasEnv.booleanValue()) && (val.getEnvValue() == null || !val.getEnvValue().equals(envValue))) {
            this.n2oProperties.getEnvProperties().updateProperty((Object)key, (Object)envValue);
        }
        if (!(val.getServletValue() == null || hasServ != null && hasServ.booleanValue())) {
            this.n2oProperties.getServletProperties().removeProperty((Object)key);
        } else if (val.getServletValue() != null || hasServ != null && hasServ.booleanValue() && (val.getServletValue() == null || !val.getServletValue().equals(servletValue))) {
            this.n2oProperties.getServletProperties().updateProperty((Object)key, (Object)servletValue);
        }
    }
}

