/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.admin.properties;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.CollectionPageService;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.FilteredCollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import org.springframework.stereotype.Component;

@Component
public class PropertiesTreeService
implements CollectionPageService<Criteria, DataSet> {
    private Properties n2oProperties;

    public PropertiesTreeService(Properties n2oProperties) {
        this.n2oProperties = n2oProperties;
    }

    public CollectionPage<DataSet> getCollectionPage(Criteria criteria) {
        Set<String> names = this.n2oProperties.stringPropertyNames();
        LinkedHashMap firstLvl = new LinkedHashMap();
        LinkedHashMap secondLvl = new LinkedHashMap();
        names.forEach(name -> {
            String[] s = name.split(Pattern.quote("."));
            if (s.length > 2) {
                String parent = s[0];
                String child = parent + "." + s[1];
                firstLvl.put(parent, new DataSet("id", (Object)parent).add("name", (Object)parent).add("hasChildren", (Object)true).add("canResolved", (Object)true).add("parent", null));
                secondLvl.put(child, new DataSet("id", (Object)child).add("name", (Object)child).add("hasChildren", (Object)false).add("canResolved", (Object)true).add("parent", (Object)parent));
            }
        });
        ArrayList res = new ArrayList(firstLvl.values());
        res.addAll(secondLvl.values());
        return new FilteredCollectionPage(res, criteria);
    }
}

