/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.io;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.framework.api.N2oNamespace;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.ClassedElementIO;
import net.n2oapp.framework.api.metadata.io.ElementIO;
import net.n2oapp.framework.api.metadata.io.ElementIOFactory;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamedElementIO;
import net.n2oapp.framework.api.metadata.io.NamespaceIOFactory;
import net.n2oapp.framework.api.metadata.io.TypedElementIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.persister.TypedElementPersister;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.io.ElementIOFactoryByMap;
import net.n2oapp.framework.config.io.NamespaceIOFactoryByMap;
import net.n2oapp.properties.StaticProperties;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ResourceBundleMessageSource;

public final class IOProcessorImpl
implements IOProcessor {
    private boolean r;
    private NamespaceReaderFactory readerFactory;
    private NamespacePersisterFactory persisterFactory;
    private MessageSourceAccessor messageSourceAccessor = new MessageSourceAccessor((MessageSource)new ResourceBundleMessageSource());

    public IOProcessorImpl(boolean read) {
        this.r = read;
    }

    public IOProcessorImpl(NamespaceReaderFactory readerFactory) {
        this.r = true;
        this.readerFactory = readerFactory;
        if (readerFactory instanceof IOProcessorAware) {
            ((IOProcessorAware)readerFactory).setIOProcessor((IOProcessor)this);
        }
    }

    public IOProcessorImpl(NamespacePersisterFactory persisterFactory) {
        this.r = false;
        this.persisterFactory = persisterFactory;
        if (persisterFactory instanceof IOProcessorAware) {
            ((IOProcessorAware)persisterFactory).setIOProcessor((IOProcessor)this);
        }
    }

    public <T> void read(Element element, T entity, BiConsumer<Element, T> reader) {
        if (this.r) {
            reader.accept(element, (Element)entity);
        }
    }

    public <T> void persist(T entity, Element element, BiConsumer<T, Element> persister) {
        if (!this.r) {
            persister.accept(entity, element);
        }
    }

    public <T> void child(Element element, String sequences, String childName, Supplier<? extends T> getter, Consumer<? super T> setter, TypedElementIO<T> io) {
        if (this.r) {
            Element child;
            if (sequences != null) {
                child = element.getChild(sequences, element.getNamespace());
                if (child == null) {
                    return;
                }
            } else {
                child = element;
            }
            if ((child = child.getChild(childName, element.getNamespace())) != null) {
                setter.accept(this.read((ClassedElementIO<T>)io, child));
            }
        } else {
            T entity = getter.get();
            if (entity != null) {
                Element seqE = element;
                if (sequences != null) {
                    seqE = new Element(sequences, element.getNamespace());
                    element.addContent((Content)seqE);
                }
                Element childE = this.persist((NamedElementIO<T>)io, entity, element.getNamespace());
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T> void child(Element element, String sequences, final String childName, Supplier<T> getter, Consumer<T> setter, final Class<T> elementClass, final ElementIO<T> io) {
        this.child(element, sequences, childName, getter, setter, new TypedElementIO<T>(){

            public Class<T> getElementClass() {
                return elementClass;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }

            public String getElementName() {
                return childName;
            }
        });
    }

    public <T> void child(Element element, String sequences, final String childName, Supplier<? extends T> getter, Consumer<? super T> setter, final Supplier<? extends T> newInstance, final ElementIO<T> io) {
        this.child(element, sequences, childName, getter, setter, new TypedElementIO<T>(){
            private Class<T> elementClass;

            public String getElementName() {
                return childName;
            }

            public Class<T> getElementClass() {
                if (this.elementClass == null) {
                    throw new IllegalStateException("you shall first to call #newInstance(Element)");
                }
                return this.elementClass;
            }

            public T newInstance(Element element) {
                Object entity = newInstance.get();
                if (this.elementClass == null) {
                    this.elementClass = entity.getClass();
                }
                return entity;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> void anyChild(Element element, String sequences, Supplier<? extends T> getter, Consumer<? super T> setter, ElementIOFactory<T, R, P> factory) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                setter.accept(this.read(factory, childE));
            }
        } else {
            Element seqE;
            T entity = getter.get();
            if (entity == null) {
                return;
            }
            if (sequences != null) {
                seqE = new Element(sequences, element.getNamespace());
                element.addContent((Content)seqE);
            } else {
                seqE = element;
            }
            Element childE = this.persist(factory, entity, element.getNamespace());
            if (childE != null) {
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<T>, P extends NamespacePersister<T>> void anyChild(Element element, String sequences, Supplier<T> getter, Consumer<T> setter, NamespaceIOFactory<T, R, P> factory, Namespace defaultNamespace) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                T childT = this.read(factory, childE, seqE.getNamespace(), defaultNamespace);
                if (childT == null) continue;
                setter.accept(childT);
                return;
            }
        } else {
            Element seqE;
            NamespaceUriAware entity = (NamespaceUriAware)getter.get();
            if (entity == null) {
                return;
            }
            if (sequences != null) {
                seqE = new Element(sequences, element.getNamespace());
                element.addContent((Content)seqE);
            } else {
                seqE = element;
            }
            Element childE = this.persist(factory, entity, seqE.getNamespace(), defaultNamespace);
            if (childE != null) {
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T> void children(Element element, String sequences, String childrenName, Supplier<T[]> getter, Consumer<T[]> setter, TypedElementIO<T> io) {
        if (this.r) {
            Element seqE;
            ArrayList<T> result = new ArrayList<T>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                T entity = this.read((ClassedElementIO<T>)io, childE);
                result.add(entity);
            }
            if (result.size() > 0) {
                Object[] res = (Object[])Array.newInstance(io.getElementClass(), result.size());
                res = result.toArray(res);
                setter.accept(res);
            }
        } else {
            Element seqE;
            T[] entity = getter.get();
            if (entity == null) {
                return;
            }
            if (sequences != null) {
                seqE = new Element(sequences, element.getNamespace());
                element.addContent((Content)seqE);
            } else {
                seqE = element;
            }
            for (T child : entity) {
                Element childE = this.persist((NamedElementIO<T>)io, child, seqE.getNamespace());
                this.installNamespace(childE, seqE.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public void childrenToMap(Element element, String sequences, String childrenName, String keyName, String valueName, Supplier<Map<String, Object>> getter, Consumer<Map<String, Object>> setter) {
        if (this.r) {
            Element seqE;
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                String key = this.process(childE.getAttribute(keyName).getValue());
                String value = valueName == null ? childE.getValue() : childE.getAttribute(valueName).getValue();
                Object objValue = DomainProcessor.getInstance().doDomainConversion(null, (Object)value);
                result.put(key, objValue);
            }
            setter.accept(result);
        } else {
            this.persistChildrenMap(element, sequences, childrenName, keyName, valueName, getter);
        }
    }

    public void childrenToStringMap(Element element, String sequences, String childrenName, String keyName, String valueName, Supplier<Map<String, String>> getter, Consumer<Map<String, String>> setter) {
        if (this.r) {
            Element seqE;
            HashMap<String, String> result = new HashMap<String, String>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                String key = this.process(childE.getAttribute(keyName).getValue());
                String value = valueName == null ? childE.getValue() : childE.getAttribute(valueName).getValue();
                result.put(key, value);
            }
            setter.accept(result);
        } else {
            this.persistChildrenMap(element, sequences, childrenName, keyName, valueName, getter);
        }
    }

    public void childrenToStringArray(Element element, String sequences, String childrenName, Supplier<String[]> getter, Consumer<String[]> setter) {
        if (this.r) {
            Element seqE;
            ArrayList<String> result = new ArrayList<String>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren(childrenName, seqE.getNamespace())) {
                Element childE = (Element)child;
                String value = this.process(childE.getValue());
                result.add(value);
            }
            if (!result.isEmpty()) {
                String[] res = new String[result.size()];
                setter.accept(result.toArray(res));
            }
        } else {
            String[] values = getter.get();
            if (values == null) {
                return;
            }
            Element seqE = this.persistSequences(element, sequences);
            for (String k : values) {
                Element childE = new Element(childrenName, element.getNamespace());
                childE.setText(k);
                seqE.addContent((Content)childE);
            }
        }
    }

    private Element persistSequences(Element element, String sequences) {
        Element seqE;
        if (sequences != null) {
            seqE = element.getChild(sequences, element.getNamespace());
            if (seqE == null) {
                seqE = new Element(sequences, element.getNamespace());
                element.addContent((Content)seqE);
            }
        } else {
            seqE = element;
        }
        return seqE;
    }

    private <T> void persistChildrenMap(Element element, String sequences, String childrenName, String keyName, String valueName, Supplier<Map<String, T>> getter) {
        Map<String, T> values = getter.get();
        if (values == null) {
            return;
        }
        Element seqE = this.persistSequences(element, sequences);
        for (String k : values.keySet()) {
            Element childE = new Element(childrenName, element.getNamespace());
            childE.setAttribute(keyName, k);
            if (valueName == null) {
                childE.setText(values.get(k).toString());
            } else if (values.get(k) != null) {
                childE.setAttribute(valueName, values.get(k).toString());
            }
            seqE.addContent((Content)childE);
        }
    }

    public <T> void children(Element element, String sequences, final String childrenName, Supplier<T[]> getter, Consumer<T[]> setter, final Class<T> elementClass, final ElementIO<T> io) {
        this.children(element, sequences, childrenName, getter, setter, new TypedElementIO<T>(){

            public String getElementName() {
                return childrenName;
            }

            public Class<T> getElementClass() {
                return elementClass;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public <T> void children(Element element, String sequences, final String childrenName, Supplier<T[]> getter, Consumer<T[]> setter, final Supplier<T> newInstance, final ElementIO<T> io) {
        this.children(element, sequences, childrenName, getter, setter, new TypedElementIO<T>(){
            private Class<T> elementClass;

            public String getElementName() {
                return childrenName;
            }

            public Class<T> getElementClass() {
                if (this.elementClass == null) {
                    throw new IllegalStateException("you shall first to call #newInstance(Element)");
                }
                return this.elementClass;
            }

            public T newInstance(Element element) {
                Object entity = newInstance.get();
                if (this.elementClass == null) {
                    this.elementClass = entity.getClass();
                }
                return entity;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> void anyChildren(Element element, String sequences, Supplier<T[]> getter, Consumer<T[]> setter, ElementIOFactory<T, R, P> factory) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            ArrayList<T> result = new ArrayList<T>();
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                T childT = this.read(factory, childE);
                if (childT == null) continue;
                result.add(childT);
            }
            Object[] res = (Object[])Array.newInstance(factory.getBaseElementClass(), result.size());
            res = result.toArray(res);
            setter.accept(res);
        } else {
            Element seqE;
            T[] entities = getter.get();
            if (entities == null) {
                return;
            }
            if (sequences != null) {
                seqE = new Element(sequences, element.getNamespace());
                element.addContent((Content)seqE);
            } else {
                seqE = element;
            }
            for (T child : entities) {
                Element childE = this.persist(factory, child, element.getNamespace());
                if (childE == null) continue;
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> void anyChildren(Element element, String sequences, Supplier<T[]> getter, Consumer<T[]> setter, NamespaceIOFactory<T, R, P> factory, Namespace ... defaultNamespace) {
        if (this.r) {
            Element seqE;
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            ArrayList<T> result = new ArrayList<T>();
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                T childT = this.read(factory, childE, seqE.getNamespace(), defaultNamespace);
                if (childT == null) continue;
                result.add(childT);
            }
            if (result.size() > 0) {
                NamespaceUriAware[] res = factory.getBaseElementClass() == null ? (NamespaceUriAware[])Array.newInstance(NamespaceUriAware.class, result.size()) : (NamespaceUriAware[])Array.newInstance(factory.getBaseElementClass(), result.size());
                res = result.toArray(res);
                setter.accept(res);
            }
        } else {
            Element seqE;
            NamespaceUriAware[] entities = (NamespaceUriAware[])getter.get();
            if (entities == null) {
                return;
            }
            if (sequences != null) {
                if (element.getChild(sequences, element.getNamespace()) != null) {
                    seqE = element.getChild(sequences, element.getNamespace());
                } else {
                    seqE = new Element(sequences, element.getNamespace());
                    element.addContent((Content)seqE);
                }
            } else {
                seqE = element;
            }
            for (NamespaceUriAware child : entities) {
                Element childE = this.persist(factory, child, seqE.getNamespace(), defaultNamespace);
                if (childE == null) continue;
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T, E extends Enum<E>> void childrenByEnum(Element element, String sequences, Supplier<T[]> getterList, Consumer<T[]> setterList, Class<E> enumClass, Function<T, E> getterEnum, BiConsumer<T, E> setterEnum, final ClassedElementIO<T> io) {
        if (this.r) {
            Element seqE;
            ArrayList<T> result = new ArrayList<T>();
            if (sequences != null) {
                seqE = element.getChild(sequences, element.getNamespace());
                if (seqE == null) {
                    return;
                }
            } else {
                seqE = element;
            }
            for (Object child : seqE.getChildren()) {
                Element childE = (Element)child;
                E en = IOProcessorImpl.stringToEnum(childE.getName(), enumClass);
                if (en == null) continue;
                T entity = this.read(io, childE);
                setterEnum.accept(entity, en);
                result.add(entity);
            }
            if (result.size() > 0) {
                Object[] res = (Object[])Array.newInstance(io.getElementClass(), result.size());
                res = result.toArray(res);
                setterList.accept(res);
            }
        } else {
            Element seqE;
            T[] entity = getterList.get();
            if (entity == null) {
                return;
            }
            if (sequences != null) {
                seqE = new Element(sequences, element.getNamespace());
                element.addContent((Content)seqE);
            } else {
                seqE = element;
            }
            for (T child : entity) {
                final Enum en = (Enum)getterEnum.apply(child);
                Element childE = null;
                if (en == null) continue;
                childE = this.persist(new NamedElementIO<T>(){

                    public String getElementName() {
                        return en.name();
                    }

                    public void io(Element e, T t, IOProcessor p) {
                        io.io(e, t, p);
                    }
                }, child, seqE.getNamespace());
                this.installNamespace(childE, element.getNamespace());
                seqE.addContent((Content)childE);
            }
        }
    }

    public <T, E extends Enum<E>> void childrenByEnum(Element element, String sequences, Supplier<T[]> getterList, Consumer<T[]> setterList, Function<T, E> getterEnum, BiConsumer<T, E> setterEnum, final Supplier<T> newInstance, Class<E> enumClass, final ElementIO<T> io) {
        this.childrenByEnum(element, sequences, getterList, setterList, enumClass, getterEnum, setterEnum, new ClassedElementIO<T>(){
            private Class<T> elementClass;

            public Class<T> getElementClass() {
                if (this.elementClass == null) {
                    throw new IllegalStateException("you shall first to call #newInstance(Element)");
                }
                return this.elementClass;
            }

            public T newInstance(Element element) {
                Object entity = newInstance.get();
                if (this.elementClass == null) {
                    this.elementClass = entity.getClass();
                }
                return entity;
            }

            public void io(Element e, T t, IOProcessor p) {
                io.io(e, t, p);
            }
        });
    }

    public void attribute(Element element, String name, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(this.process(attribute.getValue()));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setAttribute(new Attribute(name, getter.get()));
        }
    }

    public void text(Element element, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            String text = element.getText();
            if (text != null && !text.isEmpty()) {
                setter.accept(this.process(text));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setText(getter.get());
        }
    }

    public void childrenText(Element element, String childName, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            String text = child.getText();
            if (text != null && !text.isEmpty()) {
                setter.accept(this.process(text));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setText(getter.get());
                element.addContent((Content)childElement);
            } else {
                childElement.setText(getter.get());
            }
        }
    }

    public void childAttribute(Element element, String childName, String name, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(this.process(attribute.getValue()));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setAttribute(new Attribute(name, getter.get()));
                element.addContent((Content)childElement);
            } else {
                childElement.setAttribute(new Attribute(name, getter.get()));
            }
        }
    }

    public void childAttributeBoolean(Element element, String childName, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(Boolean.valueOf(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setAttribute(new Attribute(name, getter.get().toString()));
                element.addContent((Content)childElement);
            } else {
                childElement.setAttribute(new Attribute(name, getter.get().toString()));
            }
        }
    }

    public <T extends Enum<T>> void childAttributeEnum(Element element, String childName, String name, Supplier<T> getter, Consumer<T> setter, Class<T> enumClass) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            Attribute attribute = child.getAttribute(name);
            if (attribute != null) {
                setter.accept(IOProcessorImpl.stringToEnum(this.process(attribute.getValue()), enumClass));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                childElement.setAttribute(new Attribute(name, ((Enum)getter.get()).toString()));
                element.addContent((Content)childElement);
            } else {
                childElement.setAttribute(new Attribute(name, ((Enum)getter.get()).toString()));
            }
        }
    }

    public void otherAttributes(Element element, Namespace namespace, Map<String, String> map) {
        if (this.r) {
            for (Object o : element.getAttributes()) {
                Attribute attribute = (Attribute)o;
                if (!attribute.getNamespace().equals((Object)namespace)) continue;
                map.put(attribute.getName(), attribute.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                element.setAttribute(new Attribute(entry.getKey(), entry.getValue(), namespace));
            }
        }
    }

    public void childAnyAttributes(Element element, String childName, Supplier<Map<N2oNamespace, Map<String, String>>> getter, Consumer<Map<N2oNamespace, Map<String, String>>> setter) {
        if (this.r) {
            Element child = element.getChild(childName, element.getNamespace());
            if (child == null) {
                return;
            }
            this.anyAttributes(child, getter, setter);
        } else {
            if (getter.get() == null) {
                return;
            }
            Element childElement = element.getChild(childName, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(childName, element.getNamespace());
                this.anyAttributes(childElement, getter, setter);
                element.addContent((Content)childElement);
            } else {
                this.anyAttributes(childElement, getter, setter);
            }
        }
    }

    public void anyAttributes(Element element, Supplier<Map<N2oNamespace, Map<String, String>>> getter, Consumer<Map<N2oNamespace, Map<String, String>>> setter) {
        if (this.r) {
            N2oNamespace elementNamespace = new N2oNamespace(element.getNamespace());
            HashMap extensions = new HashMap();
            for (Object o : element.getAttributes()) {
                Attribute attribute = (Attribute)o;
                if (elementNamespace.getUri().equals(attribute.getNamespaceURI()) || attribute.getNamespaceURI().isEmpty()) continue;
                N2oNamespace namespace = new N2oNamespace(attribute.getNamespace());
                extensions.putIfAbsent(namespace, new HashMap());
                ((Map)extensions.get(namespace)).put(attribute.getName(), this.process(attribute.getValue()));
            }
            setter.accept(extensions);
        } else {
            Map<N2oNamespace, Map<String, String>> extensions = getter.get();
            if (extensions == null) {
                return;
            }
            for (Map.Entry<N2oNamespace, Map<String, String>> map : extensions.entrySet()) {
                for (Map.Entry<String, String> entry : map.getValue().entrySet()) {
                    element.setAttribute(new Attribute(entry.getKey(), entry.getValue(), Namespace.getNamespace((String)map.getKey().getPrefix(), (String)map.getKey().getUri())));
                }
            }
        }
    }

    public void attributeBoolean(Element element, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(Boolean.valueOf(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setAttribute(new Attribute(name, getter.get().toString()));
        }
    }

    public void attributeInteger(Element element, String name, Supplier<Integer> getter, Consumer<Integer> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(Integer.valueOf(this.process(attribute.getValue())));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            element.setAttribute(new Attribute(name, getter.get().toString()));
        }
    }

    public void attributeArray(Element element, String name, String separator, Supplier<String[]> getter, Consumer<String[]> setter) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(this.process(attribute.getValue()).split(separator));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            StringBuilder str = new StringBuilder();
            for (String s : getter.get()) {
                str.append(s).append(",");
            }
            element.setAttribute(new Attribute(name, str.toString().substring(0, str.length() - 1)));
        }
    }

    public <T extends Enum<T>> void attributeEnum(Element element, String name, Supplier<T> getter, Consumer<T> setter, Class<T> enumClass) {
        if (this.r) {
            Attribute attribute = element.getAttribute(name);
            if (attribute != null) {
                setter.accept(IOProcessorImpl.stringToEnum(this.process(attribute.getValue()), enumClass));
            }
        } else {
            if (getter.get() == null) {
                return;
            }
            if (IdAware.class.isAssignableFrom(enumClass)) {
                element.setAttribute(new Attribute(name, ((IdAware)getter.get()).getId()));
            } else {
                element.setAttribute(new Attribute(name, ((Enum)getter.get()).name()));
            }
        }
    }

    public void element(Element element, String name, Supplier<String> getter, Consumer<String> setter) {
        if (this.r) {
            Element child = element.getChild(name, element.getNamespace());
            if (child != null && child.getValue() != null && !child.getValue().isEmpty()) {
                setter.accept(this.process(child.getValue()));
            }
        } else {
            if (getter.get() == null || getter.get().isEmpty()) {
                return;
            }
            Element childElement = element.getChild(name, element.getNamespace());
            if (childElement == null) {
                childElement = new Element(name, element.getNamespace());
                childElement.setText(getter.get());
                element.addContent((Content)childElement);
            } else {
                childElement.setText(getter.get());
            }
        }
    }

    public void hasElement(Element element, String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
        if (this.r) {
            Element child = element.getChild(name, element.getNamespace());
            setter.accept(child != null);
        } else {
            if (getter.get() == null || !getter.get().booleanValue()) {
                return;
            }
            Element childElement = new Element(name, element.getNamespace());
            element.addContent((Content)childElement);
        }
    }

    public <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> ElementIOFactory<T, R, P> oneOf(Class<T> baseElementClass) {
        return new ElementIOFactoryByMap(baseElementClass);
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> NamespaceIOFactory<T, R, P> anyOf(Class<T> baseElementClass) {
        return new NamespaceIOFactoryByMap(baseElementClass, this.readerFactory, this.persisterFactory);
    }

    public <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> NamespaceIOFactory<T, R, P> anyOf() {
        return new NamespaceIOFactoryByMap(null, this.readerFactory, this.persisterFactory);
    }

    private void installNamespace(Element element, Namespace namespace) {
        if (element.getNamespace().equals((Object)Namespace.NO_NAMESPACE)) {
            element.setNamespace(namespace);
            for (Object o : element.getChildren()) {
                Element child = (Element)o;
                this.installNamespace(child, namespace);
            }
        }
    }

    private void installNamespace(Element element, Namespace namespace, Namespace oldNamespace) {
        if (element.getNamespace().equals((Object)oldNamespace)) {
            element.setNamespace(namespace);
            for (Object o : element.getChildren()) {
                Element child = (Element)o;
                this.installNamespace(child, namespace, oldNamespace);
            }
        }
    }

    private String process(String text) {
        if (text == null) {
            return null;
        }
        String resolve = StringUtils.resolveProperties((String)text, StaticProperties::get);
        return StringUtils.resolveProperties((String)resolve, arg_0 -> ((MessageSourceAccessor)this.messageSourceAccessor).getMessage(arg_0));
    }

    private static <T extends Enum<T>> T stringToEnum(String value, Class<T> enumClass) {
        if (value == null) {
            return null;
        }
        Enum res = null;
        boolean idAware = IdAware.class.isAssignableFrom(enumClass);
        if (idAware) {
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                IdAware idEnum = (IdAware)enumValue;
                if (!idEnum.getId().equalsIgnoreCase(value)) continue;
                res = enumValue;
            }
        } else {
            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                if (!enumValue.name().equalsIgnoreCase(value)) continue;
                res = enumValue;
            }
        }
        return (T)res;
    }

    private <T> Element persist(NamedElementIO<T> io, T entity, Namespace namespace) {
        Element element = new Element(io.getElementName(), namespace);
        io.io(element, entity, (IOProcessor)this);
        return element;
    }

    private <T> T read(ClassedElementIO<T> io, Element element) {
        Object entity = io.newInstance(element);
        io.io(element, entity, (IOProcessor)this);
        return (T)entity;
    }

    private <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> T read(ElementIOFactory<T, R, P> factory, Element element) {
        TypedElementReader reader = factory.produce(element);
        if (reader != null) {
            if (reader instanceof IOProcessorAware) {
                ((IOProcessorAware)reader).setIOProcessor((IOProcessor)this);
            }
            return (T)reader.read(element);
        }
        return null;
    }

    private <T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>> Element persist(ElementIOFactory<T, R, P> factory, T entity, Namespace namespace) {
        TypedElementPersister persister = factory.produce(entity);
        if (persister != null) {
            if (persister instanceof IOProcessorAware) {
                ((IOProcessorAware)persister).setIOProcessor((IOProcessor)this);
            }
            return persister.persist(entity, namespace);
        }
        return null;
    }

    private <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> T read(NamespaceIOFactory<T, R, P> factory, Element element, Namespace parentNamespace, Namespace ... defaultNamespace) {
        NamespaceReader reader = null;
        boolean flag = false;
        if (defaultNamespace != null && defaultNamespace.length > 0 && defaultNamespace[0] != null && parentNamespace.getURI().equals(element.getNamespaceURI())) {
            for (Namespace namespace : defaultNamespace) {
                try {
                    reader = factory.produce(element, parentNamespace, namespace);
                    if (reader == null) continue;
                    flag = true;
                    break;
                }
                catch (EngineNotFoundException e) {
                    // empty catch block
                }
            }
            if (!flag) {
                throw new EngineNotFoundException((Object)element.getName());
            }
        } else {
            reader = factory.produce(element, parentNamespace, null);
        }
        if (reader != null) {
            if (reader instanceof IOProcessorAware) {
                ((IOProcessorAware)reader).setIOProcessor((IOProcessor)this);
            }
            NamespaceUriAware model = (NamespaceUriAware)reader.read(element);
            model.setNamespaceUri(element.getNamespaceURI());
            return (T)model;
        }
        return null;
    }

    private <T extends NamespaceUriAware, R extends NamespaceReader<? extends T>, P extends NamespacePersister<? super T>> Element persist(NamespaceIOFactory<T, R, P> factory, T entity, Namespace parentNamespace, Namespace ... defaultNamespace) {
        NamespacePersister persister = null;
        boolean flag = false;
        if (defaultNamespace != null && defaultNamespace.length > 0 && defaultNamespace[0] != null) {
            for (Namespace namespace : defaultNamespace) {
                try {
                    persister = entity.getNamespaceUri().equals(parentNamespace.getURI()) ? factory.produce(namespace, entity.getClass()) : factory.produce(entity);
                    if (persister == null) continue;
                    flag = true;
                    break;
                }
                catch (EngineNotFoundException e) {
                    // empty catch block
                }
            }
            if (!flag) {
                throw new EngineNotFoundException((Object)defaultNamespace[0].getURI());
            }
        } else {
            persister = factory.produce(entity);
        }
        if (persister != null) {
            if (persister instanceof IOProcessorAware) {
                ((IOProcessorAware)persister).setIOProcessor((IOProcessor)this);
            }
            Element element = persister.persist(entity, parentNamespace);
            this.installNamespace(element, entity.getNamespace(), element.getNamespace());
            return element;
        }
        return null;
    }

    public void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }
}

