/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Map;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.event.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.action.ReduxActionOptions;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.AsyncMetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDataProvider;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ActionContext;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class InvokeActionCompiler
extends AbstractActionCompiler<InvokeAction, N2oInvokeAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oInvokeAction.class;
    }

    public InvokeAction compile(N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p) {
        WidgetScope widgetScope;
        ModelAware modelAware;
        InvokeAction invokeAction = new InvokeAction();
        this.compileAction(invokeAction, source, p);
        invokeAction.setOperationId(source.getOperationId());
        ((ReduxActionOptions)invokeAction.getOptions()).setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.type"), String.class));
        String targetWidgetId = this.initTargetWidget((N2oAction)source, context, p);
        ReduxModel targetWidgetModel = ReduxModel.RESOLVE;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (modelAware = componentScope.unwrap(ModelAware.class)) != null && modelAware.getModel() != null) {
            targetWidgetModel = modelAware.getModel();
        }
        String currentWidgetId = (widgetScope = (WidgetScope)p.getScope(WidgetScope.class)) == null ? targetWidgetId : widgetScope.getClientWidgetId();
        String modalLink = Redux.createBindLink(targetWidgetId, targetWidgetModel).getBindLink();
        ((InvokeActionPayload)((ReduxActionOptions)invokeAction.getOptions()).getPayload()).setModelLink(modalLink);
        ((AsyncMetaSaga)((ReduxActionOptions)invokeAction.getOptions()).getMeta()).setSuccess(this.initSuccessMeta(invokeAction, source, context, p, targetWidgetId, currentWidgetId));
        ((AsyncMetaSaga)((ReduxActionOptions)invokeAction.getOptions()).getMeta()).setFail(this.initFailMeta(currentWidgetId));
        ((InvokeActionPayload)((ReduxActionOptions)invokeAction.getOptions()).getPayload()).setWidgetId(targetWidgetId);
        if (widgetScope == null) {
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            ((InvokeActionPayload)((ReduxActionOptions)invokeAction.getOptions()).getPayload()).setPageId(pageScope.getPageId());
        }
        this.initDataProvider(invokeAction, source, context, p, targetWidgetModel);
        return invokeAction;
    }

    private MetaSaga initFailMeta(String currentWidgetId) {
        MetaSaga metaSaga = new MetaSaga();
        metaSaga.setMessageWidgetId(currentWidgetId);
        return metaSaga;
    }

    private MetaSaga initSuccessMeta(InvokeAction invokeAction, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p, String targetWidgetId, String currentWidgetId) {
        MetaSaga meta = new MetaSaga();
        boolean closeOnSuccess = (Boolean)p.cast((Object)source.getCloseOnSuccess(), (Object)false, new Object[0]);
        boolean refresh = (Boolean)p.cast((Object)source.getRefreshOnSuccess(), (Object)true, new Object[0]);
        boolean redirect = source.getRedirectUrl() != null;
        String messageWidgetId = currentWidgetId;
        if (closeOnSuccess && context instanceof PageContext) {
            messageWidgetId = ((PageContext)context).getParentWidgetId();
        }
        meta.setMessageWidgetId(messageWidgetId);
        if (closeOnSuccess) {
            if (context instanceof ModalPageContext) {
                meta.setCloseLastModal(Boolean.valueOf(true));
            } else if (!redirect) {
                String backRoute = context instanceof PageContext ? ((PageContext)context).getParentRoute() : "/";
                meta.setRedirect(new RedirectSaga());
                meta.getRedirect().setPath(backRoute);
                meta.getRedirect().setTarget(Target.application);
            }
        }
        if (refresh) {
            meta.setRefresh(new RefreshSaga());
            meta.getRefresh().setType(RefreshSaga.Type.widget);
            String refreshWidgetId = messageWidgetId;
            if (source.getRefreshWidgetId() != null) {
                PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                refreshWidgetId = pageScope == null ? source.getRefreshWidgetId() : pageScope.getGlobalWidgetId(source.getRefreshWidgetId());
            } else if (closeOnSuccess && context instanceof PageContext && ((PageContext)context).getRefreshClientWidgetId() != null) {
                refreshWidgetId = ((PageContext)context).getRefreshClientWidgetId();
            }
            meta.getRefresh().getOptions().setWidgetId(refreshWidgetId);
        }
        if (redirect) {
            if (context instanceof ModalPageContext) {
                meta.setCloseLastModal(Boolean.valueOf(true));
            }
            meta.setRedirect(new RedirectSaga());
            ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
            meta.getRedirect().setPath(RouteUtil.absolute(source.getRedirectUrl(), routeScope != null ? routeScope.getUrl() : null));
            meta.getRedirect().setTarget(source.getRedirectTarget());
            meta.getRedirect().setServer(true);
        }
        return meta;
    }

    private void initDataProvider(InvokeAction invokeAction, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p, ReduxModel model) {
        InvokeActionPayload payload = (InvokeActionPayload)((ReduxActionOptions)invokeAction.getOptions()).getPayload();
        AsyncMetaSaga metaSaga = (AsyncMetaSaga)((ReduxActionOptions)invokeAction.getOptions()).getMeta();
        WidgetDataProvider dataProvider = new WidgetDataProvider();
        StrictMap pathMapping = new StrictMap();
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        String path = (String)p.cast((Object)(routeScope != null ? routeScope.getUrl() : null), (Object)context.getRoute((BindProcessor)((N2oCompileProcessor)p)), new Object[]{""});
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null && model.equals((Object)ReduxModel.RESOLVE)) {
            String widgetSelectedId = widgetScope.getClientWidgetId() + "_id";
            path = path + RouteUtil.normalize(Placeholders.colon((String)widgetSelectedId));
            pathMapping.put(widgetSelectedId, Redux.createBindLink(widgetScope.getClientWidgetId(), ReduxModel.RESOLVE, "id"));
        }
        path = path + RouteUtil.normalize((String)p.cast((Object)source.getRoute(), (Object)source.getId(), new Object[0]));
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + path);
        if (routeScope != null && routeScope.getPathMapping() != null) {
            for (String pathParam : routeScope.getPathMapping().keySet()) {
                BindLink bindLink = (BindLink)routeScope.getPathMapping().get(pathParam);
                pathMapping.put(pathParam, bindLink);
            }
        }
        dataProvider.setPathMapping((Map)pathMapping);
        dataProvider.setMethod(RequestMethod.POST);
        payload.setDataProvider(dataProvider);
        CompiledObject compiledObject = (CompiledObject)p.getScope(CompiledObject.class);
        if (compiledObject == null) {
            throw new N2oException("For compilation action [{0}] is necessary object!").addData(new Object[]{source.getId()});
        }
        invokeAction.setObjectId(compiledObject.getId());
        ValidationList validationList = (ValidationList)p.getScope(ValidationList.class);
        ActionContext actionContext = new ActionContext(compiledObject.getId(), source.getOperationId(), path);
        actionContext.setValidations(validationList == null ? null : validationList.get(metaSaga.getFail().getMessageWidgetId(), model));
        actionContext.setRedirect(this.initServerRedirect(metaSaga));
        actionContext.setFailAlertWidgetId(metaSaga.getFail().getMessageWidgetId());
        actionContext.setMessagesForm(metaSaga.getFail().getMessageWidgetId());
        actionContext.setSuccessAlertWidgetId(metaSaga.getSuccess().getMessageWidgetId());
        actionContext.setMessageOnSuccess((Boolean)p.cast((Object)source.getMessageOnSuccess(), (Object)true, new Object[0]));
        actionContext.setMessageOnFail((Boolean)p.cast((Object)source.getMessageOnFail(), (Object)true, new Object[0]));
        p.addRoute((CompileContext)actionContext);
    }

    private RedirectSaga initServerRedirect(AsyncMetaSaga meta) {
        if (meta != null && meta.getSuccess() != null && meta.getSuccess().getRedirect() != null && meta.getSuccess().getRedirect().isServer()) {
            return meta.getSuccess().getRedirect();
        }
        return null;
    }
}

