/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.ControlDependency;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.ListControl;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDataProvider;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.util.CompileUtil;

public abstract class ListControlCompiler<T extends ListControl, S extends N2oListField>
extends StandardFieldCompiler<T, S> {
    protected StandardField<T> compileListControl(T listControl, S source, CompileContext<?, ?> context, CompileProcessor p) {
        listControl.setFormat(p.resolveJS(source.getFormat()));
        listControl.setLabelFieldId((String)p.cast((Object)p.resolveJS(source.getLabelFieldId()), (Object)"name", new Object[0]));
        listControl.setValueFieldId((String)p.cast((Object)p.resolveJS(source.getValueFieldId()), (Object)"id", new Object[0]));
        listControl.setIconFieldId(p.resolveJS(source.getIconFieldId()));
        listControl.setBadgeFieldId(p.resolveJS(source.getBadgeFieldId()));
        listControl.setBadgeColorFieldId(p.resolveJS(source.getBadgeColorFieldId()));
        listControl.setImageFieldId(p.resolveJS(source.getImageFieldId()));
        listControl.setGroupFieldId(p.resolveJS(source.getGroupFieldId()));
        listControl.setHasSearch(source.getSearch());
        if (source.getQueryId() != null) {
            this.initDataProvider(listControl, (N2oListField)source, p);
        } else if (source.getOptions() != null) {
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            for (Map option : source.getOptions()) {
                DataSet dataItem = new DataSet();
                option.forEach((f, v) -> dataItem.put(f, p.resolve(v)));
                list.add(dataItem);
            }
            listControl.setData(list);
        }
        listControl.setValueFieldId((String)p.cast((Object)p.resolveJS(listControl.getValueFieldId()), (Object)"id", new Object[0]));
        listControl.setLabelFieldId((String)p.cast((Object)p.resolveJS(listControl.getLabelFieldId()), (Object)"name", new Object[0]));
        listControl.setCaching(source.getCache());
        this.initSubModel(source, (SubModelsScope)p.getScope(SubModelsScope.class));
        return this.compileStandardField(listControl, source, context, p);
    }

    @Override
    protected Object compileDefValues(S source, CompileProcessor p) {
        if (source.getDefValue() == null) {
            return null;
        }
        DefaultValues values = new DefaultValues();
        values.setValues(new HashMap());
        source.getDefValue().forEach((f, v) -> values.getValues().put(f, p.resolve(v)));
        return source.isSingle() ? values : Collections.singletonList(values);
    }

    protected StandardField<T> compileFetchDependencies(StandardField<T> field, S source, CompileProcessor p) {
        if (source.getPreFilters() != null && field.getDependencies().stream().noneMatch(d -> d.getType() == ValidationType.fetch)) {
            HashSet<String> setOn = new HashSet<String>();
            for (N2oPreFilter filter : source.getPreFilters()) {
                if (!StringUtils.hasLink((String)filter.getValue())) continue;
                String resolveOnJS = p.resolveJS(filter.getValue());
                resolveOnJS = resolveOnJS.substring(1, resolveOnJS.length() - 1);
                setOn.add(resolveOnJS);
            }
            if (!setOn.isEmpty()) {
                ControlDependency fetchCD = new ControlDependency();
                fetchCD.setType(ValidationType.fetch);
                fetchCD.setOn(new ArrayList(setOn));
                field.addDependency(fetchCD);
            }
        }
        return field;
    }

    private void initSubModel(S source, SubModelsScope scope) {
        if (scope == null) {
            return;
        }
        if (source.getQueryId() != null || source.getOptions() != null) {
            scope.add(this.createSubModel((N2oListField)source));
        }
    }

    private SubModelQuery createSubModel(N2oListField item) {
        return new SubModelQuery(item.getId(), item.getQueryId(), item.getValueFieldId() != null ? item.getValueFieldId() : "id", item.getLabelFieldId() != null ? item.getLabelFieldId() : "name", Boolean.valueOf(!item.isSingle()), item.getOptions() == null ? null : Arrays.asList(item.getOptions()));
    }

    private void initDataProvider(T listControl, N2oListField source, CompileProcessor p) {
        WidgetDataProvider dataProvider = new WidgetDataProvider();
        QueryContext queryContext = new QueryContext(source.getQueryId());
        ModelsScope modelsScope = (ModelsScope)p.getScope(ModelsScope.class);
        queryContext.setFailAlertWidgetId(modelsScope != null ? modelsScope.getWidgetId() : null);
        CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)queryContext);
        String route = query.getRoute();
        p.addRoute((CompileContext)new QueryContext(source.getQueryId(), route));
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + route);
        if (listControl.getHasSearch() != null && listControl.getHasSearch().booleanValue()) {
            String searchFilterId = (String)p.cast((Object)source.getSearchFieldId(), (Object)source.getLabelFieldId(), new Object[0]);
            if (query.getFilterIdToParamMap().containsKey(searchFilterId)) {
                dataProvider.setQuickSearchParam((String)query.getFilterIdToParamMap().get(searchFilterId));
            } else if (searchFilterId != null && listControl.getHasSearch().booleanValue()) {
                throw new N2oException("For search field id [{0}] is necessary this filter-id in query [{1}]").addData(new Object[]{searchFilterId, query.getId()});
            }
        }
        N2oPreFilter[] preFilters = source.getPreFilters();
        StrictMap queryMap = new StrictMap();
        if (preFilters != null) {
            for (N2oPreFilter preFilter : preFilters) {
                N2oQuery.Filter filter = query.getFilterByPreFilter(preFilter);
                String filterParam = (String)query.getFilterIdToParamMap().get(filter.getFilterField());
                Object prefilterValue = this.getPrefilterValue(preFilter);
                if (StringUtils.isJs((Object)prefilterValue)) {
                    String widgetId = modelsScope.getWidgetId();
                    if (preFilter.getRefWidgetId() != null) {
                        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                        widgetId = preFilter.getRefPageId() == null ? pageScope.getGlobalWidgetId(preFilter.getRefWidgetId()) : CompileUtil.generateWidgetId(preFilter.getRefPageId(), preFilter.getRefWidgetId());
                    }
                    ModelLink link = new ModelLink((ReduxModel)p.cast((Object)preFilter.getRefModel(), (Object)modelsScope.getModel(), new Object[0]), widgetId);
                    link.setValue(prefilterValue);
                    queryMap.put(filterParam, link);
                    continue;
                }
                queryMap.put(filterParam, new ModelLink(prefilterValue));
            }
        }
        dataProvider.setQueryMapping((Map)queryMap);
        listControl.setDataProvider(dataProvider);
    }

    private Object getPrefilterValue(N2oPreFilter n2oPreFilter) {
        if (n2oPreFilter.getValues() == null) {
            return ScriptProcessor.resolveExpression((String)n2oPreFilter.getValue());
        }
        return ScriptProcessor.resolveArrayExpression((String[])n2oPreFilter.getValues());
    }
}

