/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.N2oStandardField;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.Control;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetScope;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetVisibilityScope;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.ControlFilterUtil;

public abstract class StandardFieldCompiler<D extends Control, S extends N2oStandardField>
extends FieldCompiler<StandardField<D>, S> {
    protected StandardField<D> compileStandardField(D control, S source, CompileContext<?, ?> context, CompileProcessor p) {
        StandardField field = new StandardField();
        this.compileField(field, source, context, p);
        field.setClassName(null);
        this.initValidations(source, (Field)field, context, p);
        this.compileFilters(source, p);
        this.compileCopied(source, p);
        this.compileControl(control, source, p, field);
        field.setControl(control);
        return field;
    }

    protected void compileControl(D control, S source, CompileProcessor p, StandardField<D> field) {
        control.setSrc((String)p.cast((Object)control.getSrc(), (Object)source.getControlSrc(), new Object[]{p.resolve(Placeholders.property((String)this.getControlSrcProperty()), String.class)}));
        if (control.getSrc() == null) {
            throw new N2oException("control src is required");
        }
        control.setId(source.getId());
        control.setClassName(p.resolveJS(source.getCssClass()));
        this.compileDefaultValues(control, source, p);
    }

    @Override
    protected String initLabel(S source, CompileProcessor p) {
        if (source.getNoLabel() == null || !source.getNoLabel().booleanValue()) {
            String label = super.initLabel(source, p);
            FieldSetScope scope = (FieldSetScope)p.getScope(FieldSetScope.class);
            if (label == null && scope != null) {
                label = (String)scope.get(source.getId());
            }
            if (label == null) {
                label = source.getId();
            }
            return label;
        }
        return null;
    }

    protected abstract String getControlSrcProperty();

    protected Object compileDefValues(S source, CompileProcessor p) {
        return null;
    }

    protected SubModelQuery findSubModelQuery(String fieldId, CompileProcessor p) {
        if (fieldId == null) {
            return null;
        }
        SubModelsScope subModelsScope = (SubModelsScope)p.getScope(SubModelsScope.class);
        if (subModelsScope != null) {
            return subModelsScope.stream().filter(subModelQuery -> fieldId.equals(subModelQuery.getSubModel())).findAny().orElse(null);
        }
        return null;
    }

    private void compileDefaultValues(D control, S source, CompileProcessor p) {
        Object defValue;
        UploadScope uploadScope = (UploadScope)p.getScope(UploadScope.class);
        if (uploadScope != null && !UploadType.defaults.equals((Object)uploadScope.getUpload())) {
            return;
        }
        ModelsScope defaultValues = (ModelsScope)p.getScope(ModelsScope.class);
        if (defaultValues != null && defaultValues.hasModels() && (defValue = source.getDefaultValue() != null ? p.resolve(source.getDefaultValue(), source.getDomain()) : this.compileDefValues(source, p)) != null) {
            if (defValue instanceof String) {
                defValue = ScriptProcessor.resolveExpression((String)((String)defValue));
            }
            if (StringUtils.isJs((Object)defValue)) {
                ModelLink defaultValue = new ModelLink(defaultValues.getModel(), defaultValues.getWidgetId());
                defaultValue.setValue(defValue);
                defaultValues.add(control.getId(), defaultValue);
            } else {
                SubModelQuery subModelQuery = this.findSubModelQuery(control.getId(), p);
                ModelLink modelLink = new ModelLink(defaultValues.getModel(), defaultValues.getWidgetId(), control.getId());
                if (defValue instanceof DefaultValues) {
                    DefaultValues defaultValue = (DefaultValues)defValue;
                    Map values = defaultValue.getValues();
                    if (defaultValue.getValues() != null) {
                        for (String param : values.keySet()) {
                            Object value;
                            if (!(values.get(param) instanceof String) || (value = ScriptProcessor.resolveExpression((String)((String)values.get(param)))) == null) continue;
                            values.put(param, value);
                        }
                    }
                }
                modelLink.setValue(defValue);
                modelLink.setSubModelQuery(subModelQuery);
                defaultValues.add(control.getId(), modelLink);
            }
        }
    }

    private void compileFilters(S source, CompileProcessor p) {
        FiltersScope filtersScope = (FiltersScope)p.getScope(FiltersScope.class);
        if (filtersScope != null) {
            CompiledQuery query = (CompiledQuery)p.getScope(CompiledQuery.class);
            if (query == null) {
                return;
            }
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            List<N2oQuery.Filter> filters = ControlFilterUtil.getFilters(source.getId(), query);
            filters.forEach(f -> {
                Filter filter = new Filter();
                filter.setFilterId(f.getFilterField());
                filter.setParam(widgetScope.getClientWidgetId() + "_" + f.getParam());
                filter.setReloadable(Boolean.valueOf(true));
                SubModelQuery subModelQuery = this.findSubModelQuery(source.getId(), p);
                ModelLink link = new ModelLink(ReduxModel.FILTER, widgetScope.getClientWidgetId());
                link.setSubModelQuery(subModelQuery);
                link.setValue((Object)p.resolveJS(Placeholders.ref((String)f.getFilterField())));
                filter.setLink(link);
                filtersScope.getFilters().add(filter);
            });
        }
    }

    private void compileCopied(S source, CompileProcessor p) {
        CopiedFieldScope scope;
        if (Boolean.TRUE.equals(source.getCopied()) && (scope = (CopiedFieldScope)p.getScope(CopiedFieldScope.class)) != null) {
            scope.addCopiedFields(source.getId());
        }
    }

    private void initValidations(S source, Field field, CompileContext<?, ?> context, CompileProcessor p) {
        MandatoryValidation mandatory;
        String REQUIRED_MESSAGE;
        ArrayList<Validation> serverValidations = new ArrayList<Validation>();
        ArrayList<Validation> clientValidations = new ArrayList<Validation>();
        Set visibilityConditions = (Set)p.getScope(FieldSetVisibilityScope.class);
        MomentScope momentScope = (MomentScope)p.getScope(MomentScope.class);
        String string = REQUIRED_MESSAGE = momentScope != null && N2oValidation.ServerMoment.beforeQuery.equals((Object)momentScope.getMoment()) ? "n2o.required.filter" : "n2o.required.field";
        if (source.getRequired() != null && source.getRequired().booleanValue()) {
            mandatory = new MandatoryValidation(source.getId(), p.getMessage(REQUIRED_MESSAGE, new Object[0]), field.getId());
            if (momentScope != null) {
                mandatory.setMoment(momentScope.getMoment());
            }
            mandatory.addEnablingConditions(this.collectConditions(source, N2oField.VisibilityDependency.class));
            mandatory.addEnablingConditions((Collection)visibilityConditions);
            serverValidations.add((Validation)mandatory);
            clientValidations.add((Validation)mandatory);
            field.setRequired(Boolean.valueOf(true));
        } else if (source.containsDependency(N2oField.RequiringDependency.class)) {
            mandatory = new MandatoryValidation(source.getId(), p.getMessage(REQUIRED_MESSAGE, new Object[0]), field.getId());
            if (momentScope != null) {
                mandatory.setMoment(momentScope.getMoment());
            }
            mandatory.addEnablingConditions((Collection)visibilityConditions);
            mandatory.addEnablingConditions(this.collectConditions(source, N2oField.RequiringDependency.class, N2oField.VisibilityDependency.class));
            mandatory.setEnablingExpression(ScriptProcessor.and(this.collectConditions(source, N2oField.RequiringDependency.class)));
            if (mandatory.getEnablingConditions() != null && !mandatory.getEnablingConditions().isEmpty()) {
                serverValidations.add((Validation)mandatory);
                clientValidations.add((Validation)mandatory);
            }
        }
        CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
        this.initInlineValidations(field, source, serverValidations, clientValidations, object, context, visibilityConditions, p);
        field.setServerValidations(serverValidations.isEmpty() ? null : serverValidations);
        field.setClientValidations(clientValidations.isEmpty() ? null : clientValidations);
    }

    private List<String> collectConditions(S source, Class ... types) {
        ArrayList<String> result = new ArrayList<String>();
        if (source.getDependencies() != null && types != null) {
            for (N2oField.Dependency dependency : source.getDependencies()) {
                for (Class clazz : types) {
                    if (!dependency.getClass().equals(clazz)) continue;
                    result.add(dependency.getValue());
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    private void initInlineValidations(Field field, S source, List<Validation> serverValidations, List<Validation> clientValidations, CompiledObject object, CompileContext<?, ?> context, Set<String> visibilityConditions, CompileProcessor p) {
        N2oField.Validations validations = source.getValidations();
        if (validations == null) {
            return;
        }
        if (validations.getWhiteList() != null) {
            for (String validation : validations.getWhiteList()) {
                this.initWhiteListValidation(field.getId(), validation, source, serverValidations, clientValidations, object, visibilityConditions);
            }
        }
        if (validations.getInlineValidations() != null) {
            ArrayList<String> enablingConditions = new ArrayList<String>();
            if (source.getDependencies() != null) {
                for (N2oField.Dependency dependency : source.getDependencies()) {
                    if (!dependency.getClass().equals(N2oField.VisibilityDependency.class)) continue;
                    enablingConditions.add(dependency.getValue());
                }
            }
            if (object.getValidations() == null) {
                object.setValidations(new ArrayList());
            }
            for (N2oValidation v : validations.getInlineValidations()) {
                v.setFieldId(field.getId());
                Validation compiledValidation = (Validation)p.compile((Object)v, context, new Object[0]);
                MomentScope momentScope = (MomentScope)p.getScope(MomentScope.class);
                if (momentScope != null) {
                    compiledValidation.setMoment(momentScope.getMoment());
                }
                if (field.getVisible() != null && !field.getVisible().booleanValue()) continue;
                if (!enablingConditions.isEmpty()) {
                    compiledValidation.addEnablingConditions(enablingConditions);
                }
                compiledValidation.addEnablingConditions(visibilityConditions);
                object.addValidation(compiledValidation);
                serverValidations.add(compiledValidation);
                if (compiledValidation.getSide() != null && !compiledValidation.getSide().contains("client")) continue;
                clientValidations.add(compiledValidation);
            }
        }
    }

    private void initWhiteListValidation(String fieldId, String refId, S source, List<Validation> serverValidations, List<Validation> clientValidations, CompiledObject object, Set<String> visibilityConditions) {
        if (object == null) {
            throw new N2oException("Field {0} have validation reference, but haven't object!").addData(new Object[]{fieldId});
        }
        Validation objectValidation = null;
        if (object.getValidationsMap() != null && object.getValidationsMap().containsKey(refId)) {
            objectValidation = (Validation)object.getValidationsMap().get(refId);
        } else if (object.getOperations() != null && !object.getOperations().isEmpty()) {
            for (CompiledObject.Operation operation : object.getOperations().values()) {
                Optional<Validation> result = operation.getValidationList().stream().filter(v -> v.getId().equals(refId)).findFirst();
                if (!result.isPresent()) continue;
                objectValidation = result.get();
                break;
            }
        }
        if (objectValidation == null) {
            throw new N2oException("Field {0} contains validation reference for nonexistent validation!").addData(new Object[]{fieldId});
        }
        ConstraintValidation validation = null;
        if (objectValidation instanceof ConstraintValidation) {
            validation = new ConstraintValidation((ConstraintValidation)objectValidation);
        } else if (objectValidation instanceof ConditionValidation) {
            validation = new ConditionValidation((ConditionValidation)objectValidation);
        } else if (objectValidation instanceof MandatoryValidation) {
            validation = new MandatoryValidation((MandatoryValidation)objectValidation);
        }
        if (validation == null) {
            return;
        }
        ArrayList<String> enablingConditions = new ArrayList<String>();
        if (source.getDependencies() != null) {
            for (N2oField.Dependency dependency : source.getDependencies()) {
                if (!(dependency instanceof N2oField.VisibilityDependency)) continue;
                enablingConditions.add(dependency.getValue());
            }
        }
        validation.setFieldId(fieldId);
        validation.addEnablingConditions(enablingConditions);
        validation.addEnablingConditions(visibilityConditions);
        if (validation.getSide() == null || validation.getSide().equals("client,server")) {
            serverValidations.add((Validation)validation);
            clientValidations.add((Validation)validation);
        } else if (validation.getSide().equals("client")) {
            clientValidations.add((Validation)validation);
        } else if (validation.getSide().equals("server")) {
            serverValidations.add((Validation)validation);
        }
    }
}

