/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.fieldset;

import java.util.ArrayList;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetColumn;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import org.springframework.stereotype.Component;

@Component
public class FieldSetColumnCompiler
implements BaseSourceCompiler<FieldSet.Column, N2oFieldsetColumn, CompileContext<?, ?>> {
    public FieldSet.Column compile(N2oFieldsetColumn source, CompileContext<?, ?> context, CompileProcessor p) {
        FieldSet.Column column = new FieldSet.Column();
        column.setClassName(source.getCssClass());
        column.setSize(source.getSize());
        if (source.getItems() != null && source.getItems().length > 0) {
            if (source.getItems()[0] instanceof N2oField) {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (NamespaceUriAware item : source.getItems()) {
                    fields.add((Field)p.compile((Object)item, context, new Object[0]));
                }
                if (fields.size() == 1) {
                    column.setSize(column.getSize());
                }
                column.setFields(fields);
            } else {
                ArrayList<FieldSet> fieldSets = new ArrayList<FieldSet>();
                for (NamespaceUriAware item : source.getItems()) {
                    fieldSets.add((FieldSet)p.compile((Object)item, context, new Object[0]));
                }
                column.setFieldsets(fieldSets);
            }
        }
        return column;
    }

    public Class<? extends Source> getSourceClass() {
        return N2oFieldsetColumn.class;
    }
}

