/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oSimplePage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oCustomRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Layout;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.Page;
import net.n2oapp.framework.api.metadata.meta.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.region.CustomRegion;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class SimplePageCompiler
extends BasePageCompiler<N2oSimplePage> {
    private static final String MAIN_WIDGET_ID = "main";

    public Page compile(N2oSimplePage source, PageContext context, CompileProcessor p) {
        Page page = new Page();
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        page.setId((String)p.cast((Object)context.getClientPageId(), (Object)RouteUtil.convertPathToId(pageRoute), new Object[0]));
        PageScope pageScope = new PageScope();
        pageScope.setPageId(page.getId());
        String pageName = (String)p.cast((Object)context.getPageName(), (Object)source.getName(), new Object[]{source.getWidget().getName()});
        page.setPageProperty(this.initPageName(pageName, context, p));
        page.getPageProperty().setTitle(pageName);
        page.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        page.setBreadcrumb((List)this.initBreadcrumb(pageName, context, p));
        page.setWidgets((Map)new StrictMap());
        N2oWidget widget = source.getWidget();
        widget.setId((String)p.cast((Object)widget.getId(), (Object)MAIN_WIDGET_ID, new Object[0]));
        widget.setRoute((String)p.cast((Object)widget.getRoute(), (Object)"/", new Object[0]));
        PageRoutes routes = this.initRoute(context, p, pageRoute);
        this.initPreFilters(context, widget);
        Models models = new Models();
        page.setModels(models);
        WidgetScope widgetScope = new WidgetScope();
        ParentRouteScope pageRouteScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        BreadcrumbList breadcrumbs = new BreadcrumbList(page.getBreadcrumb());
        ValidationList validationList = new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>());
        if (context.getUpload() != null) {
            widget.setUpload(context.getUpload());
        }
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        Widget compiledWidget = (Widget)p.compile((Object)widget, (CompileContext)context, new Object[]{routes, pageScope, widgetScope, pageRouteScope, breadcrumbs, validationList, models, pageRoutesScope});
        page.getWidgets().put(compiledWidget.getId(), compiledWidget);
        this.registerRoutes(routes, context, p);
        if (!(context instanceof ModalPageContext)) {
            page.setRoutes(routes);
        }
        page.setLayout(this.createLayout(p, source, context, pageScope));
        String objectId = (String)p.cast((Object)source.getObjectId(), (Object)compiledWidget.getObjectId(), new Object[0]);
        CompiledObject object = null;
        if (objectId != null) {
            object = (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(objectId));
            page.setObject(object);
        }
        if (context.getSubmitOperationId() != null) {
            MetaActions metaActions = new MetaActions();
            page.setToolbar(this.compileToolbar(context, p, metaActions, pageScope, pageRouteScope, object, breadcrumbs, validationList, widget));
            page.setActions((Map)((Object)metaActions));
        }
        return page;
    }

    private PageRoutes initRoute(PageContext context, CompileProcessor p, String pageRoute) {
        PageRoutes routes = new PageRoutes();
        routes.addRoute(new PageRoutes.Route(pageRoute));
        return routes;
    }

    private void initPreFilters(PageContext context, N2oWidget widget) {
        if (context.getPreFilters() != null && !context.getPreFilters().isEmpty()) {
            widget.addPreFilters(context.getPreFilters());
        }
    }

    private Layout createLayout(CompileProcessor p, N2oSimplePage source, PageContext context, PageScope pageScope) {
        Layout layout = new Layout();
        layout.setSrc("SingleLayout");
        N2oCustomRegion n2oCustomRegion = new N2oCustomRegion();
        n2oCustomRegion.setWidgets(new N2oWidget[]{source.getWidget()});
        CustomRegion noneRegion = (CustomRegion)p.compile((Object)n2oCustomRegion, (CompileContext)context, new Object[]{pageScope});
        noneRegion.setPlace("single");
        HashMap regionMap = new HashMap();
        ArrayList<CustomRegion> regionList = new ArrayList<CustomRegion>();
        regionList.add(noneRegion);
        regionMap.put("single", regionList);
        layout.setRegions(regionMap);
        return layout;
    }

    private Toolbar compileToolbar(PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList, N2oWidget widget) {
        N2oToolbar n2oToolbar = new N2oToolbar();
        n2oToolbar.setGenerate(new String[]{GenerateType.submit.name(), GenerateType.close.name()});
        n2oToolbar.setTargetWidgetId((String)p.cast((Object)widget.getId(), (Object)MAIN_WIDGET_ID, new Object[0]));
        return (Toolbar)p.compile((Object)n2oToolbar, (CompileContext)context, new Object[]{metaActions, pageScope, routeScope, object, new IndexScope(), breadcrumbs, validationList});
    }

    public Class<N2oSimplePage> getSourceClass() {
        return N2oSimplePage.class;
    }
}

