/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectScalarField;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class N2oQueryCompiler
implements BaseSourceCompiler<CompiledQuery, N2oQuery, QueryContext> {
    public Class<N2oQuery> getSourceClass() {
        return N2oQuery.class;
    }

    public CompiledQuery compile(N2oQuery source, QueryContext context, CompileProcessor p) {
        CompiledQuery query = new CompiledQuery();
        query.setId(source.getId());
        if (source.getObjectId() != null) {
            query.setObject((CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId())));
        }
        query.setName((String)p.cast((Object)source.getName(), (Object)source.getId(), new Object[0]));
        query.setRoute(RouteUtil.normalize((String)p.cast((Object)source.getRoute(), (Object)source.getId(), new Object[0])));
        query.setLists(source.getLists());
        query.setCounts(source.getCounts());
        query.setUniques(source.getUniques());
        query.setValidations(context.getValidations());
        List<N2oQuery.Field> fields = Arrays.asList(source.getFields());
        fields = this.initDefaultByObject(fields, query.getObject());
        fields = this.initDefaultFields(fields);
        fields = this.initDefaultFilters(fields, p);
        fields = this.initDefaultMapping(fields);
        fields = this.initDefaultExpression(fields);
        fields = this.replaceExpression(fields);
        this.compilePreFilters(source, p, context.getFilters());
        query.setDisplayValues(Collections.unmodifiableMap(N2oQueryCompiler.initDisplayValues(fields)));
        query.setDisplayFields(Collections.unmodifiableList(N2oQueryCompiler.initDisplayFields(fields)));
        query.setSortingFields(Collections.unmodifiableList(N2oQueryCompiler.initSortingFields(fields)));
        query.setFieldsMap(Collections.unmodifiableMap(N2oQueryCompiler.initFieldsMap(fields, query.getId())));
        query.setFieldNamesMap(Collections.unmodifiableMap(N2oQueryCompiler.initFieldNamesMap(query.getFieldsMap())));
        query.setSortingSet(Collections.unmodifiableSet(this.initSortingSet(query.getSortingFields())));
        query.setFiltersMap(Collections.unmodifiableMap(this.initFiltersMap(query, p)));
        query.setInvertFiltersMap(Collections.unmodifiableMap(this.initInvertFiltersMap(query.getFieldsMap())));
        query.setFilterFieldsMap(Collections.unmodifiableMap(this.initFilterFieldsMap(query.getFiltersMap())));
        query.setParamToFilterIdMap(Collections.unmodifiableMap(this.initParamToFilterIdMap(query.getFilterFieldsMap(), p)));
        query.setFilterIdToParamMap(Collections.unmodifiableMap(this.initFilterIdToParamMap(query.getParamToFilterIdMap())));
        query.setSubModelQueries(context.getSubModelQueries());
        this.initExpressions(query);
        query.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        query.setCopiedFields(context.getCopiedFields());
        return query;
    }

    private void compilePreFilters(N2oQuery source, CompileProcessor p, List<Filter> preFilters) {
        if (preFilters == null) {
            return;
        }
        if (source.getFields() == null) {
            return;
        }
        for (Filter preFilter : preFilters) {
            for (N2oQuery.Field field : source.getFields()) {
                if (field.getFilterList() == null) continue;
                for (N2oQuery.Filter filter : field.getFilterList()) {
                    if (!filter.getFilterField().equals(preFilter.getFilterId())) continue;
                    filter.setParam((String)p.cast((Object)preFilter.getParam(), (Object)filter.getParam(), new Object[0]));
                    if (preFilter.getLink() == null || preFilter.getLink().isLink()) continue;
                    filter.setCompiledDefaultValue(p.cast(preFilter.getLink().getValue(), p.resolve(filter.getDefaultValue(), filter.getDomain()), new Object[0]));
                }
            }
        }
    }

    private Map<String, Map.Entry<String, FilterType>> initInvertFiltersMap(Map<String, N2oQuery.Field> fieldsMap) {
        StrictMap invertFiltersMap = new StrictMap();
        fieldsMap.values().stream().filter(queryField -> !queryField.isSearchUnavailable()).forEach(arg_0 -> N2oQueryCompiler.lambda$initInvertFiltersMap$1((Map)invertFiltersMap, arg_0));
        return invertFiltersMap;
    }

    private Map<String, String> initParamToFilterIdMap(Map<String, N2oQuery.Filter> filterIdsMap, CompileProcessor p) {
        StrictMap filterParams = new StrictMap();
        for (N2oQuery.Filter filter : filterIdsMap.values()) {
            String param = (String)p.cast((Object)filter.getParam(), (Object)RouteUtil.normalizeParam(filter.getFilterField()), new Object[0]);
            filterParams.put(param, filter.getFilterField());
        }
        return filterParams;
    }

    private Map<String, String> initFilterIdToParamMap(Map<String, String> paramToFilterMap) {
        StrictMap filterParams = new StrictMap();
        for (Map.Entry<String, String> paramEntry : paramToFilterMap.entrySet()) {
            filterParams.put(paramEntry.getValue(), paramEntry.getKey());
        }
        return filterParams;
    }

    private Map<String, N2oQuery.Filter> initFilterFieldsMap(Map<String, Map<FilterType, N2oQuery.Filter>> filtersMap) {
        StrictMap result = new StrictMap();
        for (Map<FilterType, N2oQuery.Filter> filterMap : filtersMap.values()) {
            for (N2oQuery.Filter filter : filterMap.values()) {
                result.put(filter.getFilterField(), filter);
            }
        }
        return result;
    }

    private Set<String> initSortingSet(List<N2oQuery.Field> sortings) {
        return sortings.stream().map(N2oQuery.Field::getId).collect(Collectors.toSet());
    }

    private void initExpressions(CompiledQuery query) {
        ArrayList select = new ArrayList();
        ArrayList join = new ArrayList();
        query.getDisplayFields().forEach(f -> {
            if (f.getSelectBody() != null) {
                select.add(f.getSelectBody());
            }
            if (!(f.getNoJoin() != null && f.getNoJoin().booleanValue() || f.getJoinBody() == null)) {
                join.add(f.getJoinBody());
            }
        });
        query.setSelectExpressions(select);
        query.setJoinExpressions(join);
    }

    private Map<String, Map<FilterType, N2oQuery.Filter>> initFiltersMap(CompiledQuery query, CompileProcessor p) {
        HashMap<String, Map<FilterType, N2oQuery.Filter>> result = new HashMap<String, Map<FilterType, N2oQuery.Filter>>();
        query.getFieldsMap().values().stream().filter(queryField -> !queryField.isSearchUnavailable()).forEach(queryField -> {
            HashMap<FilterType, N2oQuery.Filter> filters = new HashMap<FilterType, N2oQuery.Filter>();
            for (N2oQuery.Filter f : queryField.getFilterList()) {
                if (f.getDomain() == null) {
                    f.setDomain(DomainProcessor.getDomain((String)queryField.getDomain(), (FilterType)f.getType()));
                }
                if (f.getCompiledDefaultValue() == null && f.getDefaultValue() != null) {
                    f.setCompiledDefaultValue(p.resolve(f.getDefaultValue(), f.getDomain()));
                }
                filters.put(f.getType(), f);
                if (f.getRequired() == null || !f.getRequired().booleanValue()) continue;
                MandatoryValidation mandatory = new MandatoryValidation(f.getFilterField(), p.getMessage("n2o.required.filter", new Object[0]), f.getFilterField());
                mandatory.setMoment(N2oValidation.ServerMoment.beforeQuery);
                mandatory.setSeverity(SeverityType.danger);
                if (query.getValidations() == null) {
                    query.setValidations(new ArrayList());
                }
                query.getValidations().add(mandatory);
            }
            result.put(queryField.getId(), filters);
        });
        return result;
    }

    private List<N2oQuery.Field> initDefaultByObject(List<N2oQuery.Field> fields, CompiledObject object) {
        if (object == null) {
            return fields;
        }
        Map objectFields = object.getObjectFieldsMap();
        for (N2oQuery.Field field : fields) {
            if (!objectFields.containsKey(field.getId())) continue;
            AbstractParameter of = (AbstractParameter)objectFields.get(field.getId());
            if (field.getDomain() == null) {
                String domain = "string";
                if (of instanceof ObjectScalarField && ((ObjectScalarField)of).getDomain() != null) {
                    domain = ((ObjectScalarField)of).getDomain();
                }
                field.setDomain(domain);
            }
            if (field.getName() == null) {
                field.setName(of.getName());
            }
            if (field.getSelectMapping() != null) continue;
            field.setSelectMapping(of.getMapping());
        }
        return fields;
    }

    private List<N2oQuery.Field> initDefaultFilters(List<N2oQuery.Field> fields, CompileProcessor p) {
        for (N2oQuery.Field field : fields) {
            if (field.getFilterList() == null) continue;
            for (N2oQuery.Filter filter : field.getFilterList()) {
                filter.setFilterField((String)p.cast((Object)filter.getFilterField(), (Object)(RouteUtil.normalizeParam(field.getId()) + "_" + filter.getType()), new Object[0]));
                filter.setParam((String)p.cast((Object)filter.getParam(), (Object)RouteUtil.normalizeParam(filter.getFilterField()), new Object[0]));
            }
        }
        return fields;
    }

    private List<N2oQuery.Field> replaceExpression(List<N2oQuery.Field> fields) {
        for (N2oQuery.Field field : fields) {
            if (field.getExpression() == null) continue;
            field.setSelectBody(N2oQueryCompiler.replace(field.getSelectBody(), field.getExpression()));
            field.setSortingBody(N2oQueryCompiler.replace(field.getSortingBody(), field.getExpression()));
            if (field.getFilterList() == null) continue;
            for (N2oQuery.Filter filter : field.getFilterList()) {
                filter.setText(N2oQueryCompiler.replace(filter.getText(), field.getExpression()));
            }
        }
        return fields;
    }

    private static String replace(String text, String expression) {
        if (text == null) {
            return null;
        }
        return text.replace(":expression", expression);
    }

    private List<N2oQuery.Field> initDefaultFields(List<N2oQuery.Field> fields) {
        for (N2oQuery.Field field : fields) {
            field.setName(CompileUtil.castDefault((String)field.getName(), (String)field.getId(), (String[])new String[0]));
            field.setNoDisplay(Boolean.valueOf(CompileUtil.castDefault((Boolean)field.getNoDisplay(), (boolean)false)));
            field.setNoSorting(Boolean.valueOf(CompileUtil.castDefault((Boolean)field.getNoSorting(), (boolean)false)));
            field.setNoJoin(Boolean.valueOf(CompileUtil.castDefault((Boolean)field.getNoJoin(), (boolean)false)));
            if (field.getFilterList() != null) continue;
            field.setFilterList(new N2oQuery.Filter[0]);
        }
        return fields;
    }

    private List<N2oQuery.Field> initDefaultMapping(List<N2oQuery.Field> fields) {
        for (N2oQuery.Field field : fields) {
            if (!field.getNoDisplay().booleanValue() && field.getSelectMapping() == null) {
                field.setSelectMapping(Placeholders.spel((String)field.getId()));
            }
            if (!field.getNoSorting().booleanValue() && field.getSortingMapping() == null) {
                field.setSortingMapping(Placeholders.spel((String)(field.getId() + "Direction")));
            }
            for (N2oQuery.Filter filter : field.getFilterList()) {
                if (filter.getMapping() != null) continue;
                filter.setMapping(Placeholders.spel((String)filter.getFilterField()));
            }
        }
        return fields;
    }

    private List<N2oQuery.Field> initDefaultExpression(List<N2oQuery.Field> fields) {
        for (N2oQuery.Field field : fields) {
            if (field.getExpression() != null) continue;
            field.setExpression(field.getId());
        }
        return fields;
    }

    public static Map<String, String> initDisplayValues(List<N2oQuery.Field> displayFields) {
        HashMap<String, String> displayValues = new HashMap<String, String>();
        for (N2oQuery.Field field : displayFields) {
            if (field.getSelectDefaultValue() == null) continue;
            displayValues.put(field.getId(), N2oQueryCompiler.checkForNull(field.getSelectDefaultValue()));
        }
        return displayValues;
    }

    private static String checkForNull(String value) {
        if ("null".equals(value)) {
            value = null;
        }
        return value;
    }

    private static List<N2oQuery.Field> initSortingFields(List<N2oQuery.Field> fields) {
        ArrayList<N2oQuery.Field> result = new ArrayList<N2oQuery.Field>();
        for (N2oQuery.Field field : fields) {
            if (field.getNoSorting().booleanValue()) continue;
            result.add(field);
        }
        return result;
    }

    private static List<N2oQuery.Field> initDisplayFields(List<N2oQuery.Field> fields) {
        ArrayList<N2oQuery.Field> result = new ArrayList<N2oQuery.Field>();
        for (N2oQuery.Field field : fields) {
            if (field.getNoDisplay().booleanValue()) continue;
            result.add(field);
        }
        return result;
    }

    private static Map<String, N2oQuery.Field> initFieldsMap(List<N2oQuery.Field> fields, String id) {
        StrictMap result = new StrictMap("Field '%s' in query '" + id + "' not found");
        for (N2oQuery.Field field : fields) {
            result.put(field.getId(), field);
        }
        return result;
    }

    private static Map<String, String> initFieldNamesMap(Map<String, N2oQuery.Field> fieldsMap) {
        return fieldsMap.values().stream().collect(Collectors.toMap(N2oQuery.Field::getId, N2oQuery.Field::getName));
    }

    private static /* synthetic */ void lambda$initInvertFiltersMap$1(Map invertFiltersMap, N2oQuery.Field queryField) {
        for (N2oQuery.Filter f : queryField.getFilterList()) {
            invertFiltersMap.put(f.getFilterField(), new CompiledQuery.FilterEntry(queryField.getId(), f.getType()));
        }
    }
}

