/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.validation;

import java.util.ArrayList;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.MapperType;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oConstraint;
import net.n2oapp.framework.config.metadata.compile.validation.BaseValidationCompiler;
import org.springframework.stereotype.Component;

@Component
public class ConstraintValidationCompiler
extends BaseValidationCompiler<ConstraintValidation, N2oConstraint> {
    public Class<? extends Source> getSourceClass() {
        return N2oConstraint.class;
    }

    public ConstraintValidation compile(N2oConstraint source, CompileContext<?, ?> context, CompileProcessor p) {
        ConstraintValidation validation = new ConstraintValidation();
        this.compileValidation(validation, source, context, p);
        validation.setId(source.getId());
        validation.setSeverity(source.getSeverity());
        validation.setMessage(source.getMessage());
        ArrayList<InvocationParameter> inParams = new ArrayList<InvocationParameter>();
        if (source.getInParameters() != null) {
            for (N2oObject.Parameter parameter : source.getInParameters()) {
                inParams.add(new InvocationParameter((InvocationParameter)parameter));
            }
        }
        validation.setInParameterList(inParams);
        ArrayList<InvocationParameter> outParams = new ArrayList<InvocationParameter>();
        if (source.getOutParameters() != null) {
            for (N2oObject.Parameter parameter : source.getOutParameters()) {
                outParams.add(new InvocationParameter((InvocationParameter)parameter));
            }
        }
        InvocationParameter resultParam = new InvocationParameter();
        resultParam.setId("validation");
        resultParam.setMapping(source.getResult());
        resultParam.setMapper((MapperType)p.cast((Object)source.getMapper(), (Object)MapperType.spel, new Object[0]));
        outParams.add(resultParam);
        validation.setOutParametersList(outParams);
        validation.setInvocation(source.getN2oInvocation());
        return validation;
    }
}

