/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldSet;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oSetFieldSet;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.DependencyCondition;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDataProvider;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDependency;
import net.n2oapp.framework.api.metadata.meta.widget.table.Pagination;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.CompileUtil;

public abstract class BaseWidgetCompiler<D extends Widget, S extends N2oWidget>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    private static final String SPREAD_OPERATOR = "*.";

    protected abstract String getPropertyWidgetSrc();

    protected void compileWidget(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject object) {
        String localWidgetId = this.initLocalWidgetId(source, p);
        source.setId(localWidgetId);
        compiled.setMasterParam(source.getMasterParam());
        compiled.setId(this.initGlobalWidgetId(source, localWidgetId, context, p));
        compiled.setClassName(source.getCssClass());
        compiled.setProperties(p.mapAttributes(source));
        compiled.setObjectId(object != null ? object.getId() : null);
        compiled.setQueryId(source.getQueryId());
        compiled.setName((String)p.cast((Object)source.getName(), (Object)(object != null ? object.getName() : null), new Object[]{source.getId()}));
        compiled.setRoute(this.initWidgetRoute(source, p));
        this.compileMasterLink(compiled, p);
        compiled.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)this.getPropertyWidgetSrc()), String.class)), new Object[0]));
        compiled.setOpened(source.getOpened());
        compiled.setIcon(source.getIcon());
        compiled.setUpload((UploadType)p.cast((Object)source.getUpload(), (Object)(source.getQueryId() != null ? UploadType.query : UploadType.defaults), new Object[0]));
        this.compileAutoFocus(source, compiled, p);
        compiled.setProperties(p.mapAttributes(source));
        this.compileDependencies(compiled, source, p);
        this.initFilters(compiled, source, p);
    }

    private String initWidgetRoute(S source, CompileProcessor p) {
        if (source.getRoute() != null) {
            return source.getRoute();
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null && widgetScope.getDependsOnWidgetId() != null) {
            String selectedId = RouteUtil.normalizeParam((String)p.cast((Object)source.getMasterParam(), (Object)(widgetScope.getDependsOnWidgetId() + "_id"), new Object[0]));
            return RouteUtil.normalize(Placeholders.colon((String)selectedId)) + RouteUtil.normalize(source.getId());
        }
        return RouteUtil.normalize(source.getId());
    }

    protected ParentRouteScope initWidgetRouteScope(D compiled, CompileContext<?, ?> context, CompileProcessor p) {
        String route = compiled.getRoute();
        StrictMap additionalPathParams = null;
        Map<String, ModelLink> additionalQueryParams = null;
        if (compiled.getMasterLink() != null) {
            additionalPathParams = new StrictMap();
            additionalPathParams.put(compiled.getMasterParam(), compiled.getMasterLink());
        }
        ParentRouteScope parentRouteScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (compiled.getDependency() != null && compiled.getDependency().getFetch() != null) {
            for (DependencyCondition fetch : compiled.getDependency().getFetch()) {
                ParentRouteScope masterRouteScope;
                if (fetch.getGlobalMasterWidgetId() == null || (masterRouteScope = (ParentRouteScope)pageRoutesScope.get(fetch.getGlobalMasterWidgetId())) == null) continue;
                masterRouteScope.getPathMapping().forEach(parentRouteScope.getPathMapping()::putIfAbsent);
                masterRouteScope.getQueryMapping().forEach(parentRouteScope.getQueryMapping()::putIfAbsent);
            }
        }
        ParentRouteScope widgetRouteScope = parentRouteScope != null ? new ParentRouteScope(route, (Map<String, ModelLink>)additionalPathParams, additionalQueryParams, parentRouteScope) : (context.getRoute((BindProcessor)((N2oCompileProcessor)p)) != null ? new ParentRouteScope(context.getRoute((BindProcessor)((N2oCompileProcessor)p)), (Map<String, ModelLink>)additionalPathParams, additionalQueryParams) : new ParentRouteScope(route, (Map<String, ModelLink>)additionalPathParams, additionalQueryParams));
        return widgetRouteScope;
    }

    private void compileMasterLink(D compiled, CompileProcessor p) {
        String route = compiled.getRoute();
        List<String> params = RouteUtil.getParams(route);
        if (!params.isEmpty()) {
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            if (params.size() > 1) {
                throw new N2oException("Widget route can not contain more then one param: " + route);
            }
            if (widgetScope == null || widgetScope.getDependsOnWidgetId() == null) {
                throw new N2oException("Widget route contains params " + route + ", but parent widget not found! May you have forgotten to specify 'depends-on' attribute?");
            }
            String masterIdParam = params.get(0);
            ModelLink masterLink = Redux.linkQuery(widgetScope.getDependsOnWidgetId(), "id", widgetScope.getDependsOnQueryId());
            compiled.setMasterParam(masterIdParam);
            compiled.setMasterLink(masterLink);
        }
    }

    protected void compileDataProviderAndRoutes(D compiled, S source, CompileProcessor p, ValidationList validationList, ParentRouteScope widgetRouteScope, SubModelsScope subModelsScope, CopiedFieldScope copiedFieldScope) {
        CompiledQuery query = this.getDataProviderQuery(source, p);
        String widgetRoute = widgetRouteScope.getUrl();
        compiled.setDataProvider(this.initDataProvider(compiled, source, widgetRoute, query, p, validationList, widgetRouteScope, subModelsScope, copiedFieldScope));
        this.compileRouteWidget(compiled, source, query, p, widgetRouteScope);
        this.compileFetchOnInit(source, compiled);
    }

    protected void collectValidation(FieldSet fs, Map<String, List<Validation>> clientValidations, ValidationScope validationScope) {
        if (fs.getRows() == null) {
            return;
        }
        fs.getRows().stream().filter(row -> row.getCols() != null).forEach(row -> row.getCols().stream().forEach(col -> {
            if (col.getFields() != null) {
                col.getFields().forEach(f -> {
                    if (f.getServerValidations() != null) {
                        validationScope.addAll(f.getServerValidations());
                    }
                    if (f.getClientValidations() != null) {
                        clientValidations.put(f.getId(), f.getClientValidations());
                    }
                });
            }
            if (col.getFieldsets() != null) {
                col.getFieldsets().forEach(fieldset -> this.collectValidation((FieldSet)fieldset, clientValidations, validationScope));
            }
        }));
    }

    private String initGlobalWidgetId(S source, String localWidgetId, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (pageScope != null) {
            return pageScope.getGlobalWidgetId(localWidgetId);
        }
        return context.getCompiledId((BindProcessor)((N2oCompileProcessor)p));
    }

    private String initLocalWidgetId(S source, CompileProcessor p) {
        if (source.getId() == null) {
            IndexScope indexScope = (IndexScope)p.getScope(IndexScope.class);
            return indexScope != null ? "w" + indexScope.get() : "";
        }
        return source.getId();
    }

    protected void compileToolbarAndAction(D compiled, S source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, ParentRouteScope widgetRouteScope, MetaActions widgetActions, CompiledObject object, ValidationList validationList) {
        this.actionsToToolbar(source);
        this.compileActions(source, context, p, widgetActions, widgetScope, widgetRouteScope, object, validationList);
        this.compileToolbar(compiled, source, object, context, p, widgetActions, widgetScope, widgetRouteScope, validationList);
        compiled.setActions((Map)((Object)widgetActions));
    }

    private void compileFetchOnInit(S source, D compiled) {
        if (compiled.getComponent() == null) {
            return;
        }
        boolean fetchOnInit = source.getFetchOnInit() != null ? source.getFetchOnInit() : source.getDependsOn() == null && compiled.getDataProvider() != null;
        compiled.getComponent().setFetchOnInit(Boolean.valueOf(fetchOnInit));
    }

    private void compileAutoFocus(S source, D compiled, CompileProcessor p) {
        if (compiled.getComponent() == null) {
            return;
        }
        compiled.getComponent().setAutoFocus((Boolean)p.cast((Object)source.getAutoFocus(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.auto_focus"), Boolean.class)), new Object[]{true}));
    }

    private void actionsToToolbar(S source) {
        if (source.getActions() == null || source.getToolbars() == null) {
            return;
        }
        HashMap<String, ActionsBar> actionMap = new HashMap<String, ActionsBar>();
        Stream.of(source.getActions()).forEach(a -> actionMap.put(a.getId(), (ActionsBar)a));
        for (N2oToolbar toolbar : source.getToolbars()) {
            if (toolbar.getItems() == null) continue;
            ToolbarItem[] toolbarItems = toolbar.getItems();
            this.copyActionForToolbarItem(actionMap, toolbarItems);
        }
    }

    private void copyActionForToolbarItem(Map<String, ActionsBar> actionMap, ToolbarItem[] toolbarItems) {
        for (ToolbarItem item : toolbarItems) {
            if (item instanceof N2oButton || item instanceof N2oMenuItem) {
                this.copyAction((AbstractMenuItem)item, actionMap);
                continue;
            }
            if (item instanceof N2oSubmenu) {
                for (N2oMenuItem subItem : ((N2oSubmenu)item).getMenuItems()) {
                    this.copyAction((AbstractMenuItem)subItem, actionMap);
                }
                continue;
            }
            if (!(item instanceof N2oGroup)) continue;
            this.copyActionForToolbarItem(actionMap, (ToolbarItem[])((N2oGroup)item).getItems());
        }
    }

    private void copyAction(AbstractMenuItem item, Map<String, ActionsBar> actionMap) {
        AbstractMenuItem mi = item;
        if (mi.getAction() == null && mi.getActionId() != null) {
            ActionsBar action = actionMap.get(mi.getActionId());
            if (action == null) {
                throw new N2oException("Toolbar has reference to nonexistent action by actionId {0}!").addData(new Object[]{mi.getActionId()});
            }
            mi.setAction(action.getAction());
            if (mi.getModel() == null) {
                mi.setModel(action.getModel());
            }
            if (mi.getWidgetId() == null) {
                mi.setWidgetId(action.getWidgetId());
            }
            if (mi.getLabel() == null) {
                mi.setLabel(action.getLabel());
            }
            if (mi.getIcon() == null) {
                mi.setIcon(action.getIcon());
            }
        }
    }

    private void compileToolbar(D compiled, S source, CompiledObject object, CompileContext<?, ?> context, CompileProcessor p, MetaActions compiledActions, WidgetScope widgetScope, ParentRouteScope widgetRouteScope, ValidationList validations) {
        if (source.getToolbars() == null) {
            return;
        }
        Toolbar compiledToolbar = new Toolbar();
        IndexScope index = new IndexScope();
        for (N2oToolbar toolbar : source.getToolbars()) {
            compiledToolbar.putAll((Map)p.compile((Object)toolbar, context, new Object[]{widgetScope, widgetRouteScope, compiledActions, object, index, validations}));
        }
        compiled.setToolbar(compiledToolbar);
    }

    private void compileRouteWidget(D compiled, S source, CompiledQuery query, CompileProcessor p, ParentRouteScope widgetRouteScope) {
        PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
        if (routes == null) {
            return;
        }
        String widgetRoute = widgetRouteScope.getUrl();
        routes.addRoute(widgetRouteScope.getUrl());
        if (compiled.getMasterLink() != null) {
            routes.addPathMapping(compiled.getMasterParam(), Redux.dispatchSelectedWidget(compiled.getMasterLink().getWidgetId(), Placeholders.colon((String)compiled.getMasterParam())));
        }
        String selectedId = RouteUtil.normalizeParam(compiled.getId() + "_id");
        String routeWidgetSelected = RouteUtil.normalize(widgetRoute + RouteUtil.normalize(Placeholders.colon((String)selectedId)));
        routes.addRoute(routeWidgetSelected);
        ReduxAction widgetIdMapping = Redux.dispatchSelectedWidget(compiled.getId(), Placeholders.colon((String)selectedId));
        routes.addPathMapping(selectedId, widgetIdMapping);
        if (query != null) {
            compiled.getFilters().stream().filter(Filter::getReloadable).forEach(filter -> {
                String filterId = filter.getFilterId();
                ReduxAction onGet = filterId.contains(SPREAD_OPERATOR) ? Redux.dispatchUpdateMapModel(compiled.getId(), ReduxModel.FILTER, filterId.substring(0, filterId.indexOf(SPREAD_OPERATOR)), filterId.substring(filterId.indexOf(SPREAD_OPERATOR) + 2), Placeholders.colon((String)filter.getParam())) : Redux.dispatchUpdateModel(compiled.getId(), ReduxModel.FILTER, filterId, Placeholders.colon((String)filter.getParam()));
                routes.addQueryMapping(filter.getParam(), onGet, (BindLink)filter.getLink());
            });
            for (N2oQuery.Field field : query.getSortingFields()) {
                String sortParam = RouteUtil.normalizeParam("sorting." + source.getId() + "_" + field.getId());
                BindLink onSet = Redux.createSortLink(compiled.getId(), field.getId());
                ReduxAction onGet = Redux.dispatchSortWidget(compiled.getId(), field.getId(), Placeholders.colon((String)sortParam));
                routes.addQueryMapping(sortParam, onGet, onSet);
            }
        }
    }

    protected CompiledObject getObject(S source, CompileProcessor p) {
        if (source.getObjectId() == null) {
            if (source.getQueryId() != null) {
                CompiledQuery query = (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(source.getQueryId()));
                return query.getObject();
            }
        } else {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId()));
        }
        return null;
    }

    private WidgetDataProvider initDataProvider(D widget, S source, String widgetRoute, CompiledQuery query, CompileProcessor p, ValidationList validationList, ParentRouteScope parentRouteScope, SubModelsScope subModelsScope, CopiedFieldScope copiedFieldScope) {
        if (query == null) {
            return null;
        }
        WidgetDataProvider dataProvider = new WidgetDataProvider();
        dataProvider.setUrl((String)p.resolve(Placeholders.property((String)"n2o.config.data.route"), String.class) + RouteUtil.normalize(widgetRoute));
        StrictMap pathMap = new StrictMap();
        if (parentRouteScope != null && parentRouteScope.getPathMapping() != null) {
            pathMap.putAll(parentRouteScope.getPathMapping());
        }
        dataProvider.setPathMapping((Map)pathMap);
        if (widget.getFilters() != null) {
            StrictMap queryMap = new StrictMap();
            widget.getFilters().stream().filter(arg_0 -> BaseWidgetCompiler.lambda$initDataProvider$7((Map)pathMap, arg_0)).forEach(arg_0 -> BaseWidgetCompiler.lambda$initDataProvider$8((Map)queryMap, arg_0));
            dataProvider.setQueryMapping((Map)queryMap);
        }
        p.addRoute((CompileContext)this.getQueryContext(widget, source, widgetRoute, query, validationList, subModelsScope, copiedFieldScope, p));
        return dataProvider;
    }

    protected QueryContext getQueryContext(D widget, S source, String route, CompiledQuery query, ValidationList validationList, SubModelsScope subModelsScope, CopiedFieldScope copiedFieldScope, CompileProcessor p) {
        QueryContext queryContext = new QueryContext(query.getId(), route);
        queryContext.setValidations(validationList == null ? null : validationList.get(widget.getId(), ReduxModel.FILTER));
        queryContext.setFilters(widget.getFilters());
        queryContext.setUpload(widget.getUpload());
        queryContext.setFailAlertWidgetId(this.getFailAlertWidget((Widget)widget));
        queryContext.setSuccessAlertWidgetId(this.getSuccessAlertWidget((Widget)widget));
        queryContext.setMessagesForm(this.getMessagesForm((Widget)widget));
        if (source instanceof N2oForm) {
            queryContext.setSubModelQueries(subModelsScope);
            queryContext.setQuerySize(1);
        } else {
            queryContext.setQuerySize(10);
        }
        if (copiedFieldScope != null) {
            queryContext.setCopiedFields(copiedFieldScope.getCopiedFields());
        }
        return queryContext;
    }

    protected String getFailAlertWidget(Widget widget) {
        return widget.getId();
    }

    protected String getSuccessAlertWidget(Widget widget) {
        return widget.getId();
    }

    protected String getMessagesForm(Widget widget) {
        return widget.getId();
    }

    private void compileActions(S source, CompileContext<?, ?> context, CompileProcessor p, MetaActions widgetActions, WidgetScope widgetScope, ParentRouteScope widgetRouteScope, CompiledObject object, ValidationList validationList) {
        if (source.getActions() != null) {
            for (ActionsBar a : source.getActions()) {
                a.setModel((ReduxModel)p.cast((Object)a.getModel(), (Object)ReduxModel.RESOLVE, new Object[0]));
                p.compile((Object)a.getAction(), context, new Object[]{widgetScope, widgetActions, widgetRouteScope, object, validationList, new ComponentScope(a)});
            }
        }
    }

    private void compileDependencies(D compiled, S source, CompileProcessor p) {
        WidgetDependency dependency = new WidgetDependency();
        String masterWidgetId = null;
        if (source.getDependsOn() != null) {
            ArrayList<DependencyCondition> fetch = new ArrayList<DependencyCondition>();
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            if (widgetScope != null && widgetScope.getDependsOnWidgetId() != null) {
                masterWidgetId = widgetScope.getDependsOnWidgetId();
                ModelLink bindLink = new ModelLink(ReduxModel.RESOLVE, masterWidgetId);
                DependencyCondition condition = new DependencyCondition();
                condition.setGlobalMasterWidgetId(masterWidgetId);
                condition.setOn(bindLink.getBindLink());
                fetch.add(condition);
            }
            dependency.setFetch(fetch);
        }
        if (source.getVisible() != null) {
            Object condition = p.resolveJS(source.getVisible(), Boolean.class);
            if (StringUtils.isJs((Object)condition)) {
                DependencyCondition visibilityCondition = new DependencyCondition();
                ArrayList<DependencyCondition> visible = new ArrayList<DependencyCondition>();
                if (masterWidgetId != null) {
                    visibilityCondition.setOn(new ModelLink(ReduxModel.RESOLVE, masterWidgetId).getBindLink());
                }
                visibilityCondition.setCondition((Object)((String)condition).substring(1, ((String)condition).length() - 1));
                visible.add(visibilityCondition);
                dependency.setVisible(visible);
            } else if (condition instanceof Boolean) {
                compiled.setVisible((Boolean)condition);
            }
        }
        if (!dependency.isEmpty()) {
            compiled.setDependency(dependency);
        }
    }

    private CompiledQuery getDataProviderQuery(S source, CompileProcessor p) {
        String queryId = null;
        UploadType upload = source.getUpload();
        if (UploadType.query == upload) {
            queryId = source.getQueryId();
            if (queryId == null) {
                throw new N2oException("Upload is 'query', but queryId isn't set in widget");
            }
        } else if (UploadType.defaults == upload) {
            queryId = source.getDefaultValuesQueryId();
        } else if (UploadType.copy == upload) {
            queryId = source.getQueryId();
        } else if (upload == null && source.getQueryId() != null) {
            queryId = source.getQueryId();
        }
        if (queryId != null) {
            return (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(queryId));
        }
        return null;
    }

    protected CompiledQuery getQuery(S source, CompileProcessor p) {
        CompiledQuery query;
        CompiledQuery compiledQuery = query = source.getQueryId() != null ? (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(source.getQueryId())) : null;
        if (query == null) {
            query = source.getDefaultValuesQueryId() != null ? (CompiledQuery)p.getCompiled((CompileContext)new QueryContext(source.getDefaultValuesQueryId())) : null;
        }
        return query;
    }

    protected FieldSetScope initFieldSetScope(CompiledQuery query, CompiledObject object) {
        FieldSetScope scope = new FieldSetScope();
        if (query != null) {
            Map fieldsMap = query.getFieldsMap();
            for (Map.Entry entry : fieldsMap.entrySet()) {
                if (entry.getValue() == null) continue;
                scope.put((String)entry.getKey(), ((N2oQuery.Field)entry.getValue()).getName());
            }
        }
        if (object != null) {
            Map fieldMap = object.getObjectFieldsMap();
            for (Map.Entry entry : fieldMap.entrySet()) {
                if (scope.containsKey(entry.getKey())) continue;
                scope.put((String)entry.getKey(), ((AbstractParameter)entry.getValue()).getName());
            }
        }
        return scope;
    }

    protected List<FieldSet> initFieldSets(NamespaceUriAware[] fields, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, CompiledQuery widgetQuery, CompiledObject widgetObject, ModelsScope modelsScope, FiltersScope filtersScope, SubModelsScope subModelsScope, UploadScope uploadScope, MomentScope momentScope, CopiedFieldScope copiedFieldScope) {
        if (fields == null) {
            return Collections.emptyList();
        }
        FieldSetScope fieldSetScope = this.initFieldSetScope(widgetQuery, widgetObject);
        IndexScope indexScope = new IndexScope();
        ArrayList<FieldSet> fieldSets = new ArrayList<FieldSet>();
        int i = 0;
        while (i < fields.length) {
            N2oFieldSet fieldSet;
            if (fields[i] instanceof N2oFieldSet) {
                fieldSet = (N2oFieldSet)fields[i];
                ++i;
            } else {
                N2oSetFieldSet newFieldset = new N2oSetFieldSet();
                ArrayList<NamespaceUriAware> newFieldsetItems = new ArrayList<NamespaceUriAware>();
                while (i < fields.length && !(fields[i] instanceof N2oFieldSet)) {
                    newFieldsetItems.add(fields[i]);
                    ++i;
                }
                NamespaceUriAware[] items = new NamespaceUriAware[newFieldsetItems.size()];
                newFieldset.setItems(newFieldsetItems.toArray(items));
                fieldSet = newFieldset;
            }
            fieldSets.add((FieldSet)p.compile((Object)fieldSet, context, new Object[]{widgetQuery, widgetObject, widgetScope, fieldSetScope, modelsScope, filtersScope, indexScope, subModelsScope, uploadScope, momentScope, copiedFieldScope}));
        }
        return fieldSets;
    }

    private void initFilters(D compiled, S source, CompileProcessor p) {
        CompiledQuery query = this.getDataProviderQuery(source, p);
        if (query == null) {
            return;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String masterWidgetId = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (widgetScope != null) {
            masterWidgetId = widgetScope.getDependsOnWidgetId();
        }
        if (masterWidgetId != null && source.getDetailFieldId() != null) {
            Filter filter = new Filter();
            filter.setFilterId(query.getFilterFieldId(source.getDetailFieldId(), FilterType.eq));
            if (source.getMasterFieldId() == null || source.getMasterFieldId().equals("id")) {
                if (compiled.getMasterParam() != null) {
                    filter.setParam(compiled.getMasterParam());
                } else {
                    filter.setParam(RouteUtil.normalizeParam(masterWidgetId + "_id"));
                }
            } else {
                filter.setParam(RouteUtil.normalizeParam(source.getMasterFieldId()));
            }
            filter.setReloadable(Boolean.valueOf(false));
            String masterFieldId = (String)p.cast((Object)source.getMasterFieldId(), (Object)"id", new Object[0]);
            ModelLink link = Redux.linkQuery(masterWidgetId, masterFieldId, source.getQueryId());
            filter.setLink(link);
            filters.add(filter);
        }
        if (source.getPreFilters() != null) {
            for (N2oPreFilter preFilter : source.getPreFilters()) {
                Filter filter;
                N2oQuery.Filter queryFilter = query.getFilterByPreFilter(preFilter);
                if (queryFilter != null) {
                    filter = new Filter();
                    if (preFilter.getRequired() != null && preFilter.getRequired().booleanValue() && p.getScope(ValidationList.class) != null) {
                        MandatoryValidation v = new MandatoryValidation(queryFilter.getFilterField(), p.getMessage("n2o.required.filter", new Object[0]), queryFilter.getFilterField());
                        v.setMoment(N2oValidation.ServerMoment.beforeQuery);
                        v.setSeverity(SeverityType.danger);
                        ReduxModel prefilterModel = (ReduxModel)p.cast((Object)preFilter.getRefModel(), (Object)ReduxModel.RESOLVE, new Object[0]);
                        if (((ValidationList)p.getScope(ValidationList.class)).get(compiled.getId(), prefilterModel) == null) {
                            HashMap map = new HashMap();
                            map.put(compiled.getId(), new ArrayList());
                            ((ValidationList)p.getScope(ValidationList.class)).getValidations().put(prefilterModel, map);
                        }
                        List<Validation> validationList = ((ValidationList)p.getScope(ValidationList.class)).get(compiled.getId(), prefilterModel);
                        validationList.add((Validation)v);
                    }
                    filter.setParam((String)p.cast((Object)preFilter.getParam(), (Object)(compiled.getId() + "_" + queryFilter.getParam()), new Object[0]));
                    filter.setReloadable(Boolean.valueOf(false));
                    filter.setFilterId(queryFilter.getFilterField());
                    Object prefilterValue = this.getPrefilterValue(preFilter);
                    if (StringUtils.isJs((Object)prefilterValue)) {
                        String widgetId = masterWidgetId;
                        if (preFilter.getRefWidgetId() != null) {
                            widgetId = preFilter.getRefPageId() == null ? pageScope.getGlobalWidgetId(preFilter.getRefWidgetId()) : CompileUtil.generateWidgetId(preFilter.getRefPageId(), preFilter.getRefWidgetId());
                        }
                        ReduxModel model = (ReduxModel)p.cast((Object)preFilter.getRefModel(), (Object)ReduxModel.RESOLVE, new Object[0]);
                        ModelLink link = new ModelLink(model, widgetId);
                        link.setValue(prefilterValue);
                        filter.setLink(link);
                    } else {
                        ModelLink link = new ModelLink(prefilterValue);
                        filter.setLink(link);
                    }
                } else {
                    throw new N2oException("Pre-filter " + preFilter + " not found in query " + query.getId());
                }
                filters.add(filter);
            }
        }
        compiled.setFilters(filters);
    }

    private Object getPrefilterValue(N2oPreFilter n2oPreFilter) {
        if (n2oPreFilter.getValues() == null) {
            return ScriptProcessor.resolveExpression((String)n2oPreFilter.getValue());
        }
        return ScriptProcessor.resolveArrayExpression((String[])n2oPreFilter.getValues());
    }

    protected Pagination createPaging(Integer size, Boolean prev, Boolean next, String property, CompileProcessor p) {
        Pagination pagination = new Pagination();
        pagination.setSize(size != null ? size : (Integer)p.resolve(Placeholders.property((String)property), Integer.class));
        pagination.setPrev(prev);
        pagination.setNext(next);
        return pagination;
    }

    private static /* synthetic */ void lambda$initDataProvider$8(Map queryMap, Filter f) {
        queryMap.put(f.getParam(), f.getLink());
    }

    private static /* synthetic */ boolean lambda$initDataProvider$7(Map pathMap, Filter f) {
        return !pathMap.containsKey(f.getParam());
    }
}

