/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.FormMode;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.widget.form.Form;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class FormCompiler
extends BaseWidgetCompiler<Form, N2oForm> {
    public Class<N2oForm> getSourceClass() {
        return N2oForm.class;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.form.src";
    }

    public Form compile(N2oForm source, CompileContext<?, ?> context, CompileProcessor p) {
        Form form = new Form();
        form.getComponent().setPrompt(source.getPrompt());
        CompiledQuery query = this.getQuery(source, p);
        CompiledObject object = this.getObject(source, p);
        this.compileWidget(form, source, context, p, object);
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setWidgetId(source.getId());
        widgetScope.setQueryId(source.getQueryId());
        widgetScope.setClientWidgetId(form.getId());
        MetaActions widgetActions = new MetaActions();
        ParentRouteScope widgetRoute = this.initWidgetRouteScope(form, context, p);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (pageRoutesScope != null) {
            pageRoutesScope.put(form.getId(), widgetRoute);
        }
        Models models = (Models)p.getScope(Models.class);
        UploadScope uploadScope = new UploadScope();
        uploadScope.setUpload(form.getUpload());
        SubModelsScope subModelsScope = new SubModelsScope();
        CopiedFieldScope copiedFieldScope = new CopiedFieldScope();
        form.getComponent().setFieldsets(this.initFieldSets(source.getItems(), context, p, widgetScope, query, object, new ModelsScope(ReduxModel.RESOLVE, form.getId(), models), null, subModelsScope, uploadScope, new MomentScope(N2oValidation.ServerMoment.beforeOperation), copiedFieldScope));
        ValidationList validationList = p.getScope(ValidationList.class) == null ? new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>()) : (ValidationList)p.getScope(ValidationList.class);
        ValidationScope validationScope = new ValidationScope(form.getId(), ReduxModel.RESOLVE, validationList);
        this.compileValidation(form, source, validationScope);
        this.compileDataProviderAndRoutes(form, source, p, validationList, widgetRoute, subModelsScope, copiedFieldScope);
        this.compileToolbarAndAction(form, source, context, p, widgetScope, widgetRoute, widgetActions, object, validationList);
        if (source.getMode() != null && source.getMode().equals((Object)FormMode.TWO_MODELS)) {
            form.getComponent().setModelPrefix("edit");
        } else {
            form.getComponent().setModelPrefix("resolve");
        }
        return form;
    }

    private void compileValidation(Form form, N2oForm source, ValidationScope validationScope) {
        if (source.getItems() == null) {
            return;
        }
        HashMap clientValidations = new HashMap();
        form.getComponent().getFieldsets().forEach(fs -> this.collectValidation((FieldSet)fs, clientValidations, validationScope));
        form.getComponent().setValidation(clientValidations);
    }
}

