/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.widget;

import java.util.ArrayList;
import java.util.Arrays;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import org.springframework.stereotype.Component;

@Component
public class WidgetValidator
implements SourceValidator<N2oWidget>,
SourceClassAware {
    public void validate(N2oWidget n2oWidget, ValidateProcessor p) {
        if (!N2oForm.class.isAssignableFrom(n2oWidget.getWidgetClass()) && n2oWidget.getQueryId() == null && n2oWidget.getObjectId() == null) {
            throw new N2oMetadataValidationException("\u0412 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '" + n2oWidget.getId() + "' \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u0438 \u0432\u044b\u0431\u043e\u0440\u043a\u0430, \u043d\u0438 \u043e\u0431\u044a\u0435\u043a\u0442!");
        }
        if (n2oWidget.getQueryId() != null) {
            p.checkForExists(n2oWidget.getQueryId(), N2oQuery.class, "\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 '" + n2oWidget.getQueryId() + "'");
        }
        if (n2oWidget.getObjectId() != null) {
            p.checkForExists(n2oWidget.getObjectId(), N2oObject.class, "\u0412\u0438\u0434\u0436\u0435\u0442 '" + n2oWidget.getId() + "' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 '" + n2oWidget.getObjectId() + "'");
        }
        if (n2oWidget.getToolbars() != null) {
            ArrayList<Object> menuItems = new ArrayList<Object>();
            N2oToolbar[] n2oToolbarArray = n2oWidget.getToolbars();
            int n = n2oToolbarArray.length;
            for (int i = 0; i < n; ++i) {
                N2oToolbar toolbar = n2oToolbarArray[i];
                if (toolbar.getItems() == null) continue;
                for (ToolbarItem item : toolbar.getItems()) {
                    if (item instanceof N2oButton) {
                        menuItems.add((N2oButton)item);
                        continue;
                    }
                    if (!(item instanceof N2oSubmenu)) continue;
                    menuItems.addAll(Arrays.asList(((N2oSubmenu)item).getMenuItems()));
                }
            }
            p.checkIdsUnique(menuItems, "MenuItem '%s' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '" + n2oWidget.getId() + "'!");
        }
        if (n2oWidget.getPreFilters() != null && n2oWidget.getDependsOn() == null && n2oWidget.getDetailFieldId() == null) {
            for (N2oPreFilter preFilter : n2oWidget.getPreFilters()) {
                if (preFilter.getRefWidgetId() != null || !StringUtils.hasLink((String)preFilter.getValue())) continue;
                throw new N2oMetadataValidationException("\u0412 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '" + (n2oWidget.getId() == null ? "" : n2oWidget.getId()) + "' \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u0430 '" + preFilter.getFieldId() + "' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439, \u043d\u043e \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u043d\u0435\u0435 \u043f\u0440\u043e\u043f\u0438\u0441\u0430\u043d\u0430!");
            }
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oWidget.class;
    }
}

