/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.persister;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.n2oapp.framework.api.event.N2oEvent;
import net.n2oapp.framework.api.event.N2oEventBus;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.persister.NamespacePersisterFactory;
import net.n2oapp.framework.api.metadata.reader.ConfigMetadataLocker;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.ConfigStarter;
import net.n2oapp.framework.config.persister.MetadataPersisterException;
import net.n2oapp.framework.config.reader.XmlMetadataLoader;
import net.n2oapp.framework.config.register.ConfigId;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.InfoStatus;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.XmlInfo;
import net.n2oapp.framework.config.register.event.ConfigPersistEvent;
import net.n2oapp.framework.config.register.event.MetadataRemovedEvent;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import net.n2oapp.framework.config.util.XmlUtil;
import net.n2oapp.watchdir.WatchDir;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataPersister {
    @Autowired
    private N2oEventBus eventBus;
    @Autowired
    private ConfigMetadataLocker configMetadataLocker;
    @Autowired
    private NamespacePersisterFactory persisterFactory;
    @Autowired
    private WatchDir watchDir;
    @Autowired
    private MetadataRegister metadataRegister;
    @Autowired
    private XmlMetadataLoader metadataReader;
    @Autowired
    private SourceTypeRegister metaModelRegister;
    private boolean readonly;
    @Autowired
    private ConfigStarter configStarter;

    public MetadataPersister() {
        this.readonly = false;
    }

    public MetadataPersister(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    private void checkLock() {
        if (this.isReadonly() || this.configMetadataLocker.isLocked()) {
            MetadataPersisterException.throwPersisterLock();
        }
    }

    public <T extends N2oMetadata> void persist(T n2o) {
        this.persist(n2o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends N2oMetadata> void persist(T n2o, String directory) {
        boolean isCreate = this.metadataRegister.contains(n2o.getId(), n2o.getClass());
        this.checkLock();
        Element element = this.persisterFactory.produce(n2o).persist(n2o, n2o.getNamespace());
        Document doc = new Document();
        doc.addContent((Content)element);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(XmlUtil.N2O_FORMAT);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            xmlOutput.output(doc, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InfoConstructor info = this.findOrCreateXmlInfo(n2o, directory);
        String path = PathUtil.convertUrlToAbsolutePath(info.getURI());
        if (path == null) {
            throw new IllegalStateException();
        }
        this.watchDir.skipOn(path);
        try {
            FileSystemUtil.saveContentToFile(new ByteArrayInputStream(outputStream.toByteArray()), new File(path));
            this.metadataRegister.update((SourceInfo)info);
            this.metadataRegister.add((SourceInfo)info);
            this.eventBus.publish((N2oEvent)new ConfigPersistEvent(this, info, isCreate));
        }
        finally {
            this.watchDir.takeOn(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SourceMetadata> void persist(String id, Class<T> metadataClass, InputStream xml, String directory) {
        boolean isCreate = !this.metadataRegister.contains(id, metadataClass);
        this.checkLock();
        T n2o = this.metadataReader.read(id, xml, metadataClass);
        InfoConstructor infoC = this.findOrCreateXmlInfo(n2o, directory);
        String path = PathUtil.convertUrlToAbsolutePath(infoC.getURI());
        if (path == null) {
            throw new IllegalStateException();
        }
        try {
            this.watchDir.skipOn(path);
            FileSystemUtil.saveContentToFile(xml, new File(path));
            this.metadataRegister.update((SourceInfo)infoC);
            this.metadataRegister.add((SourceInfo)infoC);
            this.eventBus.publish((N2oEvent)new ConfigPersistEvent(this, infoC, isCreate));
        }
        finally {
            this.watchDir.takeOn(path);
        }
    }

    private <T extends SourceMetadata> InfoConstructor findOrCreateXmlInfo(T n2o, String directory) {
        SourceInfo info;
        if (this.metadataRegister.contains(n2o.getId(), n2o.getClass()) && (info = this.metadataRegister.get(n2o.getId(), n2o.getClass())) instanceof XmlInfo) {
            XmlInfo xmlInfo = (XmlInfo)info;
            if (directory != null && !PathUtil.normalize(xmlInfo.getDirectory()).equalsIgnoreCase(PathUtil.normalize(directory))) {
                throw new IllegalArgumentException("Attempt to make a duplicate file.");
            }
            if (InfoStatus.isSystemFile(xmlInfo)) {
                InfoConstructor infoC = new InfoConstructor(xmlInfo);
                infoC.setAncestor(null);
                return infoC;
            }
            InfoConstructor infoConstructor = new InfoConstructor(xmlInfo);
            return infoConstructor;
        }
        String localPath = PathUtil.concatFileNameAndBasePath(n2o.getId() + "." + n2o.getMetadataType() + ".xml", directory);
        String path = PathUtil.convertRootPathToUrl(this.configStarter.getConfigPath());
        String uri = PathUtil.concatAbsoluteAndLocalPath(path, localPath);
        return RegisterUtil.createXmlInfo(localPath, uri, this.metaModelRegister);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id, Class<? extends N2oMetadata> metadataClass) {
        block6: {
            this.checkLock();
            XmlInfo info = (XmlInfo)this.metadataRegister.get(id, metadataClass);
            if (info != null && info.getURI() != null) {
                String path = PathUtil.convertUrlToAbsolutePath(info.getURI());
                if (path == null) {
                    throw new IllegalStateException();
                }
                this.watchDir.skipOn(info.getURI());
                try {
                    if (FileSystemUtil.removeContentByUri(info.getURI()).booleanValue()) {
                        ConfigId configId = info.getConfigId();
                        this.metadataRegister.remove(configId.getId(), configId.getBaseSourceClass());
                        this.eventBus.publish((N2oEvent)new MetadataRemovedEvent(this, info));
                        break block6;
                    }
                    throw new N2oException("n2o.couldNotDeleteFile").addData(new Object[]{info.getLocalPath()});
                }
                finally {
                    this.watchDir.takeOn(path);
                }
            }
        }
    }

    public void setEventBus(N2oEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setConfigMetadataLocker(ConfigMetadataLocker configMetadataLocker) {
        this.configMetadataLocker = configMetadataLocker;
    }

    public void setPersisterFactory(NamespacePersisterFactory persisterFactory) {
        this.persisterFactory = persisterFactory;
    }

    public void setWatchDir(WatchDir watchDir) {
        this.watchDir = watchDir;
    }

    public void setMetadataRegister(MetadataRegister metadataRegister) {
        this.metadataRegister = metadataRegister;
    }

    public void setMetadataReader(XmlMetadataLoader metadataReader) {
        this.metadataReader = metadataReader;
    }

    public void setMetaModelRegister(SourceTypeRegister metaModelRegister) {
        this.metaModelRegister = metaModelRegister;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public static enum RestoreMode {
        REMOVE,
        REPLACE;

    }
}

