/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader;

import java.io.IOException;
import java.io.InputStream;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.api.reader.SourceLoader;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.N2oConfigConflictException;
import net.n2oapp.framework.config.reader.N2oMetadataReaderException;
import net.n2oapp.framework.config.register.XmlInfo;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XmlMetadataLoader
implements SourceLoader<XmlInfo> {
    private NamespaceReaderFactory elementReaderFactory;
    private MetadataRegister configRegister;

    @Deprecated
    public XmlMetadataLoader(NamespaceReaderFactory elementReaderFactory, MetadataRegister configRegister) {
        this.elementReaderFactory = elementReaderFactory;
        this.configRegister = configRegister;
    }

    public XmlMetadataLoader(NamespaceReaderFactory elementReaderFactory) {
        this.elementReaderFactory = elementReaderFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S extends SourceMetadata> S load(XmlInfo info, String params) {
        Class sourceClass = info.getBaseSourceClass();
        try (InputStream inputStream = FileSystemUtil.getContentAsStream(info.getURI());){
            Object source2 = this.read(info.getId(), inputStream);
            if (!sourceClass.isAssignableFrom(source2.getClass())) {
                throw new MetadataReaderException("read class [" + source2.getClass() + "], but expected [" + sourceClass + "]");
            }
            Object t = source2;
            return (S)t;
        }
        catch (N2oException e) {
            if (!(e.getCause() instanceof JDOMException)) throw e;
            String infoContent = FileSystemUtil.getContentByUri(info.getURI());
            if (!infoContent.contains("<<<<<<< HEAD")) throw e;
            throw new N2oConfigConflictException("n2o.fileHasConflicts");
        }
        catch (Exception e) {
            throw new N2oMetadataReaderException(e, info.getId(), info.getURI(), info.getConfigId().getType());
        }
    }

    public <T extends SourceMetadata> T read(String id, String xml) {
        try {
            return this.read(id, IOUtils.toInputStream((String)xml, (String)"UTF-8"));
        }
        catch (IOException e) {
            throw new N2oException((Throwable)e);
        }
    }

    public <T extends SourceMetadata> T read(String id, InputStream xml) {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(xml);
        }
        catch (IOException | JDOMException e) {
            throw new N2oException("Error reading metadata " + id, e);
        }
        Element root = doc.getRootElement();
        SourceMetadata n2o = (SourceMetadata)this.elementReaderFactory.produce(root).read(root);
        if (n2o == null) {
            throw new MetadataReaderException("Xml Element Reader must return not null object");
        }
        n2o.setId(id);
        return (T)n2o;
    }

    public <T extends SourceMetadata> T read(String id, InputStream xml, Class<T> metadataClass) {
        T n2o = this.read(id, xml);
        if (!metadataClass.isAssignableFrom(n2o.getClass())) {
            throw new MetadataReaderException("read class [" + n2o.getClass() + "], but expected [" + metadataClass + "]");
        }
        return n2o;
    }

    public String readAsString(XmlInfo info) {
        return FileSystemUtil.getContentByUri(info.getURI());
    }

    public void setElementReaderFactory(NamespaceReaderFactory elementReaderFactory) {
        this.elementReaderFactory = elementReaderFactory;
    }
}

