/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.invocation;

import net.n2oapp.framework.api.metadata.global.dao.invocation.java.EjbInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.java.JavaInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.java.SpringInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.Argument;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.reader.invocation.AbstractInvocationReaderV2;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.stereotype.Component;

@Component
public class JavaInvocationReaderV2
extends AbstractInvocationReaderV2<JavaInvocation> {
    public JavaInvocation read(Element element, Namespace namespace) {
        JavaInvocation invocation = (JavaInvocation)ReaderJdomUtil.getChild(element, "spring", new SpringInvocationReader());
        if (invocation == null) {
            invocation = (JavaInvocation)ReaderJdomUtil.getChild(element, "ejb", new EjbInvocationReader());
        }
        if (invocation == null) {
            invocation = new JavaInvocation();
        }
        invocation.setClassName(ReaderJdomUtil.getAttributeString(element, "class"));
        invocation.setMethodName(ReaderJdomUtil.getAttributeString(element, "method"));
        invocation.setArguments(ReaderJdomUtil.getChildren(element, "arguments", "argument", ArgumentElementReader.getInstance()));
        return invocation;
    }

    public Class<JavaInvocation> getElementClass() {
        return JavaInvocation.class;
    }

    public String getElementName() {
        return "java";
    }

    private class EjbInvocationReader
    implements TypedElementReader<EjbInvocation> {
        private EjbInvocationReader() {
        }

        public Class<EjbInvocation> getElementClass() {
            return EjbInvocation.class;
        }

        public EjbInvocation read(Element element) {
            EjbInvocation invocation = new EjbInvocation();
            invocation.setBeanId(ReaderJdomUtil.getAttributeString(element, "bean"));
            invocation.setUri(ReaderJdomUtil.getAttributeString(element, "uri"));
            invocation.setProtocol(ReaderJdomUtil.getAttributeString(element, "protocol"));
            invocation.setApplication(ReaderJdomUtil.getAttributeString(element, "application"));
            invocation.setModule(ReaderJdomUtil.getAttributeString(element, "module"));
            invocation.setDistinct(ReaderJdomUtil.getAttributeString(element, "distinct"));
            invocation.setStatefull(ReaderJdomUtil.getAttributeBoolean(element, "statefull"));
            return invocation;
        }

        public String getElementName() {
            return "ejb";
        }
    }

    private class SpringInvocationReader
    implements TypedElementReader<SpringInvocation> {
        private SpringInvocationReader() {
        }

        public Class<SpringInvocation> getElementClass() {
            return SpringInvocation.class;
        }

        public SpringInvocation read(Element element) {
            SpringInvocation invocation = new SpringInvocation();
            invocation.setBeanId(ReaderJdomUtil.getAttributeString(element, "bean"));
            return invocation;
        }

        public String getElementName() {
            return "spring";
        }
    }

    public static class ArgumentElementReader
    implements TypedElementReader<Argument> {
        private static final ArgumentElementReader instance = new ArgumentElementReader();

        public static ArgumentElementReader getInstance() {
            return instance;
        }

        public Argument read(Element element) {
            Argument argument = new Argument();
            argument.setName(ReaderJdomUtil.getAttributeString(element, "name"));
            argument.setClassName(ReaderJdomUtil.getAttributeString(element, "class"));
            argument.setType(ReaderJdomUtil.getAttributeEnum(element, "type", Argument.Type.class));
            return argument;
        }

        public Class<Argument> getElementClass() {
            return Argument.class;
        }

        public String getElementName() {
            return "argument";
        }
    }
}

