/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.tools;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractAction;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.action.LabelType;
import net.n2oapp.framework.api.metadata.global.view.action.control.RefreshPolity;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.GroupItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.reader.NamespaceReaderFactory;
import net.n2oapp.framework.config.reader.tools.MenuItemConditionReader;
import net.n2oapp.framework.config.reader.tools.PropertiesReaderV1;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;

public class ActionMenuReaderV1 {
    public static final Namespace DEFAULT_EVENT_NAMESPACE_URI = Namespace.getNamespace((String)"http://n2oapp.net/framework/config/schema/n2o-event-1.0");
    private NamespaceReaderFactory readerFactory;

    public void setReaderFactory(NamespaceReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
    }

    public N2oToolbar[] read(Element element) {
        N2oToolbar toolbar = new N2oToolbar();
        Boolean inheritDefault = ReaderJdomUtil.getAttributeBoolean(element, "inherit-default");
        if (inheritDefault != null && inheritDefault.booleanValue()) {
            String[] generate = new String[]{GenerateType.crud.name()};
            toolbar.setGenerate(generate);
        }
        List popupMenus = element.getChildren();
        ArrayList<Object> defaultToolbarItems = new ArrayList<Object>();
        for (Element popupMenu : popupMenus) {
            if (popupMenu.getName().equals("menu-item")) {
                defaultToolbarItems.add(this.getToolbarItem(popupMenu, popupMenu.getNamespace()));
                continue;
            }
            if (!popupMenu.getName().equals("group")) continue;
            defaultToolbarItems.add(this.getGroup(popupMenu));
        }
        if (!defaultToolbarItems.isEmpty()) {
            ToolbarItem[] toolbarItems = new ToolbarItem[defaultToolbarItems.size()];
            toolbar.setItems(defaultToolbarItems.toArray(toolbarItems));
        }
        return new N2oToolbar[]{toolbar};
    }

    private GroupItem getToolbarItem(Element popupMenu, Namespace namespace) {
        N2oSubmenu subMenuItem = this.getSubMenuItem(popupMenu, namespace);
        if (subMenuItem != null) {
            return subMenuItem;
        }
        return this.getButton(popupMenu, namespace);
    }

    private N2oGroup getGroup(Element groupElement) {
        N2oGroup group = new N2oGroup();
        List popupMenus = groupElement.getChildren();
        GroupItem[] items = new GroupItem[popupMenus.size()];
        int i = 0;
        for (Element popupMenu : popupMenus) {
            items[i] = this.getToolbarItem(popupMenu, popupMenu.getNamespace());
            ++i;
        }
        group.setItems(items);
        return group;
    }

    private N2oMenuItem getMenuItem(Element popupMenu, Namespace namespace) {
        N2oMenuItem menuItem = new N2oMenuItem();
        this.readMenuItem(popupMenu, (AbstractMenuItem)menuItem, namespace);
        return menuItem;
    }

    private Element getEventElement(Element menu, Namespace namespace) {
        if (menu.getChildren() == null || menu.getChildren().size() == 0) {
            return null;
        }
        Element event = menu.getChild("invoke-action", namespace);
        if (event == null && (event = menu.getChild("show-modal", namespace)) == null && (event = menu.getChild("show-modal-form", namespace)) == null && (event = menu.getChild("a", namespace)) == null && (event = menu.getChild("open-page", namespace)) == null && (event = menu.getChild("edit", namespace)) == null) {
            event = menu.getChild("go-edit", namespace);
        }
        return event;
    }

    private N2oButton getButton(Element popupMenu, Namespace namespace) {
        N2oButton button = new N2oButton();
        this.readMenuItem(popupMenu, (AbstractMenuItem)button, namespace);
        return button;
    }

    private N2oSubmenu getSubMenuItem(Element popupMenu, Namespace namespace) {
        Element subMenuElement = popupMenu.getChild("sub-menu", namespace);
        if (subMenuElement == null) {
            return null;
        }
        List popupMenus = subMenuElement.getChildren();
        N2oSubmenu subMenu = new N2oSubmenu();
        subMenu.setId(ReaderJdomUtil.getAttributeString(popupMenu, "id"));
        subMenu.setLabel(ReaderJdomUtil.getAttributeString(subMenuElement, "label"));
        subMenu.setType(ReaderJdomUtil.getAttributeEnum(subMenuElement, "type", LabelType.class));
        subMenu.setIcon(ReaderJdomUtil.getAttributeString(subMenuElement, "icon"));
        subMenu.setColor(ReaderJdomUtil.getAttributeString(subMenuElement, "color"));
        subMenu.setDescription(ReaderJdomUtil.getElementString(subMenuElement, "description"));
        N2oMenuItem[] subMenuItems = new N2oMenuItem[popupMenus.size()];
        int i = 0;
        for (Element subPopupMenu : popupMenus) {
            subMenuItems[i] = this.getMenuItem(subPopupMenu, namespace);
            ++i;
        }
        subMenu.setMenuItems(subMenuItems);
        return subMenu;
    }

    private void readMenuItem(Element popupMenu, AbstractMenuItem menuItem, Namespace namespace) {
        Boolean context;
        menuItem.setProperties(PropertiesReaderV1.getInstance().read(popupMenu, namespace));
        menuItem.setId(ReaderJdomUtil.getAttributeString(popupMenu, "id"));
        menuItem.setLabel(ReaderJdomUtil.getAttributeString(popupMenu, "label"));
        menuItem.setType(ReaderJdomUtil.getAttributeEnum(popupMenu, "type", LabelType.class));
        menuItem.setIcon(ReaderJdomUtil.getAttributeString(popupMenu, "icon"));
        menuItem.setColor(ReaderJdomUtil.getAttributeString(popupMenu, "color"));
        menuItem.setDescription(ReaderJdomUtil.getElementString(popupMenu, "description"));
        menuItem.setDefaultAction(ReaderJdomUtil.getAttributeBoolean(popupMenu, "default"));
        menuItem.setPrimary(ReaderJdomUtil.getAttributeBoolean(popupMenu, "primary"));
        menuItem.setVisible(ReaderJdomUtil.getAttributeString(popupMenu, "visible"));
        menuItem.setReadonly(ReaderJdomUtil.getAttributeBoolean(popupMenu, "readonly"));
        menuItem.setKey(ReaderJdomUtil.getAttributeString(popupMenu, "key"));
        menuItem.setBulk(ReaderJdomUtil.getAttributeBoolean(popupMenu, "bulk"));
        menuItem.setValidate(ReaderJdomUtil.getAttributeBoolean(popupMenu, "validate"));
        menuItem.setRefreshPolity(ReaderJdomUtil.getAttributeEnum(popupMenu, "refresh-policy", RefreshPolity.class));
        Element eventElement = this.getEventElement(popupMenu, namespace);
        if (eventElement != null) {
            N2oAbstractAction action = (N2oAbstractAction)this.readerFactory.produce(eventElement, popupMenu.getNamespace(), DEFAULT_EVENT_NAMESPACE_URI).read(eventElement);
            menuItem.setAction((N2oAction)action);
        }
        if ((context = ReaderJdomUtil.getAttributeBoolean(popupMenu, "context")) == null || context.booleanValue()) {
            menuItem.setModel(ReduxModel.RESOLVE);
        } else {
            menuItem.setModel(ReduxModel.FILTER);
        }
        menuItem.setEnablingConditions(ReaderJdomUtil.getChildren(popupMenu, "conditions", "enabling-condition", MenuItemConditionReader.getInstance()));
        menuItem.setVisibilityConditions(ReaderJdomUtil.getChildren(popupMenu, "conditions", "visibility-condition", MenuItemConditionReader.getInstance()));
    }
}

