/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.audit.model;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.n2oapp.framework.config.register.audit.model.N2oConfigMessage;

public class N2oConfigCommit {
    private String id;
    private String content;
    private String author;
    private N2oConfigMessage messagePrefix;
    private String message;
    private Date date;
    private Type type;
    private State state;
    private boolean conflict;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public N2oConfigMessage getMessagePrefix() {
        return this.messagePrefix;
    }

    public void setMessagePrefix(N2oConfigMessage messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public void setConflict(boolean conflict) {
        this.conflict = conflict;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        CREATE("{n2o.audit.created}", N2oConfigMessage.CREATED_PREFIX),
        UPDATE("{n2o.audit.updated}", N2oConfigMessage.UPDATED_PREFIX),
        DELETE("{n2o.audit.deleted}", N2oConfigMessage.DELETED_PREFIX),
        MERGE("{n2o.audit.merge}", N2oConfigMessage.MERGE_PREFIX, N2oConfigMessage.CONFLICT_MERGE_PREFIX),
        COMMIT("{n2o.audit.commit}", N2oConfigMessage.MANUAL_COMMIT, N2oConfigMessage.INIT_COMMIT_PREFIX),
        UPDATE_SYSTEM("{n2o.audit.updating}", N2oConfigMessage.SYSTEM_UPDATE_PREFIX);

        private String description;
        private List<N2oConfigMessage> prefixes;

        private Type(String desc, N2oConfigMessage ... prefix) {
            this.description = desc;
            this.prefixes = Arrays.asList(prefix);
        }

        public String getDescription() {
            return this.description;
        }

        public static Type byPrefix(N2oConfigMessage prefix) {
            if (prefix == null) {
                return null;
            }
            Optional<Type> first = Stream.of(Type.values()).filter(t -> t.prefixes.contains((Object)prefix)).findFirst();
            if (!first.isPresent()) {
                return null;
            }
            return first.get();
        }
    }

    public static enum State {
        CHANGED,
        COMMITED,
        PUSHED;

    }
}

