/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.route;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.api.register.route.RouteRegister;
import net.n2oapp.framework.config.register.route.IncorrectRouteException;
import net.n2oapp.framework.config.register.route.RouteAlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N2oRouteRegister
implements RouteRegister {
    private static final Logger logger = LoggerFactory.getLogger(N2oRouteRegister.class);
    private final SortedMap<RouteInfoKey, CompileContext> register = new ConcurrentSkipListMap<RouteInfoKey, CompileContext>();

    public void addRoute(String urlPattern, CompileContext<? extends Compiled, ?> context) {
        RouteInfoKey key = new RouteInfoKey(urlPattern, context.getCompiledClass());
        if (!key.getUrlMatching().startsWith("/")) {
            throw new IncorrectRouteException(key.getUrlMatching());
        }
        if (this.register.containsKey(key) && !((CompileContext)this.register.get(key)).equals(context)) {
            throw new RouteAlreadyExistsException(urlPattern, context.getCompiledClass());
        }
        this.register.put(key, context);
        logger.info(String.format("Register route: '%s' to [%s]", context, urlPattern));
    }

    public Iterator<Map.Entry<RouteInfoKey, CompileContext>> iterator() {
        return this.register.entrySet().iterator();
    }

    public void clear(String startUrlMatching) {
        this.register.keySet().removeIf(s -> s.getUrlMatching().startsWith(startUrlMatching));
    }
}

