/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.n2oapp.engine.factory.integration.spring.OverrideBean;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.factory.MetadataFactory;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.scan.MetadataScanner;
import net.n2oapp.framework.api.register.scan.MetadataScannerFactory;
import net.n2oapp.framework.config.factory.AwareFactorySupport;
import net.n2oapp.framework.config.register.scanner.OverrideInfoScanner;

public class N2oMetadataScannerFactory
implements MetadataFactory<MetadataScanner>,
MetadataScannerFactory,
MetadataEnvironmentAware {
    private List<MetadataScanner> scanners;

    public N2oMetadataScannerFactory() {
        this.scanners = new ArrayList<MetadataScanner>();
    }

    public N2oMetadataScannerFactory(Map<String, MetadataScanner> scanners) {
        this.scanners = new ArrayList(OverrideBean.removeOverriddenBeans(scanners).values());
    }

    public List<? extends SourceInfo> scan() {
        LinkedList<MetadataScanner> sorted = new LinkedList<MetadataScanner>();
        for (MetadataScanner scanner : this.scanners) {
            if (scanner instanceof OverrideInfoScanner) {
                sorted.addLast(scanner);
                continue;
            }
            sorted.addFirst(scanner);
        }
        ArrayList infoList = new ArrayList();
        for (MetadataScanner scanner : sorted) {
            infoList.addAll(scanner.scan());
        }
        return infoList;
    }

    public N2oMetadataScannerFactory add(MetadataScanner ... scanners) {
        this.scanners.addAll(Arrays.asList(scanners));
        return this;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.scanners.forEach(o -> AwareFactorySupport.enrich(o, environment));
    }
}

