/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.scanner;

import java.util.List;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.register.InfoConstructor;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.scanner.OverrideInfoScanner;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.util.FileSystemUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FolderInfoScanner
implements OverrideInfoScanner<InfoConstructor>,
MetadataEnvironmentAware {
    private String configPath;
    private SourceTypeRegister sourceTypeRegister;

    public FolderInfoScanner(@Value(value="${n2o.config.path}") String configPath) {
        this.configPath = configPath;
    }

    public List<InfoConstructor> scan() {
        String uri = PathUtil.convertRootPathToUrl(this.configPath);
        String xmlPattern = PathUtil.convertUrlToPattern(uri, "xml", "*.*");
        return RegisterUtil.collectInfo(FileSystemUtil.getNodesByLocationPattern(xmlPattern), n -> RegisterUtil.createFolderInfo(n, this.sourceTypeRegister));
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.sourceTypeRegister = environment.getSourceTypeRegister();
    }
}

