/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.filters.Filter;
import net.n2oapp.criteria.filters.FilterReducer;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.criteria.filters.Result;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.data.ActionInvocationEngine;
import net.n2oapp.framework.api.data.ArgumentsInvocationEngine;
import net.n2oapp.framework.api.data.CriteriaConstructor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.data.QueryExceptionHandler;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.engine.data.N2oCriteriaConstructor;
import net.n2oapp.framework.engine.data.N2oInvocationFactory;
import net.n2oapp.framework.engine.exception.N2oFoundMoreThanOneRecordException;
import net.n2oapp.framework.engine.exception.N2oRecordNotFoundException;
import net.n2oapp.framework.engine.util.InvocationParametersMapping;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class N2oQueryProcessor
implements QueryProcessor,
MetadataEnvironmentAware,
ApplicationContextAware {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private ContextProcessor contextProcessor;
    private N2oInvocationFactory invocationFactory;
    private CriteriaConstructor criteriaConstructor = new N2oCriteriaConstructor(false);
    private DomainProcessor domainProcessor;
    private QueryExceptionHandler exceptionHandler;
    private ApplicationContext applicationContext;
    private boolean pageStartsWith0;

    public N2oQueryProcessor(N2oInvocationFactory invocationFactory, QueryExceptionHandler exceptionHandler) {
        this.invocationFactory = invocationFactory;
        this.exceptionHandler = exceptionHandler;
    }

    public CollectionPage<DataSet> execute(CompiledQuery query, N2oPreparedCriteria criteria) {
        if (criteria.getSize() == 1) {
            return this.executeOneSizeQuery(query, criteria);
        }
        return this.executePageQuery(this.findListSelection(query, criteria), query, criteria);
    }

    public Integer executeCount(CompiledQuery query, N2oPreparedCriteria criteria) {
        Object result;
        this.resolveRestriction(query, criteria);
        this.addDefaultFilters(query, criteria);
        N2oQuery.Selection selection = this.findCountSelection(query, criteria);
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(selection.getInvocation().getClass());
        if (engine instanceof ArgumentsInvocationEngine) {
            try {
                result = ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)selection.getInvocation(), InvocationParametersMapping.prepareArgsForQuery((N2oArgumentsInvocation)selection.getInvocation(), query, criteria, this.criteriaConstructor, this.domainProcessor));
            }
            catch (Exception e) {
                throw this.exceptionHandler.handle(query, criteria, e);
            }
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        InvocationParametersMapping.prepareMapForQuery(map, query, criteria);
        try {
            result = engine.invoke(selection.getInvocation(), map);
        }
        catch (Exception e) {
            throw this.exceptionHandler.handle(query, criteria, e);
        }
        return MappingProcessor.outMap(result, selection.getCountMapping(), Integer.class);
    }

    public CollectionPage<DataSet> executeOneSizeQuery(CompiledQuery query, N2oPreparedCriteria criteria) {
        criteria.setSize(2);
        criteria.setCount(Integer.valueOf(2));
        N2oQuery.Selection selection = this.findUniqueSelection(query, criteria);
        Object result = this.executeQuery(selection, query, criteria);
        criteria.setSize(1);
        if (selection.getType().equals((Object)N2oQuery.Selection.Type.list)) {
            CollectionPage<DataSet> page = this.preparePageResult(result, query, selection, criteria);
            if (page.getCollection() == null || page.getCollection().size() == 0) {
                throw new N2oRecordNotFoundException();
            }
            if (page.getCollection().size() != 1) {
                throw new N2oFoundMoreThanOneRecordException();
            }
            return page;
        }
        if (selection.getType().equals((Object)N2oQuery.Selection.Type.unique)) {
            DataSet single = this.prepareSingleResult(result, query, selection);
            if (single.isEmpty()) {
                throw new N2oRecordNotFoundException();
            }
            return new CollectionPage(1, Collections.singletonList(single), (Criteria)criteria);
        }
        throw new UnsupportedOperationException();
    }

    private N2oQuery.Selection findCountSelection(CompiledQuery query, N2oPreparedCriteria criteria) {
        Set<String> filterFields = this.getFilterIds(query, criteria);
        N2oQuery.Selection selection = this.chooseSelection(query.getCounts(), filterFields, query.getId());
        if (selection == null) {
            throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d <count> \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0439 \u0434\u043b\u044f \u043f\u0430\u0434\u0436\u0438\u043d\u0430\u0446\u0438\u0438", query.getId()));
        }
        return selection;
    }

    private N2oQuery.Selection findUniqueSelection(CompiledQuery query, N2oPreparedCriteria criteria) {
        this.resolveRestriction(query, criteria);
        this.addDefaultFilters(query, criteria);
        Set<String> filterFields = this.getFilterIds(query, criteria);
        N2oQuery.Selection selection = this.chooseSelection(query.getUniques(), filterFields, query.getId());
        if (selection != null) {
            return selection;
        }
        selection = this.chooseSelection(query.getLists(), filterFields, query.getId());
        if (selection == null) {
            throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d <unique> \u0437\u0430\u043f\u0440\u043e\u0441", query.getId()));
        }
        return selection;
    }

    private N2oQuery.Selection findListSelection(CompiledQuery query, N2oPreparedCriteria criteria) {
        this.resolveRestriction(query, criteria);
        this.addDefaultFilters(query, criteria);
        Set<String> filterFields = this.getFilterIds(query, criteria);
        N2oQuery.Selection selection = this.chooseSelection(query.getLists(), filterFields, query.getId());
        if (selection == null) {
            throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d <list> \u0437\u0430\u043f\u0440\u043e\u0441", query.getId()));
        }
        return selection;
    }

    private Set<String> getFilterIds(CompiledQuery query, N2oPreparedCriteria criteria) {
        return criteria.getRestrictions() == null ? Collections.emptySet() : criteria.getRestrictions().stream().map(r -> query.getFilterFieldId(r.getFieldId(), r.getType())).collect(Collectors.toSet());
    }

    private Object executeQuery(N2oQuery.Selection selection, CompiledQuery query, N2oPreparedCriteria criteria) {
        Object result;
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(selection.getInvocation().getClass());
        if (engine instanceof ArgumentsInvocationEngine) {
            try {
                result = ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)selection.getInvocation(), InvocationParametersMapping.prepareArgsForQuery((N2oArgumentsInvocation)selection.getInvocation(), query, criteria, this.criteriaConstructor, this.domainProcessor));
            }
            catch (Exception e) {
                throw this.exceptionHandler.handle(query, criteria, e);
            }
        } else if (engine instanceof MapInvocationEngine) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            InvocationParametersMapping.prepareMapForQuery(map, query, criteria);
            InvocationParametersMapping.prepareMapForPage(map, criteria, this.pageStartsWith0);
            try {
                result = engine.invoke(selection.getInvocation(), map);
            }
            catch (Exception e) {
                throw this.exceptionHandler.handle(query, criteria, e);
            }
        } else {
            throw new UnsupportedOperationException("Engine invocation must be inherited from ArgumentsInvocationEngine or MapInvocationEngine");
        }
        return result;
    }

    private CollectionPage<DataSet> executePageQuery(N2oQuery.Selection selection, CompiledQuery query, N2oPreparedCriteria criteria) {
        if (criteria != null && criteria.getRestrictions() != null) {
            Set restrictionFieldIds = criteria.getRestrictions().stream().map(r -> r.getFieldId()).collect(Collectors.toSet());
            for (String fieldId : restrictionFieldIds) {
                if (!this.reduceFiltersByField(criteria, fieldId)) continue;
                return new CollectionPage(0, Collections.emptyList(), (Criteria)criteria);
            }
        }
        Object result = this.executeQuery(selection, query, criteria);
        CollectionPage<DataSet> page = this.preparePageResult(result, query, selection, criteria);
        this.addIdIfNotPresent(query, page);
        return page;
    }

    private boolean reduceFiltersByField(N2oPreparedCriteria criteria, String fieldId) {
        List restrictionsByField = criteria.getRestrictions(fieldId);
        if (restrictionsByField.size() > 1) {
            ArrayList<Filter> resFilters = new ArrayList<Filter>();
            resFilters.add((Filter)restrictionsByField.get(0));
            for (int i = 1; i < restrictionsByField.size(); ++i) {
                boolean notMergeable = false;
                for (Filter result2 : resFilters) {
                    Result reduceResult = FilterReducer.reduce((Filter)result2, (Filter)((Filter)restrictionsByField.get(i)));
                    if (reduceResult.isSuccess()) {
                        resFilters.remove(result2);
                        resFilters.add(reduceResult.getResultFilter());
                        notMergeable = false;
                        break;
                    }
                    if (reduceResult.getType().equals((Object)Result.Type.notMergeable)) {
                        notMergeable = true;
                        continue;
                    }
                    return true;
                }
                if (!notMergeable) continue;
                resFilters.add((Filter)restrictionsByField.get(i));
            }
            criteria.removeFilterForField(fieldId);
            resFilters.forEach(result -> criteria.addRestriction(new Restriction(fieldId, result)));
        }
        return false;
    }

    private void addDefaultFilters(CompiledQuery query, N2oPreparedCriteria criteria) {
        for (Map.Entry entry : query.getFiltersMap().entrySet()) {
            for (N2oQuery.Filter filter : ((Map)entry.getValue()).values()) {
                Object value;
                if (filter.getCompiledDefaultValue() == null || criteria.containsRestriction((String)entry.getKey()) || (value = this.prepareValue(filter.getCompiledDefaultValue(), filter)) == null) continue;
                Restriction defaultRestriction = new Restriction((String)entry.getKey(), value, filter.getType());
                criteria.addRestriction(defaultRestriction);
            }
        }
    }

    private Object prepareValue(Object value, N2oQuery.Filter filter) {
        Object result = value;
        result = this.contextProcessor.resolve(result);
        result = this.domainProcessor.deserialize(result, filter == null ? null : filter.getDomain());
        result = InvocationParametersMapping.normalizeValue(result, filter == null ? null : filter.getNormalize(), null, parser, (BeanFactory)this.applicationContext);
        return result;
    }

    private DataSet prepareSingleResult(Object res, CompiledQuery query, N2oQuery.Selection selection) {
        Object result = MappingProcessor.outMap(res, selection.getResultMapping(), Object.class);
        return this.mapFields(result, query.getDisplayFields());
    }

    private CollectionPage<DataSet> preparePageResult(Object res, CompiledQuery query, N2oQuery.Selection selection, N2oPreparedCriteria criteria) {
        Collection result = MappingProcessor.outMap(res, selection.getResultMapping(), Collection.class);
        List<DataSet> content = result.stream().map(obj -> this.mapFields(obj, query.getDisplayFields())).collect(Collectors.toList());
        return this.getPage(content, criteria, () -> {
            if (criteria.getSize() == 1) {
                return 1;
            }
            if (selection.getCountMapping() == null) {
                return this.executeCount(query, criteria);
            }
            return MappingProcessor.outMap(res, selection.getCountMapping(), Integer.class);
        });
    }

    private N2oQuery.Selection chooseSelection(N2oQuery.Selection[] selections, Set<String> filterFields, String queryId) {
        if (selections == null) {
            return null;
        }
        if (filterFields == null) {
            N2oQuery.Selection result = this.findBaseSelection(selections);
            if (result == null) {
                throw new N2oException(String.format("\u0412 %s.query.xml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u0431\u0435\u0437 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432", queryId));
            }
            return result;
        }
        return this.findSelectionByFilters(selections, filterFields);
    }

    private N2oQuery.Selection findBaseSelection(N2oQuery.Selection[] lists) {
        for (N2oQuery.Selection selection : lists) {
            if (selection.getFilters() != null && !selection.getFilters().isEmpty()) continue;
            return selection;
        }
        return null;
    }

    private N2oQuery.Selection findSelectionByFilters(N2oQuery.Selection[] selections, Set<String> filterFields) {
        for (N2oQuery.Selection selection : selections) {
            if (selection.getFilters() == null || selection.getFilters().isEmpty()) continue;
            HashSet filters = new HashSet();
            Collections.addAll(filters, selection.getFilters().split("\\s*,\\s*"));
            if (filterFields.size() != filters.size()) continue;
            filterFields.forEach(filters::remove);
            if (!filters.isEmpty()) continue;
            return selection;
        }
        return this.findBaseSelection(selections);
    }

    private void resolveRestriction(CompiledQuery query, N2oPreparedCriteria criteria) {
        HashSet<String> restrictionsForRemove = null;
        for (Restriction restriction : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(restriction.getFieldId())).get(restriction.getType());
            Object value = this.prepareValue(restriction.getValue(), filter);
            if (value != null) {
                restriction.setValue(value);
                continue;
            }
            if (FilterType.Arity.nullary == restriction.getType().arity) {
                restriction.setValue((Object)Boolean.TRUE);
                continue;
            }
            if (restrictionsForRemove == null) {
                restrictionsForRemove = new HashSet<String>();
            }
            restrictionsForRemove.add(restriction.getFieldId());
        }
        if (restrictionsForRemove != null) {
            restrictionsForRemove.forEach(arg_0 -> ((N2oPreparedCriteria)criteria).removeFilterForField(arg_0));
        }
    }

    private void addIdIfNotPresent(CompiledQuery query, CollectionPage<DataSet> collectionPage) {
        if (!query.getFieldsMap().containsKey("id")) {
            return;
        }
        if (!((N2oQuery.Field)query.getFieldsMap().get("id")).getNoDisplay().booleanValue()) {
            return;
        }
        int i = 1;
        for (DataSet dataSet : collectionPage.getCollection()) {
            dataSet.put("id", (Object)i++);
        }
    }

    private DataSet mapFields(Object entry, List<N2oQuery.Field> fields) {
        DataSet resultDataSet = new DataSet();
        fields.forEach(f -> MappingProcessor.outMap(resultDataSet, entry, f.getId(), f.getSelectMapping(), f.getSelectDefaultValue(), this.contextProcessor));
        return this.normalizeDataSet(resultDataSet, fields);
    }

    private DataSet normalizeDataSet(DataSet dataSet, List<N2oQuery.Field> fields) {
        for (N2oQuery.Field f : fields) {
            if (f.getNormalize() == null) continue;
            Object obj = dataSet.get((Object)f.getId());
            obj = this.contextProcessor.resolve(obj);
            dataSet.put(f.getId(), InvocationParametersMapping.normalizeValue(obj, f.getNormalize(), dataSet, parser, (BeanFactory)this.applicationContext));
        }
        return dataSet;
    }

    private CollectionPage<DataSet> getPage(Collection<DataSet> content, N2oPreparedCriteria criteria, Supplier<Integer> totalSupplier) {
        if (criteria.getFirst() == 0) {
            if (criteria.getSize() > content.size()) {
                return new CollectionPage(content.size(), content, (Criteria)criteria);
            }
            return new CollectionPage(totalSupplier.get().intValue(), content, (Criteria)criteria);
        }
        if (content.size() != 0 && criteria.getSize() > content.size()) {
            return new CollectionPage(criteria.getFirst() + content.size(), content, (Criteria)criteria);
        }
        return new CollectionPage(totalSupplier.get().intValue(), content, (Criteria)criteria);
    }

    public void setPageStartsWith0(boolean pageStartsWith0) {
        this.pageStartsWith0 = pageStartsWith0;
    }

    public void setCriteriaResolver(CriteriaConstructor criteriaResolver) {
        this.criteriaConstructor = criteriaResolver;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.contextProcessor = environment.getContextProcessor();
        this.domainProcessor = environment.getDomainProcessor();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

