/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.rest.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;

public class CustomDateDeserializer
extends StdDeserializer<Object> {
    private String[] patterns;
    private Set<String> exclusions;
    private final JsonDeserializer<?> defaultDeserializer;

    public CustomDateDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(Object.class);
        this.defaultDeserializer = defaultDeserializer;
    }

    public Object deserialize(JsonParser jsonparser, DeserializationContext context) throws IOException {
        String jsonString = jsonparser.getText();
        if (this.patterns == null || this.exclude(jsonparser.getCurrentName())) {
            return this.defaultDeserializer.deserialize(jsonparser, context);
        }
        try {
            return DateUtils.parseDateStrictly((String)jsonString, (String[])this.patterns);
        }
        catch (ParseException e) {
            return this.defaultDeserializer.deserialize(jsonparser, context);
        }
    }

    private boolean exclude(String key) {
        return this.exclusions != null && key != null && this.exclusions.contains(key);
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public void setExclusions(String[] exclusions) {
        this.exclusions = new HashSet<String>(Arrays.asList(exclusions));
    }
}

