/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.DataSetUtil;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.data.ActionInvocationEngine;
import net.n2oapp.framework.api.data.ArgumentsInvocationEngine;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.engine.data.N2oInvocationFactory;
import net.n2oapp.framework.engine.util.ArgumentsInvocationUtil;
import net.n2oapp.framework.engine.util.MapInvocationUtil;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class N2oInvocationProcessor
implements InvocationProcessor,
MetadataEnvironmentAware,
ApplicationContextAware {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private N2oInvocationFactory invocationFactory;
    private ContextProcessor contextProcessor;
    private DomainProcessor domainProcessor;
    private ApplicationContext applicationContext;

    public N2oInvocationProcessor(N2oInvocationFactory invocationFactory) {
        this.invocationFactory = invocationFactory;
    }

    public DataSet invoke(N2oInvocation invocation, DataSet inDataSet, Collection<AbstractParameter> inParameters, Collection<ObjectSimpleField> outParameters) {
        Map<String, FieldMapping> inMapping = MappingProcessor.extractInFieldMapping(inParameters);
        Map<String, String> outMapping = MappingProcessor.extractOutFieldMapping(outParameters);
        this.prepareInValues(inParameters, inDataSet);
        DataSet resolvedInDataSet = this.resolveInValuesMapping(inMapping, inParameters, inDataSet);
        DataSet resultDataSet = this.invoke(invocation, resolvedInDataSet, inMapping, outMapping);
        this.resolveOutValues(outParameters, resultDataSet);
        inDataSet.merge(resultDataSet);
        return inDataSet;
    }

    private DataSet invoke(N2oInvocation invocation, DataSet inDataSet, Map<String, FieldMapping> inMapping, Map<String, String> outMapping) {
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(invocation.getClass());
        Object result = engine instanceof ArgumentsInvocationEngine ? ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)invocation, ArgumentsInvocationUtil.mapToArgs((N2oArgumentsInvocation)invocation, inDataSet, inMapping, this.domainProcessor)) : engine.invoke(invocation, MapInvocationUtil.mapToMap(inDataSet, inMapping));
        return DataSetUtil.extract((Object)result, outMapping);
    }

    protected void resolveOutValues(Collection<ObjectSimpleField> invocationParameters, DataSet resultDataSet) {
        if (invocationParameters == null) {
            return;
        }
        for (ObjectSimpleField parameter : invocationParameters) {
            Object value = resultDataSet.get((Object)parameter.getId());
            if (value == null && parameter.getDefaultValue() != null && parameter.getMapping() == null) {
                value = this.contextProcessor.resolve((Object)parameter.getDefaultValue());
            }
            if (value != null && parameter.getNormalize() != null) {
                value = MappingProcessor.normalizeValue(value, parameter.getNormalize(), resultDataSet, parser, (BeanFactory)this.applicationContext);
            }
            resultDataSet.put(parameter.getId(), value);
        }
    }

    protected DataSet resolveInValuesMapping(Map<String, FieldMapping> mappingMap, Collection<AbstractParameter> invocationParameters, DataSet inDataSet) {
        if (invocationParameters == null) {
            return inDataSet;
        }
        for (AbstractParameter parameter : invocationParameters) {
            if (this.isMappingEnabled(parameter, inDataSet)) {
                if (!(parameter instanceof ObjectReferenceField) || ((ObjectReferenceField)parameter).getFields() == null) continue;
                ObjectReferenceField refParameter = (ObjectReferenceField)parameter;
                if (parameter.getClass().equals(ObjectReferenceField.class)) {
                    inDataSet.put(parameter.getId(), (Object)this.resolveInValuesMapping(mappingMap.get(parameter.getId()).getChildMapping(), Arrays.asList(refParameter.getFields()), (DataSet)inDataSet.get((Object)parameter.getId())));
                } else {
                    for (Object dataSet : (Collection)inDataSet.get((Object)parameter.getId())) {
                        ((DataSet)dataSet).putAll((Map)this.resolveInValuesMapping(mappingMap.get(parameter.getId()).getChildMapping(), Arrays.asList(refParameter.getFields()), (DataSet)dataSet));
                    }
                }
                if (refParameter.getEntityClass() == null) continue;
                MappingProcessor.mapParameter(refParameter, inDataSet);
                continue;
            }
            mappingMap.remove(parameter.getId());
        }
        return this.normalize(invocationParameters, inDataSet);
    }

    private void prepareInValues(Collection<AbstractParameter> parameters, DataSet inDataSet) {
        for (AbstractParameter parameter : parameters) {
            if (parameter instanceof ObjectSimpleField) {
                ObjectSimpleField simpleField = (ObjectSimpleField)parameter;
                Object value = inDataSet.get((Object)simpleField.getId());
                if (value == null) {
                    value = simpleField.getDefaultValue();
                }
                value = this.contextProcessor.resolve(value);
                value = this.domainProcessor.deserialize(value, simpleField.getDomain());
                inDataSet.put(simpleField.getId(), value);
                continue;
            }
            if (!(parameter instanceof ObjectReferenceField)) continue;
            if (parameter.getClass().equals(ObjectReferenceField.class)) {
                this.prepareInValues(Arrays.asList(((ObjectReferenceField)parameter).getFields()), (DataSet)inDataSet.get((Object)parameter.getId()));
                continue;
            }
            for (Object dataSet : (Collection)inDataSet.get((Object)parameter.getId())) {
                this.prepareInValues(Arrays.asList(((ObjectReferenceField)parameter).getFields()), (DataSet)dataSet);
            }
        }
    }

    private DataSet normalize(Collection<AbstractParameter> invocationParameters, DataSet inDataSet) {
        DataSet copiedDataSet = new DataSet((Map)inDataSet);
        for (AbstractParameter parameter : invocationParameters) {
            Object value;
            if (!(parameter instanceof ObjectSimpleField) || ((ObjectSimpleField)parameter).getNormalize() == null || (value = inDataSet.get((Object)parameter.getId())) == null) continue;
            value = MappingProcessor.normalizeValue(value, ((ObjectSimpleField)parameter).getNormalize(), inDataSet, parser, (BeanFactory)this.applicationContext);
            copiedDataSet.put(parameter.getId(), value);
        }
        return copiedDataSet;
    }

    private boolean isMappingEnabled(AbstractParameter inParam, DataSet inDataSet) {
        return inParam.getEnabled() == null || ScriptProcessor.evalForBoolean((String)inParam.getEnabled(), (DataSet)inDataSet);
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.contextProcessor = environment.getContextProcessor();
        this.domainProcessor = environment.getDomainProcessor();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

