/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.DataSetUtil;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.OperationExceptionHandler;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.local.CompiledObject;

public class N2oOperationProcessor {
    private InvocationProcessor invocationProcessor;
    private OperationExceptionHandler exceptionHandler;

    public N2oOperationProcessor(InvocationProcessor invocationProcessor, OperationExceptionHandler exceptionHandler) {
        this.invocationProcessor = invocationProcessor;
        this.exceptionHandler = exceptionHandler;
    }

    public DataSet invoke(CompiledObject.Operation action, DataSet inDataSet) {
        this.validateRequiredFields(action.getInParametersMap().values(), inDataSet);
        return this.invoke(action, inDataSet, action.getInParametersMap().values(), action.getOutParametersMap().values());
    }

    public DataSet invoke(CompiledObject.Operation operation, DataSet inDataSet, Collection<AbstractParameter> inParameters, Collection<ObjectSimpleField> outParameters) {
        try {
            return this.invocationProcessor.invoke(operation.getInvocation(), inDataSet, inParameters, outParameters);
        }
        catch (Exception e) {
            inDataSet.putAll((Map)this.getFailOutParameters(operation.getFailOutParametersMap(), e));
            throw this.exceptionHandler.handle(operation, inDataSet, e);
        }
    }

    private DataSet getFailOutParameters(Map<String, ObjectSimpleField> failOutParameters, Exception e) {
        if (failOutParameters.isEmpty()) {
            return new DataSet();
        }
        Map<String, String> failOutParamsMapping = failOutParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ObjectSimpleField)entry.getValue()).getMapping()));
        return DataSetUtil.extract((Object)e, failOutParamsMapping);
    }

    private void validateRequiredFields(Collection<AbstractParameter> inParameters, DataSet inDataSet) {
        if (inParameters == null || inParameters.isEmpty()) {
            return;
        }
        List requiredFields = inParameters.stream().filter(in -> in.getRequired() != null && in.getRequired() != false).map(AbstractParameter::getId).collect(Collectors.toList());
        boolean allMatch = requiredFields.stream().allMatch(arg_0 -> ((DataSet)inDataSet).containsKey(arg_0));
        if (!allMatch) {
            throw new IllegalStateException(String.format("Action required fields[%s]", String.join((CharSequence)",", requiredFields)));
        }
    }
}

