/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.modules;

import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.processing.DataProcessing;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.ui.RequestInfo;
import net.n2oapp.framework.api.ui.ResponseInfo;

public class ResponseTimeProcessing
implements DataProcessing {
    private static final String REQUEST_BEGIN_TIME_NAME_DEFAULT = "N2O_DATA_REQUEST_BEGIN_TIME";
    private String requestBeginTimeName;
    private String responseEndTimeName;
    private String responseDeltaTimeName;

    public void processAction(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.setRequestTime((RequestInfo)requestInfo);
    }

    public void processActionResult(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.setResponseTime((RequestInfo)requestInfo, (ResponseInfo)responseInfo);
    }

    public void processActionError(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.setResponseTime((RequestInfo)requestInfo, (ResponseInfo)responseInfo);
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        this.setRequestTime((RequestInfo)requestInfo);
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        this.setResponseTime((RequestInfo)requestInfo, (ResponseInfo)responseInfo);
    }

    public void processQueryError(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, N2oException exception) {
        this.setResponseTime((RequestInfo)requestInfo, (ResponseInfo)responseInfo);
    }

    private void setRequestTime(RequestInfo requestInfo) {
        requestInfo.addAttribute(this.getBeginTimeAttributeName(), (Object)System.currentTimeMillis());
    }

    private String getBeginTimeAttributeName() {
        return this.requestBeginTimeName != null ? this.requestBeginTimeName : REQUEST_BEGIN_TIME_NAME_DEFAULT;
    }

    private void setResponseTime(RequestInfo requestInfo, ResponseInfo responseInfo) {
        Object beginTime = requestInfo.getAttribute(this.getBeginTimeAttributeName());
        if (beginTime != null) {
            long endTime = System.currentTimeMillis();
            if (this.requestBeginTimeName != null) {
                responseInfo.addAttribute(this.requestBeginTimeName, beginTime);
            }
            if (this.responseEndTimeName != null) {
                responseInfo.addAttribute(this.responseEndTimeName, (Object)endTime);
            }
            if (this.responseDeltaTimeName != null) {
                responseInfo.addAttribute(this.responseDeltaTimeName, (Object)(endTime - (Long)beginTime));
            }
        }
    }

    public void setRequestBeginTimeName(String requestBeginTimeName) {
        this.requestBeginTimeName = requestBeginTimeName;
    }

    public void setResponseDeltaTimeName(String responseDeltaTimeName) {
        this.responseDeltaTimeName = responseDeltaTimeName;
    }

    public void setResponseEndTimeName(String responseEndTimeName) {
        this.responseEndTimeName = responseEndTimeName;
    }
}

