/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataList;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class MapInvocationUtil {
    private static final ExpressionParser writeParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final Predicate<String> MAPPING_PATTERN = Pattern.compile("\\[.+]").asPredicate();
    private static final String KEY_ERROR = "%s -> %s";

    public static Map<String, Object> mapToMap(DataSet dataSet, Map<String, FieldMapping> mapping) {
        MapInvocationUtil.validateMapping(mapping);
        DataSet result = new DataSet();
        for (Map.Entry<String, FieldMapping> map : mapping.entrySet()) {
            Expression expression;
            Object data = dataSet.get((Object)map.getKey());
            if (map.getValue() != null) {
                expression = writeParser.parseExpression((String)(map.getValue().getMapping() != null ? map.getValue().getMapping() : "['" + map.getKey() + "']"));
                if (map.getValue().getChildMapping() != null) {
                    if (data instanceof Collection) {
                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                        for (Object obj : (DataList)data) {
                            list.add(MapInvocationUtil.mapToMap((DataSet)obj, map.getValue().getChildMapping()));
                        }
                        expression.setValue((Object)result, list);
                        continue;
                    }
                    if (!(data instanceof DataSet)) continue;
                    expression.setValue((Object)result, MapInvocationUtil.mapToMap((DataSet)data, map.getValue().getChildMapping()));
                    continue;
                }
                expression.setValue((Object)result, data);
                continue;
            }
            expression = writeParser.parseExpression("['" + map.getKey() + "']");
            expression.setValue((Object)result, data);
        }
        return result;
    }

    private static void validateMapping(Map<String, FieldMapping> mapping) {
        String errorMapping = mapping.entrySet().stream().filter(e -> e.getValue() != null && ((FieldMapping)e.getValue()).getMapping() != null).filter(e -> !MAPPING_PATTERN.test(((FieldMapping)e.getValue()).getMapping())).map(e -> String.format(KEY_ERROR, e.getKey(), ((FieldMapping)e.getValue()).getMapping())).collect(Collectors.joining(", "));
        if (!errorMapping.isEmpty()) {
            throw new IllegalArgumentException("Not valid mapping: " + errorMapping);
        }
    }
}

