/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.FieldMapping;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectListField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class MappingProcessor {
    private static final ExpressionParser writeParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final ExpressionParser readParser = new SpelExpressionParser(new SpelParserConfiguration(false, false));

    public static void inMap(Object target, String mapping, Object value) {
        Expression expression = writeParser.parseExpression(mapping);
        if (target != null) {
            expression.setValue(target, value);
        }
    }

    public static <T> T outMap(Object target, String mapping, Class<T> clazz) {
        Object result;
        if (mapping != null) {
            Expression expression = readParser.parseExpression(mapping);
            result = expression.getValue(target, clazz);
        } else {
            result = target;
        }
        if (clazz != null && result == null) {
            throw new N2oException("Expected is " + clazz + ", but actual is null");
        }
        if (clazz != null && !clazz.isAssignableFrom(result.getClass())) {
            throw new N2oException("Expected is " + clazz + ", but actual is " + result.getClass());
        }
        return (T)result;
    }

    public static void outMap(DataSet target, Object value, String fieldId, String mapping, Object defaultValue, ContextProcessor contextProcessor) {
        Expression expression = readParser.parseExpression(mapping);
        Object obj = expression.getValue(value);
        target.put(fieldId, obj == null ? contextProcessor.resolve(defaultValue) : obj);
    }

    public static void mapParameter(ObjectReferenceField parameter, DataSet dataSet) {
        Object data = dataSet.get((Object)parameter.getId());
        if (data == null) {
            return;
        }
        if (parameter.getClass().equals(ObjectReferenceField.class)) {
            dataSet.put(parameter.getId(), MappingProcessor.mapChildParameters(parameter, (DataSet)data));
        } else {
            AbstractCollection collection = parameter instanceof ObjectListField ? new ArrayList() : new HashSet();
            for (Object item : (Collection)data) {
                collection.add(MappingProcessor.mapChildParameters(parameter, (DataSet)item));
            }
            dataSet.put(parameter.getId(), collection);
        }
    }

    public static Object mapChildParameters(ObjectReferenceField parameter, DataSet dataSet) {
        Object instance;
        try {
            instance = Class.forName(parameter.getEntityClass()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new N2oException((Throwable)e);
        }
        for (AbstractParameter childParam : parameter.getFields()) {
            String target = childParam.getMapping() != null ? childParam.getMapping() : childParam.getId();
            writeParser.parseExpression(target).setValue(instance, dataSet.get((Object)childParam.getId()));
        }
        return instance;
    }

    public static Map<String, String> extractOutFieldMapping(Collection<ObjectSimpleField> parameters) {
        LinkedHashMap<String, String> mappingMap = new LinkedHashMap<String, String>();
        if (parameters != null) {
            for (ObjectSimpleField parameter : parameters) {
                mappingMap.put(parameter.getId(), parameter.getMapping());
            }
        }
        return mappingMap;
    }

    public static Map<String, FieldMapping> extractInFieldMapping(Collection<AbstractParameter> parameters) {
        LinkedHashMap<String, FieldMapping> mappingMap = new LinkedHashMap<String, FieldMapping>();
        if (parameters != null) {
            for (AbstractParameter parameter : parameters) {
                FieldMapping mapping = new FieldMapping(parameter.getMapping());
                if (parameter instanceof ObjectReferenceField && ((ObjectReferenceField)parameter).getFields() != null) {
                    mapping.setChildMapping(MappingProcessor.extractInFieldMapping(Arrays.asList(((ObjectReferenceField)parameter).getFields())));
                }
                mappingMap.put(parameter.getId(), mapping);
            }
        }
        return mappingMap;
    }

    public static Object normalizeValue(Object value, String normalizer, DataSet allData, ExpressionParser parser, BeanFactory beanFactory) {
        if (normalizer == null) {
            return value;
        }
        StandardEvaluationContext context = new StandardEvaluationContext(value);
        if (allData != null) {
            context.setVariable("data", (Object)allData);
        }
        if (beanFactory != null) {
            context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        Expression exp = parser.parseExpression(normalizer);
        return exp.getValue((EvaluationContext)context);
    }
}

