/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oUserException;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.script.ScriptProcessor;

public class ValidationUtil {
    private static final String YES_CHOICE = "confirmation.yes";

    public static boolean isValidatable(CompiledQuery query, Validation validation) {
        Set validationFields = validation.getRequiredFields();
        Set<String> queryFilters = query.getFilterFieldsMap().values().stream().map(N2oQuery.Filter::getFilterField).collect(Collectors.toSet());
        return ValidationUtil.checkInSubSet(validationFields, queryFilters);
    }

    private static boolean checkInSubSet(Set<String> validationFields, Set<String> actionFields) {
        if (validationFields == null) {
            return false;
        }
        for (String field : validationFields) {
            if (actionFields.contains(field)) continue;
            return false;
        }
        return true;
    }

    public static void checkForConfirmation(CompiledObject.Operation operation, DataSet dataSet, String choice) {
        ValidationUtil.checkForConfirmation(Collections::emptyList, operation, dataSet, choice);
    }

    public static void checkForConfirmation(Supplier<List<String>> warnings, CompiledObject.Operation operation, DataSet dataSet, String choice) {
        if (choice != null) {
            return;
        }
        List<String> warningMessages = warnings.get();
        if (!warningMessages.isEmpty()) {
            ValidationUtil.failWithWarnings(warningMessages, operation, dataSet);
        }
    }

    @Deprecated
    private static void failWithWarnings(List<String> warningsMessages, CompiledObject.Operation operation, DataSet dataSet) {
        Object resultWarningMessage = "";
        for (String message : warningsMessages) {
            resultWarningMessage = (String)resultWarningMessage + String.format("<div class=\"alert alert-warning\">%s</div>", message);
        }
        String userSummaryMessage = StringUtils.resolveLinks((String)((String)resultWarningMessage + String.format("<div class=\"n2o-dialog-choice__text\">%s</div>", dataSet.get((Object)"$bulk.count") == null ? operation.getConfirmationText() : operation.getBulkConfirmationText())), (Object)dataSet);
        N2oUserException exception = new N2oUserException(userSummaryMessage);
        HashMap choiceMap = new HashMap();
        throw exception;
    }

    public static List<Validation> calculateVisibleValidation(List<Validation> validations, DataSet dataSet) {
        if (validations == null) {
            return Collections.emptyList();
        }
        ArrayList<Validation> res = new ArrayList<Validation>();
        for (Validation n2oField : validations) {
            if (!ValidationUtil.isVisible(n2oField, dataSet)) continue;
            res.add(n2oField);
        }
        return res;
    }

    private static boolean isVisible(Validation validation, DataSet dataSet) {
        boolean fieldIsVisible = true;
        if (validation.getFieldVisibilityCondition() != null) {
            fieldIsVisible = ScriptProcessor.evalForBoolean((String)validation.getFieldVisibilityCondition().getCondition(), (DataSet)dataSet);
        }
        boolean fieldSetIsVisible = true;
        if (validation.getFieldSetVisibilityCondition() != null) {
            fieldSetIsVisible = ScriptProcessor.evalForBoolean((String)validation.getFieldSetVisibilityCondition(), (DataSet)dataSet);
        }
        return fieldIsVisible && fieldSetIsVisible;
    }

    public static void sort(List<Validation> validations) {
        if (validations == null) {
            return;
        }
        Comparator<Validation> comparator = Comparator.comparing(Validation::getSeverity).reversed().thenComparing(Validation::isForField).reversed().thenComparing((v1, v2) -> {
            if (v1.getClass() == v2.getClass()) {
                return 0;
            }
            if (v1.getClass() == MandatoryValidation.class) {
                return -1;
            }
            if (v1.getClass() == ConditionValidation.class) {
                if (v2.getClass() == ConstraintValidation.class) {
                    return -1;
                }
                return 1;
            }
            return 1;
        });
        Collections.sort(validations, comparator);
    }
}

