/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.DataSetMapper;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.data.ActionInvocationEngine;
import net.n2oapp.framework.api.data.ArgumentsInvocationEngine;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.PluralityType;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.engine.data.N2oInvocationFactory;
import net.n2oapp.framework.engine.util.InvocationParametersMapping;
import net.n2oapp.framework.engine.util.MappingProcessor;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class N2oInvocationProcessor
implements InvocationProcessor {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private N2oInvocationFactory invocationFactory;
    private ContextProcessor contextProcessor;
    private DomainProcessor domainProcessor;

    public N2oInvocationProcessor(N2oInvocationFactory invocationFactory, ContextProcessor contextProcessor, DomainProcessor domainProcessor) {
        this.invocationFactory = invocationFactory;
        this.contextProcessor = contextProcessor;
        this.domainProcessor = domainProcessor;
    }

    public DataSet invoke(N2oInvocation invocation, DataSet inDataSet, Collection<? extends InvocationParameter> inParameters, Collection<? extends InvocationParameter> outParameters) {
        Map<String, String> inMapping = InvocationParametersMapping.extractMapping(inParameters);
        Map<String, String> outMapping = InvocationParametersMapping.extractMapping(outParameters);
        DataSet resolvedInDataSet = this.resolveInValues(inMapping, inParameters, inDataSet);
        DataSet resultDataSet = this.invoke(invocation, resolvedInDataSet, inMapping, outMapping);
        this.resolveOutValues(outParameters, resultDataSet);
        inDataSet.merge(resultDataSet);
        return inDataSet;
    }

    private DataSet invoke(N2oInvocation invocation, DataSet inDataSet, Map<String, String> inMapping, Map<String, String> outMapping) {
        ActionInvocationEngine engine = (ActionInvocationEngine)this.invocationFactory.produce(invocation.getClass());
        Object result = engine instanceof ArgumentsInvocationEngine ? ((ArgumentsInvocationEngine)engine).invoke((N2oArgumentsInvocation)invocation, InvocationParametersMapping.mapToArgs((N2oArgumentsInvocation)invocation, inDataSet, inMapping)) : engine.invoke(invocation, InvocationParametersMapping.mapToMap(inDataSet, inMapping));
        return DataSetMapper.extract((Object)result, outMapping);
    }

    protected void resolveOutValues(Collection<? extends InvocationParameter> invocationParameters, DataSet resultDataSet) {
        if (invocationParameters == null) {
            return;
        }
        for (InvocationParameter invocationParameter : invocationParameters) {
            if (invocationParameter.getDefaultValue() == null || invocationParameter.getMapping() != null) continue;
            resultDataSet.put(invocationParameter.getId(), this.contextProcessor.resolve((Object)invocationParameter.getDefaultValue()));
        }
    }

    protected DataSet resolveInValues(Map<String, String> inMapping, Collection<? extends InvocationParameter> invocationParameters, DataSet inDataSet) {
        if (invocationParameters == null) {
            return inDataSet;
        }
        for (InvocationParameter invocationParameter : invocationParameters) {
            this.prepareValue(invocationParameter, inDataSet);
            this.resolveMappingCondition(invocationParameter, inMapping, inDataSet);
            if (!inMapping.containsKey(invocationParameter.getId()) || !(invocationParameter instanceof N2oObject.Parameter) || invocationParameter.getEntityClass() == null || ((N2oObject.Parameter)invocationParameter).getChildParams() == null) continue;
            if (invocationParameter.getPluralityType() == PluralityType.list || invocationParameter.getPluralityType() == PluralityType.set) {
                for (Object dataSet : (Collection)inDataSet.get((Object)invocationParameter.getId())) {
                    ((DataSet)dataSet).putAll((Map)this.normalize(Arrays.asList(((N2oObject.Parameter)invocationParameter).getChildParams()), (DataSet)dataSet));
                }
            } else {
                inDataSet.put(invocationParameter.getId(), (Object)this.normalize(Arrays.asList(((N2oObject.Parameter)invocationParameter).getChildParams()), (DataSet)inDataSet.get((Object)invocationParameter.getId())));
            }
            MappingProcessor.mapParameter(invocationParameter, inDataSet);
        }
        return this.normalize(invocationParameters, inDataSet);
    }

    private void prepareValue(InvocationParameter inParameter, DataSet inDataSet) {
        Object value = inDataSet.get((Object)inParameter.getId());
        if (inParameter.getDefaultValue() != null && value == null) {
            value = inParameter.getDefaultValue();
        }
        value = this.contextProcessor.resolve(value);
        if ((value = this.domainProcessor.deserialize(value, inParameter.getDomain())) != null && inParameter instanceof N2oObject.Parameter && ((N2oObject.Parameter)inParameter).getChildParams() != null) {
            for (N2oObject.Parameter childParam : ((N2oObject.Parameter)inParameter).getChildParams()) {
                if (inParameter.getPluralityType() == PluralityType.list || inParameter.getPluralityType() == PluralityType.set) {
                    for (Object dataSet : (Collection)value) {
                        this.prepareValue((InvocationParameter)childParam, (DataSet)dataSet);
                    }
                    continue;
                }
                this.prepareValue((InvocationParameter)childParam, (DataSet)value);
            }
        }
        inDataSet.put(inParameter.getId(), value);
    }

    private DataSet normalize(Collection<? extends InvocationParameter> invocationParameters, DataSet inDataSet) {
        DataSet copiedDataSet = new DataSet((Map)inDataSet);
        for (InvocationParameter invocationParameter : invocationParameters) {
            Object value;
            if (invocationParameter.getNormalize() == null || (value = inDataSet.get((Object)invocationParameter.getId())) == null) continue;
            value = InvocationParametersMapping.normalizeValue(value, invocationParameter.getNormalize(), inDataSet, parser);
            copiedDataSet.put(invocationParameter.getId(), value);
        }
        return copiedDataSet;
    }

    private void resolveMappingCondition(InvocationParameter inParam, Map<String, String> inMapping, DataSet inDataSet) {
        boolean unmappable;
        boolean bl = unmappable = inParam.getNullIgnore() != null && inParam.getNullIgnore() != false && inDataSet.get((Object)inParam.getId()) == null || inParam.getMappingCondition() != null && !ScriptProcessor.evalForBoolean((String)inParam.getMappingCondition(), (DataSet)inDataSet);
        if (unmappable) {
            inMapping.remove(inParam.getId());
        }
    }
}

