/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.N2oTestDataProvider;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class TestDataProviderEngine
implements MapInvocationEngine<N2oTestDataProvider>,
ResourceLoaderAware {
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Map<String, List<DataSet>> repository = new ConcurrentHashMap<String, List<DataSet>>();
    private final Map<String, AtomicLong> sequences = new ConcurrentHashMap<String, AtomicLong>();

    public Class<? extends N2oTestDataProvider> getType() {
        return N2oTestDataProvider.class;
    }

    public Object invoke(N2oTestDataProvider invocation, Map<String, Object> inParams) {
        return this.execute(invocation, inParams, this.getData(invocation.getFile()));
    }

    private Object execute(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        if (invocation.getOperation() == null) {
            return this.findAll(inParams, data);
        }
        switch (invocation.getOperation()) {
            case create: {
                return this.create(invocation, inParams, data);
            }
            case findAll: {
                return this.findAll(inParams, data);
            }
            case findOne: {
                return this.findOne(inParams, data);
            }
            case update: {
                return this.update(invocation, inParams, data);
            }
            case delete: {
                return this.delete(invocation, inParams, data);
            }
            case count: {
                return this.repository.get(invocation.getFile()).size();
            }
            case echo: {
                return inParams;
            }
        }
        throw new N2oException("Unsupported invocation's operation");
    }

    private List<DataSet> findAll(Map<String, Object> inParams, List<DataSet> data) {
        List sortings = (List)inParams.get("sorting");
        List filters = (List)inParams.get("filters");
        Integer limit = (Integer)inParams.get("limit");
        Integer offset = (Integer)inParams.get("offset");
        Integer count = (Integer)inParams.get("count");
        List<DataSet> modifiableData = new ArrayList<DataSet>(data);
        modifiableData = this.filter(filters, inParams, modifiableData);
        this.sort(sortings, inParams, modifiableData);
        return this.paginate(limit, offset, count, modifiableData);
    }

    private DataSet findOne(Map<String, Object> inParams, List<DataSet> data) {
        List filters = (List)inParams.get("filters");
        List<DataSet> modifiableData = new ArrayList<DataSet>(data);
        return (modifiableData = this.filter(filters, inParams, modifiableData)).isEmpty() ? null : modifiableData.get(0);
    }

    private Object create(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        DataSet newElement = new DataSet();
        newElement.put("id", (Object)this.sequences.get(invocation.getFile()).incrementAndGet());
        this.updateElement((Map)newElement, inParams.entrySet());
        modifiableData.add(0, newElement);
        this.updateRepository(invocation.getFile(), modifiableData);
        return newElement;
    }

    private Object update(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get("id") == null) {
            throw new N2oException("Id is required for operation \"update\"");
        }
        Long id = ((Number)inParams.get("id")).longValue();
        DataSet element = modifiableData.stream().filter(v -> id.equals(((Number)v.get((Object)"id")).longValue())).findFirst().orElseThrow(() -> new N2oException("No such element"));
        this.updateElement((Map)element, inParams.entrySet());
        this.updateRepository(invocation.getFile(), modifiableData);
        return null;
    }

    private Object delete(N2oTestDataProvider invocation, Map<String, Object> inParams, List<DataSet> data) {
        ArrayList<DataSet> modifiableData = new ArrayList<DataSet>(data);
        if (inParams.get("id") == null) {
            throw new N2oException("Id is required for operation \"delete\"");
        }
        Long id = ((Number)inParams.get("id")).longValue();
        modifiableData.removeIf(elem -> id.equals(((Number)elem.get((Object)"id")).longValue()));
        this.updateRepository(invocation.getFile(), modifiableData);
        return null;
    }

    private Map updateElement(Map element, Set<Map.Entry<String, Object>> fields) {
        for (Map.Entry<String, Object> field : fields) {
            if (field.getValue() instanceof Date) {
                element.put(field.getKey(), new SimpleDateFormat("dd.MM.yyy HH:mm:ss").format(field.getValue()));
                continue;
            }
            element.put(field.getKey(), field.getValue());
        }
        return element;
    }

    private List<DataSet> paginate(Integer limit, Integer offset, Integer count, List<DataSet> data) {
        Boolean unique = count != null && count.equals(1);
        if (limit != null && offset != null && !unique.booleanValue()) {
            data = data.stream().limit(limit + offset).skip(offset.intValue()).collect(Collectors.toList());
        }
        return data;
    }

    private List<DataSet> filter(List<String> filters, Map<String, Object> inParams, List<DataSet> data) {
        if (filters == null || filters.size() == 0) {
            return data;
        }
        for (String filter : filters) {
            Object pattern;
            String[] splittedFilter;
            if (filter.contains(":eq")) {
                splittedFilter = filter.replaceAll(" ", "").split(":eq");
                pattern = inParams.get(splittedFilter[1].replace(":", ""));
                if (pattern == null) continue;
                data = data.stream().filter(m -> {
                    if (!m.containsKey((Object)splittedFilter[0]) || m.get((Object)splittedFilter[0]) == null) {
                        return false;
                    }
                    if (m.get((Object)splittedFilter[0]) instanceof Number && pattern instanceof Number) {
                        return Long.valueOf(((Number)m.get((Object)splittedFilter[0])).longValue()).equals(((Number)pattern).longValue());
                    }
                    return m.get((Object)splittedFilter[0]).toString().equals(pattern.toString());
                }).collect(Collectors.toList());
                continue;
            }
            if (filter.contains(":like")) {
                splittedFilter = filter.replaceAll(" ", "").split(":like");
                pattern = inParams.get(splittedFilter[1].replace(":", "")).toString();
                if (pattern == null) continue;
                data = data.stream().filter(arg_0 -> TestDataProviderEngine.lambda$filter$4(splittedFilter, (String)pattern, arg_0)).collect(Collectors.toList());
                continue;
            }
            if (filter.contains(":in")) {
                splittedFilter = filter.replaceAll(" ", "").split(":in");
                List patterns = (List)inParams.get(splittedFilter[1].replace(":", ""));
                if (patterns == null) continue;
                data = data.stream().filter(m -> {
                    if (!m.containsKey((Object)splittedFilter[0]) || m.get((Object)splittedFilter[0]) == null) {
                        return false;
                    }
                    if (m.get((Object)splittedFilter[0]) instanceof Number) {
                        ArrayList longPatterns = new ArrayList();
                        patterns.forEach(p -> longPatterns.add(((Number)p).longValue()));
                        return longPatterns.contains(((Number)m.get((Object)splittedFilter[0])).longValue());
                    }
                    for (Object p2 : patterns) {
                        if (!p2.toString().equals(m.get((Object)splittedFilter[0]).toString())) continue;
                        return true;
                    }
                    return false;
                }).collect(Collectors.toList());
                continue;
            }
            if (filter.contains(":more")) {
                splittedFilter = filter.replaceAll(" ", "").split(":more");
                pattern = (Comparable)inParams.get(splittedFilter[1].replace(":", ""));
                if (pattern == null) continue;
                data = data.stream().filter(arg_0 -> TestDataProviderEngine.lambda$filter$7(splittedFilter, (Comparable)pattern, arg_0)).collect(Collectors.toList());
                continue;
            }
            if (!filter.contains(":less") || (pattern = (Comparable)inParams.get((splittedFilter = filter.replaceAll(" ", "").split(":less"))[1].replace(":", ""))) == null) continue;
            data = data.stream().filter(arg_0 -> TestDataProviderEngine.lambda$filter$8(splittedFilter, (Comparable)pattern, arg_0)).collect(Collectors.toList());
        }
        return data;
    }

    private void sort(List<String> sortings, Map<String, Object> inParams, List<DataSet> data) {
        if (sortings == null || sortings.size() == 0) {
            return;
        }
        String sorting = sortings.get(0);
        String[] splittedSorting = sorting.replaceAll(" ", "").split(":");
        String direction = (String)inParams.get(splittedSorting[1]);
        if (data.size() < 1) {
            return;
        }
        Comparator<Object> comparator = Comparator.comparing(m -> (Comparable)((LinkedHashMap)m).get(splittedSorting[0]), Comparator.nullsLast(Comparator.naturalOrder()));
        if (comparator == null) {
            return;
        }
        if (direction.equals("desc")) {
            comparator = comparator.reversed();
        }
        data.sort(comparator);
    }

    private synchronized List<DataSet> getData(String fileName) {
        if (fileName == null) {
            return new ArrayList<DataSet>();
        }
        if (!this.repository.containsKey(fileName)) {
            this.initRepository(fileName);
        }
        return this.repository.get(fileName);
    }

    private void updateRepository(String key, List<DataSet> newData) {
        this.repository.put(key, newData);
    }

    private void initRepository(String fileName) {
        try {
            InputStream inputStream = this.resourceLoader.getResource("classpath:" + fileName).getInputStream();
            List<DataSet> data = this.loadJson(inputStream);
            this.repository.put(fileName, data);
            long maxId = data.stream().filter(v -> v.get((Object)"id") != null).mapToLong(v -> (Long)v.get((Object)"id")).max().orElse(-1L);
            if (maxId != -1L) {
                this.sequences.put(fileName, new AtomicLong(maxId));
            }
        }
        catch (IOException e) {
            throw new N2oException((Throwable)e);
        }
    }

    private List<DataSet> loadJson(InputStream is) throws IOException {
        List<DataSet> dataList = Arrays.asList((DataSet[])new ObjectMapper().readValue(is, DataSet[].class));
        for (DataSet data : dataList) {
            if (!data.containsKey((Object)"id")) continue;
            if (data.get((Object)"id") instanceof Number) {
                data.put("id", (Object)((Number)data.get((Object)"id")).longValue());
                continue;
            }
            if (!(data.get((Object)"id") instanceof String)) continue;
            data.put("id", (Object)Long.valueOf((String)data.get((Object)"id")));
        }
        return dataList;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private static /* synthetic */ boolean lambda$filter$8(String[] splittedFilter, Comparable pattern, DataSet m) {
        if (!m.containsKey((Object)splittedFilter[0]) || m.get((Object)splittedFilter[0]) == null) {
            return false;
        }
        if (m.get((Object)splittedFilter[0]) instanceof Number && pattern instanceof Number) {
            return Long.valueOf(((Number)m.get((Object)splittedFilter[0])).longValue()).compareTo(((Number)((Object)pattern)).longValue()) < 0;
        }
        return m.get((Object)splittedFilter[0]).toString().compareTo(pattern.toString()) < 0;
    }

    private static /* synthetic */ boolean lambda$filter$7(String[] splittedFilter, Comparable pattern, DataSet m) {
        if (!m.containsKey((Object)splittedFilter[0]) || m.get((Object)splittedFilter[0]) == null) {
            return false;
        }
        if (m.get((Object)splittedFilter[0]) instanceof Number && pattern instanceof Number) {
            return Long.valueOf(((Number)m.get((Object)splittedFilter[0])).longValue()).compareTo(((Number)((Object)pattern)).longValue()) > 0;
        }
        return m.get((Object)splittedFilter[0]).toString().compareTo(pattern.toString()) > 0;
    }

    private static /* synthetic */ boolean lambda$filter$4(String[] splittedFilter, String pattern, DataSet m) {
        if (!m.containsKey((Object)splittedFilter[0]) || m.get((Object)splittedFilter[0]) == null) {
            return false;
        }
        return m.get((Object)splittedFilter[0]).toString().toLowerCase().contains(pattern.toLowerCase());
    }
}

