/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.Sorting;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.DataSetMapper;
import net.n2oapp.framework.api.criteria.N2oPreparedCriteria;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.data.CriteriaConstructor;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.Argument;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oArgumentsInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.engine.util.ClassHash;
import net.n2oapp.framework.engine.util.MappingProcessor;
import net.n2oapp.properties.StaticProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class InvocationParametersMapping {
    public static Map<String, String> extractMapping(Collection<? extends InvocationParameter> parameters) {
        LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
        if (parameters != null) {
            for (InvocationParameter invocationParameter : parameters) {
                mapping.put(invocationParameter.getId(), invocationParameter.getMapping());
            }
        }
        return mapping;
    }

    public static Object[] mapToArgs(N2oArgumentsInvocation invocation, DataSet inDataSet, Map<String, String> inMapping) {
        inMapping = InvocationParametersMapping.changeInMappingForEntity(invocation, inMapping);
        if (invocation.getArguments() == null || invocation.getArguments().length == 0) {
            return null;
        }
        ArrayList<String> argClasses = new ArrayList<String>();
        for (Argument arg : invocation.getArguments()) {
            argClasses.add(arg.getClassName());
        }
        return MappingProcessor.map(inDataSet, inMapping, argClasses);
    }

    public static Map<String, Object> mapToMap(DataSet dataSet, Map<String, String> mapping) {
        if (StaticProperties.get((String)"n2o.engine.mapper").equals("spel")) {
            return DataSetMapper.mapToMap((DataSet)dataSet, mapping, null);
        }
        DataSet result = new DataSet();
        mapping.forEach((key, value) -> result.put(value, dataSet.get(key)));
        return result;
    }

    public static void prepareMapForQuery(Map<String, Object> map, CompiledQuery query, N2oPreparedCriteria criteria) {
        N2oQuery.Field field;
        map.put("select", query.getSelectExpressions());
        LinkedHashSet<String> joins = new LinkedHashSet<String>(query.getJoinExpressions());
        ArrayList<String> where = new ArrayList<String>();
        for (Restriction r : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(r.getFieldId())).get(r.getType());
            if (filter.getText() != null) {
                where.add(filter.getText());
            }
            MappingProcessor.inMap(map, filter.getMapping(), r.getValue());
            field = (N2oQuery.Field)query.getFieldsMap().get(r.getFieldId());
            if (field.getNoJoin().booleanValue()) continue;
            joins.add(field.getJoinBody());
        }
        map.put("filters", where);
        ArrayList<String> sortingExp = new ArrayList<String>();
        if (criteria.getSorting() != null) {
            for (Sorting sorting : criteria.getSortings()) {
                field = (N2oQuery.Field)query.getFieldsMap().get(sorting.getField());
                if (field.getNoSorting().booleanValue()) continue;
                sortingExp.add(field.getSortingBody());
                MappingProcessor.inMap(map, field.getSortingMapping(), sorting.getDirection().getExpression());
                if (field.getNoJoin().booleanValue()) continue;
                joins.add(field.getJoinBody());
            }
        }
        map.put("sorting", sortingExp);
        if (criteria.getAdditionalFields() != null) {
            criteria.getAdditionalFields().entrySet().stream().filter(es -> es.getValue() != null).forEach(es -> map.put((String)es.getKey(), es.getValue()));
        }
        map.put("join", new ArrayList(joins));
    }

    public static void prepareMapForPage(Map<String, Object> map, N2oPreparedCriteria criteria, boolean pageStartsWith0) {
        map.put("limit", criteria.getSize());
        map.put("offset", criteria.getFirst());
        if (criteria.getCount() != null) {
            map.put("count", criteria.getCount());
        }
        map.put("page", pageStartsWith0 ? criteria.getPage() - 1 : criteria.getPage());
    }

    public static Object[] prepareArgsForQuery(N2oArgumentsInvocation invocation, CompiledQuery query, N2oPreparedCriteria criteria, CriteriaConstructor criteriaConstructor) {
        Class<?>[] classesOfArguments = InvocationParametersMapping.takeClassesOfArguments(invocation);
        if (classesOfArguments == null || classesOfArguments.length == 0) {
            return new Object[0];
        }
        Object[] argumentInstances = new Object[classesOfArguments.length];
        int criteriaIdx = -1;
        for (int i = 0; i < invocation.getArguments().length; ++i) {
            if (classesOfArguments[i] == null) continue;
            if (invocation.getArguments()[i].getType().equals((Object)Argument.Type.CLASS) || invocation.getArguments()[i].getType().equals((Object)Argument.Type.ENTITY)) {
                try {
                    argumentInstances[i] = classesOfArguments[i].newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(classesOfArguments[i].getName(), e);
                }
            }
            if (!invocation.getArguments()[i].getType().equals((Object)Argument.Type.CRITERIA)) continue;
            argumentInstances[i] = criteriaConstructor.construct(criteria, classesOfArguments[i]);
            criteriaIdx = i;
        }
        if (Arrays.stream(invocation.getArguments()).filter(arg -> arg.getType().equals((Object)Argument.Type.ENTITY) || arg.getType().equals((Object)Argument.Type.CRITERIA)).collect(Collectors.toList()).size() > 1) {
            throw new IllegalArgumentException("There must be only one argument with Criteria or Entity type ");
        }
        for (Restriction r : criteria.getRestrictions()) {
            N2oQuery.Filter filter = (N2oQuery.Filter)((Map)query.getFiltersMap().get(r.getFieldId())).get(r.getType());
            String mapping = filter.getMapping().startsWith("[") ? filter.getMapping() : "[" + criteriaIdx + "]." + filter.getMapping();
            MappingProcessor.inMap(argumentInstances, mapping, r.getValue());
        }
        return argumentInstances;
    }

    private static Map<String, String> changeInMappingForEntity(N2oArgumentsInvocation invocation, Map<String, String> inMapping) {
        if (invocation.getArguments() == null || invocation.getArguments().length == 0) {
            int[] idx = new int[]{0};
            HashMap<String, String> newMap = new HashMap<String, String>();
            inMapping.forEach((k, v) -> {
                String string;
                if (v != null) {
                    string = v;
                } else {
                    Object[] objectArray = new Object[1];
                    int n = idx[0];
                    idx[0] = n + 1;
                    objectArray[0] = n;
                    string = String.format("[%s]", objectArray);
                }
                newMap.put((String)k, string);
            });
            inMapping = newMap;
        } else {
            int entityPosition = InvocationParametersMapping.findEntityPosition(invocation);
            if (entityPosition != -1) {
                String prefix = "[" + entityPosition + "].";
                for (String key : inMapping.keySet()) {
                    String value = inMapping.get(key);
                    if (value == null || value.startsWith("[")) continue;
                    inMapping.put(key, prefix + value);
                }
            }
        }
        return inMapping;
    }

    public static Object normalizeValue(Object value, String normalizer, DataSet allData, ExpressionParser parser) {
        if (normalizer == null) {
            return value;
        }
        StandardEvaluationContext context = new StandardEvaluationContext(value);
        if (allData != null) {
            context.setVariable("data", (Object)allData);
        }
        Expression exp = parser.parseExpression(normalizer);
        return exp.getValue((EvaluationContext)context);
    }

    private static int findEntityPosition(N2oArgumentsInvocation invocation) {
        for (int i = 0; i < invocation.getArguments().length; ++i) {
            if (invocation.getArguments()[i].getType() == null || !invocation.getArguments()[i].getType().equals((Object)Argument.Type.ENTITY)) continue;
            return i;
        }
        return -1;
    }

    private static Class<?>[] takeClassesOfArguments(N2oArgumentsInvocation invocation) {
        int argumentCount = invocation.getArguments() != null ? invocation.getArguments().length : 0;
        Class[] classesOfArguments = new Class[argumentCount];
        if (invocation.getArguments() == null) {
            return null;
        }
        try {
            for (int i = 0; i < argumentCount; ++i) {
                classesOfArguments[i] = invocation.getArguments()[i].getClassName() == null || invocation.getArguments()[i].getType().equals((Object)Argument.Type.PRIMITIVE) ? null : ClassHash.getClass(invocation.getArguments()[i].getClassName());
            }
        }
        catch (Exception e) {
            throw new N2oException("Class of argument not found", (Throwable)e);
        }
        return classesOfArguments;
    }
}

