/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.data.rest.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import org.apache.commons.lang.time.DateUtils;

public class CustomDateDeserializer
extends StdDeserializer<Object> {
    private String[] patterns;
    private final JsonDeserializer<?> defaultDeserializer;

    public CustomDateDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(Object.class);
        this.defaultDeserializer = defaultDeserializer;
    }

    public Object deserialize(JsonParser jsonparser, DeserializationContext context) throws IOException {
        String jsonString = jsonparser.getText();
        if (this.patterns == null) {
            return this.defaultDeserializer.deserialize(jsonparser, context);
        }
        try {
            return DateUtils.parseDate((String)jsonString, (String[])this.patterns);
        }
        catch (ParseException e) {
            return this.defaultDeserializer.deserialize(jsonparser, context);
        }
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }
}

