/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.modules.stack;

import java.util.List;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.bean.BeansOrderException;
import net.n2oapp.framework.api.bean.BeansSorting;
import net.n2oapp.framework.api.bean.LocatedBeanPack;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.aware.OriginAware;
import net.n2oapp.framework.api.processing.N2oModule;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.user.StaticUserContext;
import net.n2oapp.framework.api.user.UserContext;
import net.n2oapp.framework.engine.modules.stack.DataProcessingCallback;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataProcessingStack {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile List<N2oModule> stack;

    public void processAction(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.process((OriginAware)requestInfo.getOperation(), module -> {
            this.logger.debug("Processing in data-set in '{}' module", (Object)module.getId());
            module.processAction(requestInfo, responseInfo, dataSet);
        });
    }

    public void processActionError(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet, N2oException exception) {
        this.process((OriginAware)requestInfo.getOperation(), module -> {
            this.logger.debug("Processing action error in '{}' module", (Object)module.getId());
            module.processActionError(requestInfo, responseInfo, dataSet, exception);
        });
    }

    public void processActionResult(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.process((OriginAware)requestInfo.getOperation(), module -> {
            this.logger.debug("Processing out data-set in '{}' module", (Object)module.getId());
            module.processActionResult(requestInfo, responseInfo, dataSet);
        });
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        this.process((OriginAware)requestInfo.getQuery(), module -> {
            this.logger.debug("Processing query in '{}' module", (Object)module.getId());
            module.processQuery(requestInfo, responseInfo);
        });
    }

    public void processQueryError(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, N2oException exception) {
        this.process((OriginAware)requestInfo.getQuery(), module -> {
            this.logger.debug("Processing query error in '{}' module", (Object)module.getId());
            module.processQueryError(requestInfo, responseInfo, exception);
        });
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        this.process((OriginAware)requestInfo.getQuery(), module -> {
            this.logger.debug("Processing query-result in '{}' module", (Object)module.getId());
            module.processQueryResult(requestInfo, responseInfo, page);
        });
    }

    private void process(OriginAware originAware, DataProcessingCallback callback) {
        if (this.stack == null) {
            this.initStack();
        }
        for (N2oModule module : this.stack) {
            if (!module.isDisable()) {
                callback.process(module);
                continue;
            }
            this.logger.debug("Module '{}' is disable!", (Object)module.getId());
        }
    }

    public void disableModule(String module) {
        for (N2oModule n2oModule : this.stack) {
            if (!n2oModule.getId().equals(module)) continue;
            n2oModule.setDisable(true);
            return;
        }
    }

    public void enableModule(String module) {
        for (N2oModule n2oModule : this.stack) {
            if (!n2oModule.getId().equals(module)) continue;
            n2oModule.setDisable(false);
            return;
        }
    }

    private synchronized void initStack() {
        List<N2oModule> modules = this.findModules();
        List<LocatedBeanPack<N2oModule>> packs = this.findModulePacks();
        try {
            if (this.stack == null) {
                this.stack = BeansSorting.sort(modules, packs);
            }
        }
        catch (BeansOrderException e) {
            throw new DataProcessingStackException("Incorrect n2o-modules order registration");
        }
    }

    private UserContext getUser() {
        return StaticUserContext.getUserContext();
    }

    protected abstract List<N2oModule> findModules();

    protected abstract List<LocatedBeanPack<N2oModule>> findModulePacks();
}

