/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.PluralityType;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class MappingProcessor {
    private static final ExpressionParser writeParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final ExpressionParser readParser = new SpelExpressionParser(new SpelParserConfiguration(false, false));
    private static final Set<String> primitiveTypes = Stream.of("java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.math.BigDecimal").collect(Collectors.toSet());

    public static void inMap(Object target, String mapping, Object value) {
        Expression expression = writeParser.parseExpression(mapping);
        if (target != null) {
            expression.setValue(target, value);
        }
    }

    public static <T> T outMap(Object target, String mapping, Class<T> clazz) {
        Object result;
        if (mapping != null) {
            Expression expression = readParser.parseExpression(mapping);
            result = expression.getValue(target, clazz);
        } else {
            result = target;
        }
        if (clazz != null && result == null) {
            throw new N2oException("Expected is " + clazz + ", but actual is null");
        }
        if (clazz != null && !clazz.isAssignableFrom(result.getClass())) {
            throw new N2oException("Expected is " + clazz + ", but actual is " + result.getClass());
        }
        return (T)result;
    }

    public static void outMap(DataSet target, Object value, String fieldId, String mapping, Object defaultValue) {
        Expression expression = readParser.parseExpression(mapping);
        Object obj = expression.getValue(value);
        target.put(fieldId, obj == null ? defaultValue : obj);
    }

    public static Object[] map(DataSet dataSet, Map<String, String> mapping, List<String> argumentClasses) {
        Object[] instances = MappingProcessor.instantiateArguments(argumentClasses);
        Object[] result = instances == null || instances.length == 0 ? new Object[mapping.size()] : instances;
        int idx = 0;
        for (Map.Entry<String, String> map : mapping.entrySet()) {
            Expression expression = writeParser.parseExpression(map.getValue() != null ? map.getValue() : "[" + idx + "]");
            expression.setValue((Object)result, dataSet.get((Object)map.getKey()));
            ++idx;
        }
        return result;
    }

    private static Object[] instantiateArguments(List<String> arguments) {
        if (arguments == null) {
            return null;
        }
        Object[] argumentInstances = new Object[arguments.size()];
        for (int k = 0; k < arguments.size(); ++k) {
            if (arguments.get(k) == null || primitiveTypes.contains(arguments.get(k))) {
                argumentInstances[k] = null;
                continue;
            }
            try {
                Class<?> argumentClass = Class.forName(arguments.get(k));
                argumentInstances[k] = argumentClass.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new N2oException("Can't create instance of class " + arguments.get(k), (Throwable)e);
            }
        }
        return argumentInstances;
    }

    public static void mapParameter(InvocationParameter parameter, DataSet dataSet) {
        Object data = dataSet.get((Object)parameter.getId());
        if (data == null) {
            return;
        }
        if (parameter.getPluralityType() == PluralityType.list || parameter.getPluralityType() == PluralityType.set) {
            AbstractCollection collection = parameter.getPluralityType() == PluralityType.list ? new ArrayList() : new HashSet();
            for (Object item : (Collection)data) {
                collection.add(MappingProcessor.mapChildParameters(parameter, (DataSet)item));
            }
            dataSet.put(parameter.getId(), collection);
        } else {
            dataSet.put(parameter.getId(), MappingProcessor.mapChildParameters(parameter, (DataSet)data));
        }
    }

    public static Object mapChildParameters(InvocationParameter parameter, DataSet dataSet) {
        Object instance;
        try {
            instance = Class.forName(parameter.getEntityClass()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new N2oException((Throwable)e);
        }
        for (N2oObject.Parameter childParam : ((N2oObject.Parameter)parameter).getChildParams()) {
            writeParser.parseExpression(childParam.getMapping()).setValue(instance, dataSet.get((Object)childParam.getId()));
        }
        return instance;
    }
}

