/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.processing.N2oModule;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;
import net.n2oapp.framework.api.ui.ResponseInfo;
import net.n2oapp.framework.api.ui.ResponseMessage;
import net.n2oapp.framework.engine.validation.engine.FailInfo;
import net.n2oapp.framework.engine.validation.engine.ValidationProcessor;
import net.n2oapp.framework.engine.validation.engine.info.ObjectValidationInfo;
import net.n2oapp.framework.engine.validation.engine.info.QueryValidationInfo;

public class N2oValidationModule
extends N2oModule {
    private ValidationProcessor processor;

    public N2oValidationModule(ValidationProcessor processor) {
        this.processor = processor;
    }

    public void processAction(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, dataSet), N2oValidation.ServerMoment.beforeOperation);
        this.prepareResponse(fails, (ResponseInfo)responseInfo);
    }

    public void processActionError(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet, N2oException exception) {
        List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, dataSet), N2oValidation.ServerMoment.afterFailOperation);
        this.prepareResponse(fails, (ResponseInfo)responseInfo);
    }

    public void processActionResult(ActionRequestInfo<DataSet> requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, dataSet), N2oValidation.ServerMoment.afterSuccessOperation);
        this.prepareResponse(fails, (ResponseInfo)responseInfo);
    }

    public void processQueryError(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, N2oException exception) {
        if (requestInfo.isValidationEnable() && requestInfo.getSize() == 1) {
            List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, requestInfo.getData()), N2oValidation.ServerMoment.afterFailQuery);
            this.prepareResponse(fails, (ResponseInfo)responseInfo);
        }
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        if (requestInfo.isValidationEnable() && requestInfo.getSize() != 1) {
            List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, requestInfo.getData()), N2oValidation.ServerMoment.beforeQuery);
            this.prepareResponse(fails, (ResponseInfo)responseInfo);
        }
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        Collection list = page.getCollection();
        if (requestInfo.isValidationEnable() && !list.isEmpty() && requestInfo.getSize() == 1) {
            List<FailInfo> fails = this.processor.validate(this.buildInfo(requestInfo, (DataSet)list.iterator().next()), N2oValidation.ServerMoment.afterSuccessQuery);
            this.prepareResponse(fails, (ResponseInfo)responseInfo);
        }
    }

    private ObjectValidationInfo buildInfo(ActionRequestInfo<DataSet> requestInfo, DataSet dataSet) {
        return new ObjectValidationInfo(requestInfo.getObject().getId(), requestInfo.getOperation().getValidationList(), dataSet, requestInfo.getFailAlertWidgetId(), requestInfo.getMessagesForm());
    }

    private QueryValidationInfo buildInfo(QueryRequestInfo requestInfo, DataSet inDataSet) {
        DataSet dataSet = inDataSet != null ? inDataSet : requestInfo.getData();
        DataSet result = new DataSet();
        Map paramsMap = requestInfo.getQuery().getParamToFilterIdMap();
        for (String key : dataSet.keySet()) {
            if (paramsMap.containsKey(key)) {
                if (DataSet.isSpreadKey((String)((String)paramsMap.get(key))) && !(result.get((Object)key) instanceof Collection)) {
                    result.put((String)paramsMap.get(key), Collections.singletonList(dataSet.get((Object)key)));
                    continue;
                }
                result.put((String)paramsMap.get(key), dataSet.get((Object)key));
                continue;
            }
            result.put(key, dataSet.get((Object)key));
        }
        return new QueryValidationInfo(requestInfo.getQuery().getObject(), requestInfo.getQuery().getValidations(), result, requestInfo.getFailAlertWidgetId(), requestInfo.getMessagesForm());
    }

    private void prepareResponse(List<FailInfo> fails, ResponseInfo responseInfo) {
        for (FailInfo fail : fails) {
            ResponseMessage message = new ResponseMessage();
            message.setText(fail.getMessage());
            message.setField(fail.getFieldId());
            message.setSeverityType(fail.getSeverity());
            responseInfo.addMessage(message);
        }
    }
}

