/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.engine.validation.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.engine.validation.engine.FailInfo;
import net.n2oapp.framework.engine.validation.engine.ValidationUtil;

public class Validator {
    private InvocationProcessor serviceProvider;
    private DataSet dataSet;
    private List<Validation> validationList;
    private N2oValidation.ServerMoment moment;
    private Boolean widgetWasValidated = false;
    private Set<String> validatedFields = new HashSet<String>();
    private Set<String> usedValidations = new HashSet<String>();
    private List<FailInfo> fails = new ArrayList<FailInfo>();
    private boolean afterDanger = false;

    public List<FailInfo> validate() {
        if (this.validationList == null) {
            return Collections.emptyList();
        }
        ValidationUtil.sort(this.validationList);
        for (Validation v : this.validationList) {
            this.handleValidation(v, this.fails);
        }
        return this.fails;
    }

    private void handleValidation(Validation v, List<FailInfo> fails) {
        if (this.checkValidation(v)) {
            v.validate(this.dataSet, this.serviceProvider, message -> {
                FailInfo failInfo = new FailInfo();
                failInfo.setMoment(v.getMoment());
                failInfo.setValidationId(v.getId());
                failInfo.setValidationClass(v.getClass().getSimpleName());
                failInfo.setSeverity(v.getSeverity());
                failInfo.setFieldId(v.isForField() ? v.getFieldId() : null);
                failInfo.setMessage(message);
                fails.add(failInfo);
                this.afterFail(v);
            });
        }
    }

    private void afterFail(Validation v) {
        if (SeverityType.danger.equals((Object)v.getSeverity())) {
            this.afterDanger = true;
        }
        if (!v.isForField()) {
            this.widgetWasValidated = true;
        } else {
            this.validatedFields.add(v.getFieldId());
        }
        this.usedValidations.add(v.getId());
    }

    private boolean checkValidation(Validation validation) {
        return this.checkAfterDanger(validation) && this.checkEnabled(validation) && this.checkMoment(validation) && this.checkUnique(validation) && this.checkUsed(validation) && this.checkRequiredConstraint(validation);
    }

    private boolean checkAfterDanger(Validation validation) {
        if (SeverityType.danger.equals((Object)validation.getSeverity())) {
            return true;
        }
        return !this.afterDanger;
    }

    private boolean checkRequiredConstraint(Validation validation) {
        ConstraintValidation v;
        if (validation instanceof ConstraintValidation && (v = (ConstraintValidation)validation).getInParameterList() != null) {
            for (InvocationParameter inParam : v.getInParameterList()) {
                if (inParam.getRequired() == null || !inParam.getRequired().booleanValue() || !v.getRequiredFields().contains(inParam.getName()) || this.dataSet.containsKey((Object)inParam.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkUsed(Validation v) {
        return !this.usedValidations.contains(v.getId());
    }

    private boolean checkUnique(Validation v) {
        return v.isForField() ? !this.validatedFields.contains(v.getFieldId()) : this.widgetWasValidated == false;
    }

    private boolean checkEnabled(Validation v) {
        if (v.getEnabled() != null) {
            return v.getEnabled();
        }
        if (v.getEnablingConditions() != null) {
            for (String enablingCondition : v.getEnablingConditions()) {
                if (ScriptProcessor.evalForBoolean((String)enablingCondition, (DataSet)this.dataSet)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkMoment(Validation validation) {
        return validation.getMoment() == null || this.moment == null || this.moment == validation.getMoment();
    }

    public static Builder newBuilder() {
        return new Validator().new Builder();
    }

    public class Builder {
        private Builder() {
        }

        public Builder addMoment(N2oValidation.ServerMoment moment) {
            Validator.this.moment = moment;
            return this;
        }

        public Builder addValidations(List<Validation> validations) {
            if (validations == null) {
                return this;
            }
            if (Validator.this.validationList == null) {
                Validator.this.validationList = new ArrayList();
            }
            Validator.this.validationList.addAll(validations);
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            Validator.this.dataSet = dataSet;
            return this;
        }

        public Builder addInvocationProcessor(InvocationProcessor processor) {
            Validator.this.serviceProvider = processor;
            return this;
        }

        public Validator build() {
            return Validator.this;
        }
    }
}

