/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.cache.template.CacheCallback;
import net.n2oapp.cache.template.CacheTemplate;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.mvc.api.BufferedHttpResponse;
import net.n2oapp.framework.mvc.api.CachingPrintWriter;
import net.n2oapp.framework.mvc.api.ServletTemplate;
import net.n2oapp.framework.mvc.callback.ServletCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;

public class CachingServletTemplate
implements ServletTemplate {
    private static final Logger log = LoggerFactory.getLogger(CachingServletTemplate.class);
    private CacheTemplate cacheTemplate;
    private String cacheRegion;
    private BiFunction<HttpServletRequest, HttpServletResponse, Object> keyFunc;

    public CachingServletTemplate(CacheTemplate cacheTemplate, String cacheRegion) {
    }

    public CachingServletTemplate(CacheManager cacheManager, String cacheRegion) {
        this.setCacheManager(cacheManager);
        this.cacheRegion = cacheRegion;
    }

    public CachingServletTemplate(CacheManager cacheManager, String cacheRegion, BiFunction<HttpServletRequest, HttpServletResponse, Object> keyFunc) {
        this(cacheManager, cacheRegion);
        this.keyFunc = keyFunc;
    }

    public CachingServletTemplate(CacheTemplate cacheTemplate, String cacheRegion, BiFunction<HttpServletRequest, HttpServletResponse, Object> keyFunc) {
        this.cacheRegion = cacheRegion;
        this.cacheTemplate = cacheTemplate;
        this.keyFunc = keyFunc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doService(final HttpServletRequest req, final HttpServletResponse res, final ServletCallback callback) throws IOException {
        res.setContentType(callback.getContentType());
        CachingPrintWriter cacheWriter = new CachingPrintWriter(res.getWriter());
        final BufferedHttpResponse buffer = new BufferedHttpResponse(res, cacheWriter);
        try {
            this.cacheTemplate.execute(this.cacheRegion, this.keyFunc.apply(req, res), (CacheCallback)new CacheCallback<String>(){

                public String doInCacheMiss() {
                    try {
                        callback.onService(req, (HttpServletResponse)buffer);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new N2oException((Throwable)e);
                    }
                    return ((CachingPrintWriter)buffer.getBuffer()).getCache();
                }

                public void doInCacheHit(String s) {
                    try (PrintWriter writer = res.getWriter();){
                        ((Writer)writer).write(s);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new N2oException((Throwable)e);
                    }
                }
            });
        }
        catch (N2oException e) {
            if (e.getMessage() != null || e.getCause() != null) {
                log.error(e.getMessage(), e.getCause());
            }
            callback.onError(e, req, res);
        }
        catch (Error | Exception e) {
            log.error(e.getMessage(), e);
            res.setStatus(500);
            callback.onError(new N2oException(e), req, res);
        }
        finally {
            buffer.getWriter().close();
            res.getWriter().close();
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheTemplate = new CacheTemplate(cacheManager);
    }

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public void setKeyFunc(BiFunction<HttpServletRequest, HttpServletResponse, Object> keyFunc) {
        this.keyFunc = keyFunc;
    }
}

