/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.mvc.api;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.N2oUserException;
import net.n2oapp.framework.mvc.api.ServletTemplate;
import net.n2oapp.framework.mvc.callback.ServletCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServletTemplate
implements ServletTemplate {
    private Logger log = LoggerFactory.getLogger(SimpleServletTemplate.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doService(HttpServletRequest req, HttpServletResponse res, ServletCallback callback) throws IOException {
        res.setContentType(callback.getContentType());
        try {
            callback.onService(req, res);
        }
        catch (Exception e) {
            String url = req.getRequestURI() + "?" + req.getQueryString();
            if (e instanceof N2oException) {
                if (e instanceof N2oUserException) {
                    this.log.debug(url + " user error:" + e.getLocalizedMessage());
                } else {
                    this.log.error(url + " system error: " + e.getMessage(), (Throwable)e);
                }
                res.setStatus(((N2oException)((Object)e)).getHttpStatus());
                callback.onError((N2oException)((Object)e), req, res);
            } else {
                this.log.error(url + " system error: " + e.getMessage(), (Throwable)e);
                res.setStatus(500);
                callback.onError(new N2oException((Throwable)e), req, res);
            }
        }
        finally {
            res.getWriter().close();
        }
    }
}

